/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.terminal;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.gui.renderer.ComboBoxEnumRenderer;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.ColourWheel;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.devices.terminal.TerminalModePanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.GTL;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.TicketDataConfig;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.stock.StockArea;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.InetAddressValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class TerminalEditor
extends AbstractObjectEditor<Terminal> {
    public static final String SHOW_PREVIOUS_QUICK_SALES_LABEL = "Show Previous Quick Sales";
    public static final String SHOW_PREVIOUS_TABLE_SALES_LABEL = "Show Previous Table Sales";
    public static final String SHOW_PREVIOUS_PHONE_SALES_LABEL = "Show Previous Phone Sales";
    private static final String SHOW_PREVIOUS_ONLINE_SALES_LABEL = "Show Previous Online Sales";
    private static final String SHOW_ONLINE_SECTIONS = "Show Online Table Sections";
    private final String nameLabel = "Name Required";
    private final String numLabel = "Stand Number Required";
    private Box generalBooleanGUI = new Box(0);
    private Box generalWaiterMateBooleanGUI = new Box(0);
    private Box orderingBooleanGUI = new Box(0);
    private Box tableBooleanGUI = new Box(0);
    private Box takeAwayBooleanGUI = new Box(0);
    private Box quickSaleBooleanGUI = new Box(0);
    private Box displayPanel = new Box(0);
    private Box phoneBooleanGUI = new Box(0);
    private FieldPanelBuilder nonBoolGeneralBuilder = new FieldPanelBuilder();
    private EventList<VirtualPrinter> virtualPrintersList;
    private EventList<TerminalLocation> terminalLocations;
    private EventList<SalesLocation> salesLocations;
    private boolean isCommonFieldsBound = false;
    private boolean isSharedFieldsBound = false;
    private boolean isWaiterMateFieldsBound = false;
    private JComboBox typeField;
    private FieldPanelBuilder currentBuilder;
    private List<FieldPanelBuilder> general = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> waiterMate = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> table = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> takeAway = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> quickSale = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> ordering = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> display = new ArrayList<FieldPanelBuilder>();
    private List<FieldPanelBuilder> phone = new ArrayList<FieldPanelBuilder>();
    private int rowCount = 0;
    private Component nameField;
    private Component ipField;
    private Component locationField;
    private Component defaultLocationField;
    private Component salesLocationField;
    private Component defaultSalesLocationField;
    private Component stockField;
    private Component cacheField;
    private Component stickyMenuField;
    private Component seatsField;
    private Component assignedCashField;
    private Component logoutField;
    private Component pinField;
    private Component saveField;
    private Component skimField;
    private Component barcodesField;
    private Component tabsField;
    private Component optionsField;
    private Component stickPlusField;
    private Component keyPadField;
    private Component gtlField;
    private Component paletteField;
    private Component quickSeatField;
    private Component bistroField;
    private Component bistroKeepOpenField;
    private Component unallocatedTableField;
    private Component deferUnallocatedTablePrep;
    private Component holdTable;
    private Component autoSelectField;
    private JCheckBox quickSaleSingleScreenOrderingField;
    private Component quickSaleTabbedMenuOrderingField;
    private Component singleScreenOrderingField;
    private Component promptForCustomDiscountReasonField;
    private Component showMakeComboInNavBarField;
    private Component widthField;
    private Component discountField;
    private Component quickQtyField;
    private Component quickTabField;
    private Component quickCustField;
    private Component quickSaleBistroModeField;
    private JCheckBox quickPrepField;
    private Component prepField;
    private Component holdTakeawayFields;
    private Component ticketDataConfigField;
    private JLabel takeAwayStandNameLabel;
    private Component takeAwayStandName;
    private JLabel takeAwayStandNumLabel;
    private Component takeAwayStandNum;
    private JLabel takeAwayAutoPromptLabel;
    private Component takeAwayAutoPrompt;
    private JLabel quickSaleAutoPromptLabel;
    private Component quickSaleAutoPrompt;
    private JLabel quicksaleTakeAwayHeader;
    private JLabel quicksaleTakeawayStandNameLabel;
    private Component quickSaleTakeAwayStandName;
    private JLabel quicksaleTakeawayStandNumLabel;
    private Component quicksaleTakeawayStandNum;
    private JLabel quicksaleDineInHeader;
    private JLabel quicksaleDineinStandNameLabel;
    private Component quicksaleDineinStandName;
    private JLabel quicksaleDineinStandNumLabel;
    private Component quicksaleDineinStandNum;
    private Component spacerComponent;
    private JTextField usernameField;
    private Component showQuantityField;
    private Component quickSaleShowQuantityField;
    private Component quickSaleOneTouchField;
    private Component quickSaleQuickTransfer;
    private Component darkLogoCheck;
    private Component showQuantityKeypad;
    private Component preauthBartabsCheck;
    private Component generalManualPrintPrep;
    private JSpinner autoSavePaidDelayField;
    private JSpinner autoSavePaidCountdownField;
    private JSpinner autoLogoutDelayField;
    private JSpinner autoLogoutCountDownField;
    private JComboBox autoPrintOnDeleteCombo;
    private JComboBox autoPrintOnAdjustmentCombo;
    private TerminalModePanel modePanel;
    private JPanel waiterMateGeneralPanel;
    private Terminal terminal;
    private JCheckBox tableTicketDataNameField;
    private JTextField minimumDelivery;
    private JCheckBox quickSalePreviousSales;
    private JCheckBox phonePreviousSales;
    private JCheckBox tablePreviousSales;
    private JCheckBox onlinePreviousSales;
    private JCheckBox showOnlineTableSections;
    private JCheckBox fingerprintScannerCheck;
    private JCheckBox useOnscreenKeyboardCheck;
    private JCheckBox enablePosiflexReader;
    private JTextField cameraLayoutField;
    private JTextField customButtonFlashTime;
    private JCheckBox loginAnimating;
    private static int ROWS = 6;

    public TerminalEditor() {
        this.setLayout(new BorderLayout());
        this.virtualPrintersList = GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters());
        this.terminalLocations = GlazedLists.eventList((Collection)TerminalLocation.getTerminalLocations());
        this.salesLocations = GlazedLists.eventList((Collection)SalesLocation.getSalesLocations());
        this.typeField = new JComboBox();
        this.typeField.setName("typeCombo");
        this.typeField.addItem("ServerMate");
        this.typeField.addItem("WaiterMate");
        this.typeField.addItem("Integration");
        this.typeField.setAction(new ChangeTypeAction());
        ComponentUtils.setupComboBox((JComboBox)this.typeField);
        this.nameField = new JTextField(20);
        this.nameField.setName("nameField");
        this.ipField = new JTextField(20);
        this.ipField.setName("ipField");
    }

    @Override
    public void setObject(Terminal toEdit) {
        this.terminal = toEdit;
        if (this.terminal.isPersistent()) {
            this.terminal = (Terminal)PersistenceManager.preload((PersistentObject)this.terminal);
        }
        if ("WaiterMate".equals(this.terminal.getTerminalType())) {
            this.modePanel = new TerminalModePanel(this.terminal);
        }
        this.typeField.setSelectedItem(this.terminal.getTerminalType());
        super.setObject(toEdit);
    }

    @Override
    public void saveObject() {
        this.terminal = (Terminal)this.getBindings().getObject();
        this.terminal.setTerminalType((String)this.typeField.getSelectedItem());
        if (this.terminal.getTerminalType().equals("WaiterMate")) {
            this.terminal.setTerminalModes(this.modePanel.getTerminalModes());
        }
        super.saveObject();
    }

    private void addRow(List<FieldPanelBuilder> list, String name, Component comp) {
        this.addRow(list, name, comp, null);
    }

    private void addRow(List<FieldPanelBuilder> list, String name, Component comp, String toolTip) {
        this.addRow(list, new JLabel(name), comp, toolTip);
    }

    private void addRow(List<FieldPanelBuilder> list, JLabel name, Component comp, String toolTip) {
        if (this.currentBuilder == null) {
            this.currentBuilder = new FieldPanelBuilder();
            list.add(this.currentBuilder);
        }
        if (comp instanceof JCheckBox) {
            if (this.rowCount < ROWS) {
                this.currentBuilder.addRow(name, comp, toolTip);
                ++this.rowCount;
            } else {
                this.currentBuilder = new FieldPanelBuilder();
                list.add(this.currentBuilder);
                this.currentBuilder.addRow(name, comp, toolTip);
                this.rowCount = 0;
            }
        } else {
            this.nonBoolGeneralBuilder.addRow(name, comp, toolTip);
        }
    }

    private JPanel getTerminalLocationPanel() {
        JPanel panel = new JPanel();
        panel.add(this.locationField);
        JLabel label = new JLabel("Default Terminal Location");
        label.setLabelFor(this.defaultLocationField);
        panel.add(label);
        panel.add(this.defaultLocationField);
        return panel;
    }

    private JPanel getSalesLocationPanel() {
        JPanel panel = new JPanel();
        panel.add(this.salesLocationField);
        JLabel label = new JLabel("Default Sales Location");
        label.setLabelFor(this.defaultSalesLocationField);
        panel.add(label);
        panel.add(this.defaultSalesLocationField);
        return panel;
    }

    private void bindCommonFields() {
        this.getBindings().createBinding(Terminal.Properties.LABEL, (Object)this.nameField, "text");
        Binding ipBinding = this.getBindings().createBinding("IPAddress", (Object)this.ipField, "text");
        ipBinding.setValidator((Validator)new InetAddressValidator());
        this.locationField = this.setupComboBox(Terminal.Properties.LOCATION, this.terminalLocations);
        this.defaultLocationField = this.setupComboBox(Terminal.Properties.DEFAULT_LOCATION, this.terminalLocations);
        this.salesLocationField = this.setupComboBox(Terminal.Properties.SALES_LOCATION, this.salesLocations);
        this.defaultSalesLocationField = this.setupComboBox(Terminal.Properties.DEFAULT_SALES_LOCATION, this.salesLocations);
        this.isCommonFieldsBound = true;
    }

    private void initSharedFields() {
        this.stockField = this.setupComboBox(Terminal.Properties.STOCK_AREA, GlazedLists.eventList((Collection)StockArea.getStockAreas()));
        this.cacheField = this.setupCheckBox(Terminal.Properties.MENU_CACHING);
        this.stickyMenuField = this.setupCheckBox(Terminal.Properties.STICKY_MENU);
        this.seatsField = this.setupCheckBox(Terminal.Properties.SEAT_NUMS);
        this.assignedCashField = this.setupCheckBox(Terminal.Properties.HAS_ASSIGNED_CASHDRAWERS);
        this.usernameField = this.setupTextField(Terminal.Properties.USERNAME, 20);
        this.usernameField.setName("usernameField");
        this.holdTable = this.setupCheckBox(Terminal.Properties.HOLD_TABLE);
        this.darkLogoCheck = this.setupCheckBox(Terminal.Properties.DARK_LOGO);
        this.showQuantityField = this.setupCheckBox(Terminal.Properties.SHOW_QUANTITY);
        this.gtlField = this.setupComboBox(Terminal.Properties.GTL, GlazedLists.eventListOf((Object[])GTL.values()));
        this.paletteField = this.setupComboBox(Terminal.Properties.PALETTE, GlazedLists.eventListOf((Object[])ColourWheel.Palette.values()));
        this.isSharedFieldsBound = true;
    }

    private void initWaiterMateGeneralFields() {
        this.logoutField = this.setupCheckBox(Terminal.Properties.QUICK_LOGOUT);
        this.pinField = this.setupCheckBox(Terminal.Properties.SHOW_PIN);
        this.saveField = this.setupCheckBox(Terminal.Properties.SAVE_BUTTON_ENABLED);
        this.skimField = this.setupCheckBox(Terminal.Properties.SKIMMING);
        this.barcodesField = this.setupCheckBox(Terminal.Properties.HAS_BARCODES);
        this.promptForCustomDiscountReasonField = this.setupCheckBox(Terminal.Properties.PROMPT_FOR_CUSTOM_DISCOUNT_REASON);
        this.generalManualPrintPrep = this.setupCheckBox(Terminal.Properties.GENERAL_MANUAL_PRINT_PREP);
        this.fingerprintScannerCheck = this.setupCheckBox(Terminal.Properties.FINGERPRINT_SCANNER);
        this.useOnscreenKeyboardCheck = this.setupCheckBox(Terminal.Properties.USE_ONSCREEN_KEYBOARD);
        this.cameraLayoutField = this.setupTextField(Terminal.Properties.CAMERA_LAYOUT, 20);
        this.enablePosiflexReader = this.setupCheckBox(Terminal.Properties.POSIFLEX_READER_ENABLED);
        this.autoSavePaidCountdownField = this.setupTimeSpinner(Terminal.Properties.AUTO_SAVE_PAID_ACC_COUNT_DOWN);
        this.autoSavePaidDelayField = this.setupTimeSpinner(Terminal.Properties.AUTO_SAVE_PAID_ACC_DELAY);
        this.autoLogoutCountDownField = this.setupTimeSpinner(Terminal.Properties.AUTO_LOGOUT_COUNT_DOWN);
        this.autoLogoutDelayField = this.setupTimeSpinner(Terminal.Properties.AUTO_LOGOUT_DELAY);
        this.autoPrintOnDeleteCombo = this.setupNullableComboBox(Terminal.Properties.AUTO_PRINT_ON_DELETE, this.virtualPrintersList, "<No Auto Printing>");
        this.autoPrintOnAdjustmentCombo = this.setupNullableComboBox(Terminal.Properties.AUTO_PRINT_ON_ADJUSTMENT, this.virtualPrintersList, "<No Auto Printing>");
        this.loginAnimating = this.setupCheckBox(Terminal.Properties.LOGIN_ANIMATING);
    }

    private void initWaiterMateOrderingFields() {
        this.tabsField = this.setupCheckBox(Terminal.Properties.TABBED_MENU_ORDERING);
        this.optionsField = this.setupCheckBox(Terminal.Properties.FORCED_OPTIONS);
        this.stickPlusField = this.setupCheckBox(Terminal.Properties.STICKY_PLUS_MINUS);
        this.keyPadField = this.setupCheckBox(Terminal.Properties.HAS_MENU_KEYPAD);
        this.quickSeatField = this.setupCheckBox(Terminal.Properties.QUICK_SEAT_SELECT);
        this.singleScreenOrderingField = this.setupCheckBox(Terminal.Properties.SINGLE_SCREEN_ORDERING);
        this.showMakeComboInNavBarField = this.setupCheckBox(Terminal.Properties.SHOW_MAKE_COMBO_IN_NAV);
        this.showQuantityKeypad = this.setupCheckBox(Terminal.Properties.SHOW_QUANTITY_KEYPAD);
        this.preauthBartabsCheck = this.setupCheckBox(Terminal.Properties.BARTAB_PREAUTH);
    }

    private void initWaiterMateTableFields() {
        this.bistroField = this.setupCheckBox(Terminal.Properties.BISTRO_MODE);
        this.bistroKeepOpenField = this.setupCheckBox(Terminal.Properties.BISTRO_KEEP_OPEN);
        this.unallocatedTableField = this.setupCheckBox(Terminal.Properties.UNALLOCATED_TABLE_ALLOWED);
        this.deferUnallocatedTablePrep = this.setupCheckBox(Terminal.Properties.DEFER_UNALLOCATED_TABLE_PREP_DOCKETS);
        this.tableTicketDataNameField = this.setupCheckBox(Terminal.Properties.TABLE_TICKET_DATA_NAME);
        this.tablePreviousSales = this.setupCheckBox(Terminal.Properties.PREVIOUS_SALES_TABLE);
        this.onlinePreviousSales = this.setupCheckBox(Terminal.Properties.PREVIOUS_SALES_ONLINE);
        this.showOnlineTableSections = this.setupCheckBox(Terminal.Properties.SHOW_ONLINE);
    }

    private void initWaiterMateTakeAwayFields() {
        this.holdTakeawayFields = this.setupCheckBox(Terminal.Properties.HOLD_TAKEAWAY);
        this.takeAwayAutoPromptLabel = new JLabel("Prompt User on Save/Pay");
        this.takeAwayStandNameLabel = new JLabel("Name Required");
        this.takeAwayStandNumLabel = new JLabel("Stand Number Required");
        this.takeAwayAutoPrompt = this.setupCheckBox(Terminal.Properties.AUTO_PROMPT_TA);
        this.takeAwayStandName = this.setupCheckBox(Terminal.Properties.TAKEAWAY_STAND_NAME);
        this.takeAwayStandNum = this.setupCheckBox(Terminal.Properties.TAKEAWAY_STAND_NUM);
        this.spacerComponent = new JLabel(" ");
    }

    private void initWaiterMateQuickSaleFields() {
        this.autoSelectField = this.setupCheckBox(Terminal.Properties.HAS_AUTO_MENU_SELECT);
        this.quickSaleSingleScreenOrderingField = this.setupCheckBox(Terminal.Properties.QUICK_SALE_SINGLE_SCREEN_ORDERING);
        this.quickSaleTabbedMenuOrderingField = this.setupCheckBox(Terminal.Properties.QUICK_SALE_TABBED_MENU_ORDERING);
        this.discountField = this.setupCheckBox(Terminal.Properties.QUICK_DISCOUNT);
        this.quickQtyField = this.setupCheckBox(Terminal.Properties.QUICKSALE_QTY_KEYPAD);
        this.quickCustField = this.setupCheckBox(Terminal.Properties.QUICK_CUSTOMER);
        this.quickSaleBistroModeField = this.setupCheckBox(Terminal.Properties.QUICKSALE_BISTRO_MODE);
        this.quickTabField = this.setupCheckBox(Terminal.Properties.PAY_TAB_DEBTOR);
        this.quickPrepField = this.setupCheckBox(Terminal.Properties.PRINT_PREP_AS_ORDERING);
        this.prepField = this.setupCheckBox(Terminal.Properties.MANUALLY_PRINT_PREP);
        this.quickSaleShowQuantityField = this.setupCheckBox(Terminal.Properties.QUICK_SALE_SHOW_QUANTITY);
        this.quickSaleOneTouchField = this.setupCheckBox(Terminal.Properties.QUICK_SALE_ONE_TOUCH);
        this.quickSaleQuickTransfer = this.setupCheckBox(Terminal.Properties.QUICK_SALE_QUICK_TRANSFER);
        this.quickSalePreviousSales = this.setupCheckBox(Terminal.Properties.PREVIOUS_SALES_QUICKSALE);
        this.widthField = this.setupIntSpinner(Terminal.Properties.QUICK_SALE_MENU_WIDTH, 1, 1, 100, 20, 5);
        this.mutuallyExclusiveCheckBoxes(this.quickPrepField, this.quickSaleSingleScreenOrderingField);
        this.quicksaleDineInHeader = new JLabel(HtmlUtils.html((String)HtmlUtils.boldColor((String)"Dine In Accounts", (String)"Black")));
        this.quicksaleTakeAwayHeader = new JLabel(HtmlUtils.html((String)HtmlUtils.boldColor((String)"Take Away Accounts", (String)"Black")));
        this.ticketDataConfigField = this.setupComboBox(Terminal.Properties.TICKET_DATA_CONFIG, GlazedLists.eventListOf((Object[])TicketDataConfig.values()));
        ((JComboBox)this.ticketDataConfigField).setRenderer(new ComboBoxEnumRenderer("getLabel"));
        this.quickSaleAutoPromptLabel = new JLabel("Prompt User on Save/Pay");
        this.quickSaleAutoPrompt = this.setupCheckBox(Terminal.Properties.AUTO_PROMPT_QS);
        this.quicksaleTakeawayStandNameLabel = new JLabel("Name Required");
        this.quicksaleTakeawayStandNumLabel = new JLabel("Stand Number Required");
        this.quicksaleDineinStandNameLabel = new JLabel("Name Required");
        this.quicksaleDineinStandNumLabel = new JLabel("Stand Number Required");
        this.quickSaleTakeAwayStandName = this.setupCheckBox(Terminal.Properties.QUICKSALE_TAKEAWAY_STAND_NAME);
        this.quicksaleTakeawayStandNum = this.setupCheckBox(Terminal.Properties.QUICKSALE_TAKEAWAY_STAND_NUM);
        this.quicksaleDineinStandName = this.setupCheckBox(Terminal.Properties.QUICKSALE_DINEIN_STAND_NAME);
        this.quicksaleDineinStandNum = this.setupCheckBox(Terminal.Properties.QUICKSALE_DINEIN_STAND_NUM);
    }

    private void initWaiterMatePhoneFields() {
        this.minimumDelivery = this.setupPriceField((PropertiedObject.Property<Price>)Terminal.Properties.MINIMUM_DELIVERY_ORDER, 10);
        this.phonePreviousSales = this.setupCheckBox(Terminal.Properties.PREVIOUS_SALES_PHONE);
        this.customButtonFlashTime = this.setupTextField(Terminal.Properties.CUSTOM_BUTTON_FLASH_TIME, 3);
    }

    private void addCommonFields() {
        if (!this.isCommonFieldsBound) {
            this.bindCommonFields();
        }
        this.nonBoolGeneralBuilder.addRow("Terminal Type", (Component)this.typeField);
        this.nonBoolGeneralBuilder.addRow("Name", this.nameField);
        this.nonBoolGeneralBuilder.addRow("IP Address", this.ipField);
    }

    private void addGeneralFields() {
        if (!this.isSharedFieldsBound) {
            this.initSharedFields();
        }
        this.rowCount = 0;
        this.currentBuilder = null;
        this.nonBoolGeneralBuilder.addRow("Terminal Location", (Component)this.getTerminalLocationPanel());
        this.nonBoolGeneralBuilder.addRow("Sales Location", (Component)this.getSalesLocationPanel());
        this.nonBoolGeneralBuilder.addRow("Stock Area", this.stockField, "The area to decrement stock from when items are ordered from this terminal.");
        this.addRow(this.general, "Cache Menu", this.cacheField, "Cache the menu to make ordering faster");
        this.addRow(this.general, "Sticky Menu", this.stickyMenuField, "Order many items at a time");
        this.addRow(this.general, "Seat Numbers", this.seatsField, "Use seat numbers when ordering to tables");
        this.addRow(this.general, "Assigned Cash Drawers", this.assignedCashField, "Cash drawers are assigned to users");
    }

    private void addWaiterMateGeneralFields() {
        this.currentBuilder = null;
        this.rowCount = -1;
        this.addRow(this.waiterMate, "Quick Logout", this.logoutField, "Log out after completeing an order");
        this.addRow(this.waiterMate, "PIN Login", this.pinField, "Users can log into the terminal with a PIN number");
        this.addRow(this.waiterMate, "Fingerprint Scanner", (Component)this.fingerprintScannerCheck, "Sets whether the terminal uses an attached fingerprint scanner.");
        this.addRow(this.waiterMate, "Dark Logo", this.darkLogoCheck, "Sets the displayed OrderMate logo to a darker version for dimly lit venues.");
        this.addRow(this.waiterMate, "Login Screen Animation", (Component)this.loginAnimating, "Enables the logo and shine animations on the WaiterMate login screen.");
        this.addRow(this.waiterMate, "Allow Save", this.saveField, "Changes to accounts can be saved on this terminal");
        this.addRow(this.waiterMate, "Skimming", this.skimField, "Enable skimming from this terminal");
        this.addRow(this.waiterMate, "Barcodes", this.barcodesField, "Manage barcodes from WaiterMate");
        this.addRow(this.waiterMate, "Prompt for custom discount reason", this.promptForCustomDiscountReasonField, "Prompt the user for a reason when a custom discount is being applied.");
        this.addRow(this.waiterMate, "Print Order", this.generalManualPrintPrep, "Sets whether the user may manually print the print docket in a general account.");
        this.addRow(this.waiterMate, "Use Onscreen Keyboard", (Component)this.useOnscreenKeyboardCheck, "Sets whether the terminal favours the onscreen keyboard for input.");
        this.addRow(this.waiterMate, "Camera View Layout", (Component)this.cameraLayoutField, "Sets the camera layout to use when viewing this terminal's events");
        this.addRow(this.waiterMate, "Posiflex Reader", (Component)this.enablePosiflexReader, "Sets whether the terminal to read input from the Posiflex Reader.");
    }

    private void addWaiterMateOrderingFields() {
        this.currentBuilder = null;
        this.rowCount = 0;
        this.addRow(this.ordering, "Tabbed Menu Ordering", this.tabsField, "Menu displays sections in tabs");
        this.addRow(this.ordering, "Forced Options", this.optionsField, "Options must be selecting when ordering items");
        this.addRow(this.ordering, "Sticky Plus and Minus", this.stickPlusField, "Select multiple pluses and minuses at a time");
        this.addRow(this.ordering, "Menu Keypad", this.keyPadField, "Show the quantity keypad when ordering items");
        this.addRow(this.ordering, "Quick Seats", this.quickSeatField, "Show the seat selector when ordering items");
        this.addRow(this.ordering, "Single screen ordering", this.singleScreenOrderingField, "Display whole menu on ordering screen.  This does NOT include the quick sale screen, which is controled by 'Quick sales single screen ordering'");
        this.addRow(this.ordering, "Show Items Quantity", this.showQuantityField, "Show Items Quantity in Select Item Button");
        this.addRow(this.ordering, "Show Make Combo in Nav Bar", this.showMakeComboInNavBarField, "Display the Make Combo button in the Nav Bar of Account Items if a combo is available.");
        this.addRow(this.ordering, "Show Quantity Keypad", this.showQuantityKeypad, "Sets whether to display the quick quantity keypad when in Singel Screen Ordering.");
        this.addRow(this.ordering, "Preauth Bartabs", this.preauthBartabsCheck, "Sets whether bartabs can be configured using eftpos preauthorisation");
    }

    private void addWaiterMateTableFields() {
        this.currentBuilder = null;
        this.rowCount = 0;
        this.addRow(this.table, "Graphical Table Layout", this.gtlField, "Switch between classic and graphic table display");
        this.addRow(this.table, "Palette", this.paletteField, "Defines the colours used for displaying links");
        this.addRow(this.table, "Bistro Mode", this.bistroField, "Support for customers paying as they order");
        this.addRow(this.table, "Bistro Mode Keep Open", this.bistroKeepOpenField, "Allow a table to remain open after paying off.");
        this.addRow(this.table, "Unallocated table mode", this.unallocatedTableField, "Can create table accounts that are not yet allocated to a table.");
        this.addRow(this.table, "Defer unallocated prep docket printing", this.deferUnallocatedTablePrep, "Unallocated table will not print a prep docket until a table is assigned to the account when this is checked.");
        this.addRow(this.table, "Show name on unallocated", (Component)this.tableTicketDataNameField, "Turn on name ticket data for unallocated tables.");
        this.addRow(this.table, "Hold table", this.holdTable, "Allow tables to be put on hold at this terminal.");
        this.addRow(this.table, SHOW_PREVIOUS_TABLE_SALES_LABEL, (Component)this.tablePreviousSales, "Show a Previous Sales button on the Table tab");
        this.addRow(this.table, SHOW_PREVIOUS_ONLINE_SALES_LABEL, (Component)this.onlinePreviousSales, "Show a Previous Sales button on the Online tab");
        this.addRow(this.table, SHOW_ONLINE_SECTIONS, (Component)this.showOnlineTableSections, "Show Online Table Sections in Waitermate");
    }

    private void addWaiterMateTakeAwayFields() {
        this.currentBuilder = new FieldPanelBuilder();
        this.takeAway.add(this.currentBuilder);
        this.rowCount = 0;
        this.currentBuilder.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Order Info Requirements"));
        this.currentBuilder.addRow(" ", this.spacerComponent);
        this.addRow(this.takeAway, this.takeAwayAutoPromptLabel, this.takeAwayAutoPrompt, "Enable if you want to auto prompt for the name of the customer on Take Away orders");
        this.addRow(this.takeAway, this.takeAwayStandNameLabel, this.takeAwayStandName, "Enable if you want to enter the name of the customer on Take Away orders");
        this.addRow(this.takeAway, this.takeAwayStandNumLabel, this.takeAwayStandNum, "Enable if you want to enter the stand number on Take Away orders");
        this.currentBuilder.addRow(" ", this.spacerComponent);
        this.currentBuilder = new FieldPanelBuilder();
        this.takeAway.add(this.currentBuilder);
        this.rowCount = 0;
        this.addRow(this.takeAway, "Hold Takeaway", this.holdTakeawayFields);
    }

    private void addWaiterMateQuickSaleFields() {
        this.currentBuilder = null;
        this.rowCount = 0;
        this.addRow(this.quickSale, "Auto Select", this.autoSelectField, "Automatically select the first menu section");
        this.addRow(this.quickSale, "Quick Sale single screen ordering", (Component)this.quickSaleSingleScreenOrderingField, "Display whole menu on the QuickSale ordering screen");
        this.addRow(this.quickSale, "Quick Sale tabbed menu ordering", this.quickSaleTabbedMenuOrderingField, "Menu displays sections in tabs on the QuickSale orderingscreen");
        this.addRow(this.quickSale, "Quick Discount", this.discountField, "Show a discount button on QuickSale nav");
        this.addRow(this.quickSale, "Quick Quantity", this.quickQtyField, "Show a quantity keypad in the QuickSale screen");
        this.addRow(this.quickSale, "Quick Customer", this.quickCustField, "Show a customer button on QuickSale nav");
        this.addRow(this.quickSale, "Quicksale Bistro Mode", this.quickSaleBistroModeField, "When an order has a stand number/Name attached, prompt the user to ask if there are more people ordering on the account before closing off and printing to kitchen after each payment");
        this.addRow(this.quickSale, "Quick Tab/Debtor", this.quickTabField, "Show a Tab/Debtor button in the QuickSale nav");
        this.addRow(this.quickSale, "Quick Prep", (Component)this.quickPrepField, "Print the prep docket as soon as an item is ordered");
        this.addRow(this.quickSale, "Print Order", this.prepField, "Show a print order button on QuickSale Nav");
        this.addRow(this.quickSale, "Quick Sale Show Items Quantity", this.quickSaleShowQuantityField, "Show Items Quantity in Select Item Button");
        this.addRow(this.quickSale, "Quick Sale One Touch Payment", this.quickSaleOneTouchField, "Use one touch Quick Sale payment");
        this.addRow(this.quickSale, "Quick Transfer", this.quickSaleQuickTransfer, "Turn on quick transfer for quick sale.");
        this.addRow(this.quickSale, SHOW_PREVIOUS_QUICK_SALES_LABEL, (Component)this.quickSalePreviousSales, "Display a Show Previous Sales button in the quick sale tab");
        this.currentBuilder = new FieldPanelBuilder();
        this.quickSale.add(this.currentBuilder);
        this.rowCount = 0;
        this.currentBuilder.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Order Info Requirements"));
        this.currentBuilder.addRow(" ", this.spacerComponent);
        this.currentBuilder.addRow("Prompt Order", this.ticketDataConfigField, "The order you want the prompts to show in. Also dictates whether or not to show the 'Dine In or Take Away?' prompt");
        this.currentBuilder.addRow(" ", this.spacerComponent);
        this.currentBuilder.addRow(this.quickSaleAutoPromptLabel, this.quickSaleAutoPrompt, "Enable if you want to auto prompt for the name of the customer on Take Away orders");
        this.currentBuilder.addRow(this.quicksaleTakeAwayHeader, (Component)new JLabel(""), "Prompt Order options for take away orders");
        this.currentBuilder.addRow(this.quicksaleTakeawayStandNameLabel, this.quickSaleTakeAwayStandName, "Enable if you want to enter the name of the customer on Take Away orders");
        this.currentBuilder.addRow(this.quicksaleTakeawayStandNumLabel, this.quicksaleTakeawayStandNum, "Enable if you want to enter the stand number on Take Away orders");
        this.currentBuilder.addRow(" ", this.spacerComponent);
        this.currentBuilder.addRow(this.quicksaleDineInHeader, (Component)new JLabel(""), "Prompt Order options for dine in orders");
        this.currentBuilder.addRow(this.quicksaleDineinStandNameLabel, this.quicksaleDineinStandName, "Enable if you want to enter the name of the customer on Dine In orders");
        this.currentBuilder.addRow(this.quicksaleDineinStandNumLabel, this.quicksaleDineinStandNum, "Enable if you want to enter the stand number on Dine In orders");
        this.currentBuilder.addRow(" ", this.spacerComponent);
    }

    private void initialiseAndBindAllWaiterMateFields() {
        this.initWaiterMateGeneralFields();
        this.initWaiterMateOrderingFields();
        this.initWaiterMateTableFields();
        this.initWaiterMateTakeAwayFields();
        this.initWaiterMateQuickSaleFields();
        this.initWaiterMatePhoneFields();
        this.isWaiterMateFieldsBound = true;
    }

    private void addAllWaiterMateFields() {
        if (!this.isWaiterMateFieldsBound) {
            this.initialiseAndBindAllWaiterMateFields();
        }
        this.addWaiterMateGeneralFields();
        this.addWaiterMateOrderingFields();
        this.addWaiterMateTableFields();
        this.addWaiterMateTakeAwayFields();
        this.addWaiterMateQuickSaleFields();
    }

    private void addWaiterMateFields() {
        this.addRow(this.general, "Username", (Component)this.usernameField, "Username for this Waitermate terminal, leave blank for any.");
        this.addAllWaiterMateFields();
        this.waiterMateGeneralPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        JPanel autoSave = new JPanel(new FlowLayout(2));
        autoSave.add(new JLabel("  Auto Save: "));
        autoSave.setToolTipText("Delays a number of seconds before showing the count down dialog to automatically save a paid account. (Max 7200)");
        JLabel label = new JLabel("Delay (sec)");
        label.setLabelFor(this.autoSavePaidDelayField);
        autoSave.add(label);
        autoSave.add(this.autoSavePaidDelayField);
        label = new JLabel("Countdown (sec)");
        label.setLabelFor(this.autoSavePaidCountdownField);
        autoSave.add(label);
        autoSave.add(this.autoSavePaidCountdownField);
        this.waiterMateGeneralPanel.add(autoSave);
        JPanel autoLogout = new JPanel(new FlowLayout(2));
        autoLogout.add(new JLabel("Auto Logout: "));
        autoLogout.setToolTipText("Delays a number of seconds before showing a countdown dialog to automatically logout (Max 7200)");
        label = new JLabel("Delay (sec)");
        label.setLabelFor(this.autoLogoutDelayField);
        autoLogout.add(label);
        autoLogout.add(this.autoLogoutDelayField);
        label = new JLabel("Countdown (sec)");
        autoLogout.add(label);
        autoLogout.add(this.autoLogoutCountDownField);
        this.waiterMateGeneralPanel.add(autoLogout);
        JPanel autoPrintOnDeletePanel = new JPanel(new FlowLayout(2));
        label = new JLabel("Auto Print on Delete Printer");
        label.setLabelFor(this.autoPrintOnDeleteCombo);
        autoPrintOnDeletePanel.add(label);
        this.autoPrintOnDeleteCombo.setToolTipText("Automatically prints a receipt of a saved account if items are deleted.");
        autoPrintOnDeletePanel.add(this.autoPrintOnDeleteCombo);
        this.waiterMateGeneralPanel.add(autoPrintOnDeletePanel);
        JPanel autoPrintOnAdjustmentPanel = new JPanel(new FlowLayout(2));
        label = new JLabel("Auto Print on Adjustment Printer");
        label.setLabelFor(this.autoPrintOnAdjustmentCombo);
        autoPrintOnAdjustmentPanel.add(label);
        this.autoPrintOnAdjustmentCombo.setToolTipText("Automatically prints a receipt of a saved account if an account has adjustments.");
        autoPrintOnAdjustmentPanel.add(this.autoPrintOnAdjustmentCombo);
        this.waiterMateGeneralPanel.add(autoPrintOnAdjustmentPanel);
    }

    private void createGUI() {
        String type = (String)this.typeField.getSelectedItem();
        assert (type != null) : "Oops, no type selected for the gui to create";
        this.addCommonFields();
        if (type.equals("WaiterMate")) {
            this.addGeneralFields();
            this.addWaiterMateFields();
        } else if (type.equals("ServerMate")) {
            this.nonBoolGeneralBuilder.addRow("Terminal Locations", (Component)this.getTerminalLocationPanel());
            this.nonBoolGeneralBuilder.addRow("Sales Locations", (Component)this.getSalesLocationPanel());
            this.addGeneralFields();
            this.addServerMateFields();
        }
        for (FieldPanelBuilder builder : this.general) {
            this.generalBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.waiterMate) {
            this.generalWaiterMateBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.ordering) {
            this.orderingBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.table) {
            this.tableBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.takeAway) {
            this.takeAwayBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.quickSale) {
            this.quickSaleBooleanGUI.add(builder.getPanel());
        }
        for (FieldPanelBuilder builder : this.display) {
            this.displayPanel.add(builder.getPanel());
        }
        if (type.equals("WaiterMate")) {
            JPanel waiterMateGeneral = new JPanel();
            JTabbedPane tab = new JTabbedPane();
            tab.add("General", this.generalBooleanGUI);
            waiterMateGeneral.add((Component)this.waiterMateGeneralPanel, "North");
            waiterMateGeneral.add((Component)this.generalWaiterMateBooleanGUI, "Center");
            tab.add("General WaiterMate", waiterMateGeneral);
            tab.add("Ordering", this.orderingBooleanGUI);
            tab.add("Table", this.tableBooleanGUI);
            tab.add("Take Away", this.takeAwayBooleanGUI);
            tab.add("Quick Sale", this.makeQuickSalePanel());
            tab.add("Terminal Modes", this.modePanel);
            tab.add("Phone", new TerminalEditorPhonePanel());
            this.add(tab);
        }
        this.add((Component)this.nonBoolGeneralBuilder.getPanel(), "North");
        this.revalidate();
        this.repaint();
    }

    private void addServerMateFields() {
        this.addRow(this.general, "Graphical Table Layout", this.gtlField, "Switch between classic and graphic table display");
    }

    private JPanel makeQuickSalePanel() {
        JPanel quickSalePanel = new JPanel(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Menu Width (%)", this.widthField, "Width of the menu panel in the QuickSale screen");
        quickSalePanel.add((Component)builder.getPanel(), "North");
        quickSalePanel.add((Component)this.quickSaleBooleanGUI, "Center");
        return quickSalePanel;
    }

    @Override
    public void refresh() {
        try {
            this.virtualPrintersList.getReadWriteLock().writeLock().lock();
            this.virtualPrintersList.clear();
            this.virtualPrintersList.addAll((Collection)VirtualPrinter.getAllPrinters());
            if (this.autoPrintOnAdjustmentCombo != null) {
                ((NullableEventComboBoxModel)this.autoPrintOnAdjustmentCombo.getModel()).prependNullPlaceholder(this.virtualPrintersList);
            }
            GlazedListUtils.setAsList(this.terminalLocations, (Collection)TerminalLocation.getTerminalLocations());
        }
        finally {
            this.virtualPrintersList.getReadWriteLock().writeLock().unlock();
        }
        super.refresh();
    }

    private void mutuallyExclusiveCheckBoxes(final JCheckBox box1, final JCheckBox box2) {
        ActionListener listener = new ActionListener(){
            private boolean isSettingMutualExclusion = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.isSettingMutualExclusion) {
                    this.isSettingMutualExclusion = true;
                    JCheckBox checkBox = (JCheckBox)e.getSource();
                    if (checkBox.isSelected()) {
                        this.getOther(checkBox).setSelected(false);
                    }
                }
                this.isSettingMutualExclusion = false;
            }

            private JCheckBox getOther(JCheckBox current) {
                if (box1.equals(current)) {
                    return box2;
                }
                return box1;
            }
        };
        box1.addActionListener(listener);
        box2.addActionListener(listener);
    }

    private class TerminalEditorPhonePanel
    extends JPanel {
        TerminalEditorPhonePanel() {
            super(new BorderLayout());
            FieldPanelBuilder builder = new FieldPanelBuilder();
            builder.addRow("Minimum Delivery Order", (Component)TerminalEditor.this.minimumDelivery, "The minimum fee which a delivery is allowed or surcharged.");
            builder.addRow(TerminalEditor.SHOW_PREVIOUS_PHONE_SALES_LABEL, (Component)TerminalEditor.this.phonePreviousSales, "Show Previous Sales Button in the Phone Tab");
            builder.addRow("Caller ID Button Flash Time (seconds > 0)", (Component)TerminalEditor.this.customButtonFlashTime, "Set a custom time for the Caller ID button to flash, specify in number of seconds. A value greater than zero will enable.");
            this.add((Component)builder.getPanel(), "Center");
        }
    }

    private class ChangeTypeAction
    extends AbstractAction {
        private ChangeTypeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TerminalEditor.this.typeField.getSelectedIndex() < 0) {
                return;
            }
            TerminalEditor.this.removeAll();
            TerminalEditor.this.generalBooleanGUI.removeAll();
            TerminalEditor.this.generalWaiterMateBooleanGUI.removeAll();
            TerminalEditor.this.orderingBooleanGUI.removeAll();
            TerminalEditor.this.tableBooleanGUI.removeAll();
            TerminalEditor.this.takeAwayBooleanGUI.removeAll();
            TerminalEditor.this.quickSaleBooleanGUI.removeAll();
            TerminalEditor.this.displayPanel.removeAll();
            TerminalEditor.this.phoneBooleanGUI.removeAll();
            TerminalEditor.this.general.clear();
            TerminalEditor.this.ordering.clear();
            TerminalEditor.this.waiterMate.clear();
            TerminalEditor.this.table.clear();
            TerminalEditor.this.takeAway.clear();
            TerminalEditor.this.quickSale.clear();
            TerminalEditor.this.display.clear();
            TerminalEditor.this.phone.clear();
            TerminalEditor.this.currentBuilder = null;
            TerminalEditor.this.nonBoolGeneralBuilder = new FieldPanelBuilder();
            TerminalEditor.this.rowCount = 0;
            TerminalEditor.this.createGUI();
            TerminalEditor.this.getRootPane().validate();
        }
    }
}

