/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.terminal;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.adminkit.AddRemoveButtonPanel;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.screens.setup.devices.terminal.TerminalModeTableFormat;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.users.AllPermissions;

public class TerminalModePanel
extends AbstractObjectEditor {
    private Terminal terminal;
    private EventList<TerminalMode> terminalModes;
    private PersistentObjectTable<TerminalMode> terminalModesTable;

    public TerminalModePanel(Terminal theTerminal) {
        this.setLayout(new BorderLayout());
        this.terminal = theTerminal;
        this.terminalModes = new BasicEventList();
        this.terminalModes.addAll((Collection)this.terminal.getTerminalModes());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalModePanel.this.terminalModesTable = new PersistentObjectTable(TerminalModePanel.this.terminalModes, new TerminalModeTableFormat());
                TerminalModePanel.this.terminalModesTable.setSize(TerminalModePanel.this.terminalModesTable.getTable().getSize());
                TerminalModePanel.this.terminalModesTable.setPreferredSize(TerminalModePanel.this.terminalModesTable.getTable().getSize());
                TerminalModePanel.this.add((Component)TerminalModePanel.this.terminalModesTable, "Center");
                JPanel buttonContainer = new JPanel(new BorderLayout());
                buttonContainer.add((Component)TerminalModePanel.this.setupButtonPanel(), "North");
                TerminalModePanel.this.add((Component)buttonContainer, "East");
            }
        });
    }

    private JPanel setupButtonPanel() {
        AddRemoveButtonPanel buttonPanel = new AddRemoveButtonPanel.AddRemovePanelBuilder().setAllowAdd(true).setAllowRemove(true).setAllowEdit(false).setCrudPermissions(AllPermissions.CONFIG_TERMINAL_MODES).build();
        buttonPanel.addAddActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TerminalModePanel.this.addObject();
            }
        });
        buttonPanel.addRemoveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TerminalModePanel.this.removeObject();
            }
        });
        this.terminalModesTable.addSelectionDependentAction(buttonPanel.getRemoveAction());
        return buttonPanel;
    }

    public List<TerminalMode> getTerminalModes() {
        return new ArrayList<TerminalMode>((Collection<TerminalMode>)this.terminalModes);
    }

    private void addObject() {
        TerminalMode mode = new TerminalMode("Tables");
        this.terminalModes.add((Object)mode);
    }

    private void removeObject() {
        int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you wish to delete the selected Terminal Mode? \nThis operation cannot be undone.", "Delete supplier?", 0, 2);
        if (result == 0) {
            TerminalMode modeToDelete = this.terminalModesTable.getSelectedObject();
            this.terminalModes.remove((Object)modeToDelete);
        }
    }
}

