/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.terminal;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.devices.terminal.TerminalEditor;
import ordermate.LogoutLocalWM;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;

public class TerminalState
extends AbstractEditableTableState<Terminal> {
    private TerminalEditor editor;

    public TerminalState() {
        super("Terminals", null, "View, add and configure terminals.");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addSelectionDependentAction((Action)((Object)new CopyTerminalAction()));
        this.addAction((Action)((Object)new LocalLogoutAction()));
    }

    @Override
    public ObjectEditor<Terminal> createObjectEditor() {
        this.editor = new TerminalEditor();
        return this.editor;
    }

    @Override
    public String getTypeName() {
        return "Terminal";
    }

    @Override
    public TableStateCentralArea<Terminal> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(Terminal.COMMON_PROPS);
        PersistentObjectTable<Terminal> gui = new PersistentObjectTable<Terminal>(this.getObjectList(), format);
        return gui;
    }

    @Override
    public Class<Terminal> getDisplayingType() {
        return Terminal.class;
    }

    private boolean checkCreateAllowed() {
        ObjectQuery query = Query.select(Terminal.class).active(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, (Object)"WaiterMate");
        List waitermateTerminals = PersistenceManager.getObjectList(Terminal.class, (String)query.toString(), (Object[])new Object[0]);
        PersistentLicenseManager.getInstance().refreshCachedLicenses();
        if (waitermateTerminals.size() >= PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.NumWaitermateTerminals)) {
            Dialogs.showErrorDialog("Cannot create new Terminal.", "You are at the maximum for waitermate terminals.Cannot create a new terminal.");
            return false;
        }
        return true;
    }

    protected void createCopy() {
        Terminal toCopy = (Terminal)this.getCentralArea().getSelectedObject();
        if (toCopy == null) {
            throw new IllegalArgumentException("No terminal selected, cannot copy");
        }
        Terminal newTerminal = toCopy.copy();
        newTerminal.setLabel(toCopy.getLabel() + " - Copy");
        newTerminal.save();
        this.getObjectList().add((Object)newTerminal);
    }

    @Override
    public void gotObjectEdited(Terminal value) {
        ObjectQuery query;
        FailoverSetup setup;
        super.gotObjectEdited(value);
        if (value != null && "ServerMate".equals(value.getTerminalType()) && value.isPersistent() && (setup = (FailoverSetup)PersistenceManager.getObject(FailoverSetup.class, (String)(query = Query.select(FailoverSetup.class).equals(FailoverSetup.Properties.TERMINAL, (Object)value)).toString(), null)) == null) {
            setup = new FailoverSetup(value);
            query = Query.select(FailoverSetup.class).equals(FailoverSetup.Properties.SLAVE, (Object)Boolean.FALSE);
            FailoverSetup master = (FailoverSetup)PersistenceManager.getObject(FailoverSetup.class, (String)query.toString(), null);
            if (master != null) {
                setup.setMasterHost(master.getTerminal().getIPAddress());
                setup.setMasterPort(master.getMasterPort());
            }
            setup.save();
        }
    }

    @Override
    protected void doDelete(List<Terminal> terminals) {
        for (Terminal terminal : terminals) {
            ObjectQuery query;
            FailoverSetup setup;
            if (!"ServerMate".equals(terminal.getTerminalType()) || !terminal.isPersistent() || (setup = (FailoverSetup)PersistenceManager.getObject(FailoverSetup.class, (String)(query = Query.select(FailoverSetup.class).equals(FailoverSetup.Properties.TERMINAL, (Object)terminal)).toString(), null)) == null) continue;
            setup.delete();
        }
        super.doDelete(terminals);
    }

    @Override
    protected Terminal createNewObject() {
        try {
            if (!this.checkCreateAllowed()) {
                return null;
            }
            Terminal t = new Terminal(null, "WaiterMate");
            return t;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unable to create a new terminal", (Throwable)e);
            return null;
        }
    }

    @Override
    public OfficeMateObjectSearch<Terminal> createSearchPanelFactory() {
        return new ObjectPropertySearch<Terminal>(Terminal.class){

            @Override
            protected ObjectQuerySearcher<Terminal> getPropertySearcher() {
                DefaultPropertySearcher searcher = (DefaultPropertySearcher)super.getPropertySearcher();
                searcher.setBaseQuery(Query.select(Terminal.class).active(Terminal.class));
                return searcher;
            }
        };
    }

    private class LocalLogoutAction
    extends BasicAction {
        public LocalLogoutAction() {
            super("Logout User", (Icon)IconLoader.get((String)"/officemate/images/exit.png"), "Log out a remote WM user");
        }

        public void actionPerformed(ActionEvent e) {
            new LogoutLocalWM((GuiHandler)new OfficeMateGuiHandler()).start();
        }
    }

    private class CopyTerminalAction
    extends BasicAction {
        CopyTerminalAction() {
            super("Create Copy", (Icon)IconLoader.get((String)"/officemate/images/copy.png"), "Creates a new terminal as a copy of the selected one.");
        }

        public void actionPerformed(ActionEvent e) {
            TerminalState.this.createCopy();
        }
    }
}

