/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.virtualprinter;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import ordermate.database.hardware.PrinterSummary;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.AccountType;

public class PrinterSummaryManager {
    private JComboBox printerSummaryCombo = new JComboBox();
    private EventComboBoxModel printerSummaryModel;
    private JCheckBoxCellRenderer printerSummaryJCheckBoxCellRenderer;
    private List<String> allAccountTypes;
    private List<PrinterSummary> allPrinterSummaries;
    private List<PrinterSummary> oldPrinterSummaries;
    private VirtualPrinter virtualPrinter;

    public PrinterSummaryManager() {
        this.printerSummaryCombo.setName("Printer Summary");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.printerSummaryCombo);
        this.printerSummaryJCheckBoxCellRenderer = JCheckBoxCellRenderer.install((JComboBox)this.printerSummaryCombo, (String)"Any");
        this.allAccountTypes = new ArrayList<String>();
        for (AccountType at : AccountType.getTypes()) {
            this.allAccountTypes.add(at.getLabel());
        }
        this.printerSummaryModel = new EventComboBoxModel(GlazedLists.eventList(this.allAccountTypes));
        this.printerSummaryCombo.setModel(this.printerSummaryModel);
        this.allPrinterSummaries = PrinterSummary.getAllPrinterSummaries();
    }

    private void setUp() {
        this.setUp(this.virtualPrinter);
    }

    public void setUp(Object toEdit) {
        VirtualPrinter vPrinter = (VirtualPrinter)toEdit;
        ArrayList<String> selected = new ArrayList<String>();
        this.oldPrinterSummaries = new ArrayList<PrinterSummary>();
        for (PrinterSummary ps : this.allPrinterSummaries) {
            if (vPrinter == null || !vPrinter.equals((Object)ps.getVirtualPrinter())) continue;
            String temp = ps.getAccountType();
            temp = StringUtils.underscoreToDisplayable((String)temp);
            selected.add(temp);
            this.oldPrinterSummaries.add(ps);
        }
        this.printerSummaryJCheckBoxCellRenderer.setSelectedElements(selected);
        this.virtualPrinter = vPrinter;
    }

    protected LinkedHashSet getChecked() {
        return this.printerSummaryJCheckBoxCellRenderer.getSelectedElements();
    }

    protected List<PrinterSummary> getOldPrinterSummaries() {
        return this.oldPrinterSummaries;
    }

    public void save() {
        this.saveAddedPrinterSummaries();
        this.deleteRemovedPrinterSummaries();
        this.setUp();
    }

    private void saveAddedPrinterSummaries() {
        for (Object s : this.getChecked()) {
            String element = (String)s;
            boolean wasFound = false;
            for (PrinterSummary ps : this.getOldPrinterSummaries()) {
                String temp = ps.getAccountType();
                if (element.compareToIgnoreCase(temp = StringUtils.underscoreToDisplayable((String)temp)) != 0) continue;
                wasFound = true;
            }
            if (wasFound) continue;
            PrinterSummary newPS = new PrinterSummary();
            newPS.setVirtualPrinter(this.virtualPrinter);
            element = element.toUpperCase();
            element = element.replace(' ', '_');
            newPS.setAccountType(element);
            newPS.save();
        }
    }

    private void deleteRemovedPrinterSummaries() {
        for (PrinterSummary ps : this.getOldPrinterSummaries()) {
            String temp = ps.getAccountType();
            temp = StringUtils.underscoreToDisplayable((String)temp);
            boolean wasFound = false;
            for (Object s : this.getChecked()) {
                String element = (String)s;
                if (temp.compareToIgnoreCase(element) != 0) continue;
                wasFound = true;
            }
            if (wasFound) continue;
            ps.delete();
        }
    }

    public JComboBox getPrinterSummaryCombo() {
        return this.printerSummaryCombo;
    }

    public EventComboBoxModel getPrinterSummaryModel() {
        return this.printerSummaryModel;
    }

    public JCheckBoxCellRenderer getPrinterSummaryJCheckBoxCellRenderer() {
        return this.printerSummaryJCheckBoxCellRenderer;
    }

    public List<String> getAllAccountTypes() {
        return this.allAccountTypes;
    }
}

