/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.virtualprinter;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import officemate.components.strategy.AuditableInstantSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.devices.virtualprinter.VirtualPrinterEditor;
import ordermate.database.hardware.PrinterSummary;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class VirtualPrinterState
extends AbstractEditableTableState {
    private PersistentObjectTable centralArea;
    private static final Format noSquareBracesFormat = new Format(){

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            String formattedString = obj.toString();
            formattedString = formattedString.substring(1, formattedString.length() - 1);
            toAppendTo.append(formattedString);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    };
    private static final Format printerSummaryFormat = new Format(){

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            ArrayList listPS = new ArrayList();
            listPS.addAll((List)obj);
            if (listPS.size() > 0) {
                toAppendTo.append(StringUtils.underscoreToDisplayable((String)((PrinterSummary)listPS.get(0)).getAccountType()));
                for (int i = 1; i < listPS.size(); ++i) {
                    toAppendTo.append(", ").append(StringUtils.underscoreToDisplayable((String)((PrinterSummary)listPS.get(i)).getAccountType()));
                }
            }
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    };

    public VirtualPrinterState() {
        super("Virtual Printers", null, "View, add and configure virtual printers.");
        AuditableInstantSaveStrategy strategy = new AuditableInstantSaveStrategy();
        this.setSaveStrategy(strategy);
    }

    public ObjectEditor createObjectEditor() {
        return new VirtualPrinterEditor();
    }

    @Override
    public String getTypeName() {
        return "Virtual Printer";
    }

    @Override
    public void onEnd() {
        VirtualPrinter.clearAllPrinterCacheList();
        super.onEnd();
    }

    @Override
    public TableStateCentralArea createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(VirtualPrinter.Properties.LABEL), new PropertyColumnFormat(VirtualPrinter.Properties.PRINT_DEVICE), new PropertyColumnFormat(VirtualPrinter.Properties.DOCKET_SORTING_STRATEGY), new PropertyColumnFormat(VirtualPrinter.Properties.PREP_DOCKET_GROUPING), new PropertyColumnFormat(VirtualPrinter.Properties.PREP_DOCKET_FILE), new PropertyColumnFormat((PropertiedObject.Property)VirtualPrinter.Properties.PRINTER_SUMMARY).setFormatter(printerSummaryFormat), new PropertyColumnFormat(VirtualPrinter.Properties.NOTIFY_PRINTERS).setFormatter(noSquareBracesFormat)});
        this.centralArea = new PersistentObjectTable(this.getObjectList(), format);
        return this.centralArea;
    }

    @Override
    public Class getDisplayingType() {
        return VirtualPrinter.class;
    }
}

