/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.addremoves;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.SequenceEditor;
import officemate.screens.setup.menu.addremoves.AddRemoveSearch;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.inventory.ModificationSizeType;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.table.NumberEditorExt;

public class AddRemoveState
extends AbstractEditableTableState {
    public AddRemoveState() {
        super("Add/Removes", AllPermissions.INVENTORY_SIZES, "Add, modify and remove Adds and Removes for Plus/Minus modifications");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy(1L));
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        return new AddRemoveSearch();
    }

    protected Object createNewObject() {
        Object newObj = super.createNewObject();
        if (newObj instanceof ModificationSize) {
            ModificationSize size = (ModificationSize)newObj;
            size.setName("New Item");
            size.setType(ModificationSizeType.ADD);
            newObj = size;
        }
        return newObj;
    }

    @Override
    public String getTypeName() {
        return "Add/Removes";
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        EventComboBoxModel model = new EventComboBoxModel(GlazedLists.eventListOf((Object[])ModificationSizeType.values()));
        JComboBox<Object> editorBox = new JComboBox<Object>((ComboBoxModel<Object>)model);
        editorBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModificationSizeType type = null;
                if (value instanceof ModificationSizeType) {
                    type = (ModificationSizeType)value;
                }
                return type == null ? new JLabel("") : new JLabel(type.getLabel());
            }
        });
        EditablePropertyColumnFormat modificationSizeTypeCombo = new EditablePropertyColumnFormat(ModificationSize.Properties.TYPE).setCustomEditor((TableCellEditor)new ComboBoxCellEditor(editorBox));
        TableCellRenderer comboRend = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ModificationSizeType type = null;
                if (value instanceof ModificationSizeType) {
                    type = (ModificationSizeType)value;
                }
                return type == null ? new JLabel("") : new JLabel(type.getLabel());
            }
        };
        this.setFilterActive(true);
        return new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new EditablePropertyColumnFormat(ModificationSize.Properties.NAME), new EditablePropertyColumnFormat("Short Name", ModificationSize.Properties.ABBREVIATED_NAME), new EditablePropertyColumnFormat(ModificationSize.Properties.MULTIPLIER).setCustomEditor((TableCellEditor)new NumberEditorExt()), new EditablePropertyColumnFormat(ModificationSize.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), (PropertyColumnFormat)modificationSizeTypeCombo.setCustomRenderer(comboRend)}));
    }

    @Override
    protected Class getDisplayingType() {
        return ModificationSize.class;
    }

    protected ObjectEditor createObjectEditor() {
        return null;
    }
}

