/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.adjustments;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.components.ChooseListElementsObjectEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.textformat.DisplayableListFormat;
import officemate.screens.setup.menu.adjustments.TriggeredPriceAdjustmentSearch;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.inventory.SimplePriceAdjustment;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.activation.StrategyRegister;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.table.TableColumnExt;

public class SimplePriceAdjustmentState
extends AbstractEditableTableState {
    private final EventList<PriceAdjustmentLevel> levelsList = GlazedLists.eventList(PriceAdjustmentLevel.register.values());
    private final EventList<TriggerActivationStrategy> strategyList = GlazedLists.eventList(StrategyRegister.getRegister().values());
    private final EventList<AbstractTrigger> triggersList = new BasicEventList();
    private final PriceAdjustmentDirection directionToEdit;

    public SimplePriceAdjustmentState(PriceAdjustmentDirection directionToBeEdited) {
        super(SimplePriceAdjustmentState.neatenString(directionToBeEdited.toString()) + "s", AllPermissions.PRICE_ADJUSTMENTS, "Add, remove and modify " + SimplePriceAdjustmentState.neatenString(directionToBeEdited.toString()) + "s");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy());
        this.directionToEdit = directionToBeEdited;
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        ((TriggeredPriceAdjustmentSearch)this.getSearchFactory()).setDirection(this.directionToEdit);
        ((TriggeredPriceAdjustmentSearch)this.getSearchFactory()).setJXTable(this.getCentralArea().getTable());
    }

    private static String neatenString(String value) {
        StringBuilder SB = new StringBuilder(value.substring(0, 1).toUpperCase());
        SB.append(value.substring(1).toLowerCase());
        return SB.toString();
    }

    protected ObjectEditor createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return SimplePriceAdjustmentState.neatenString(this.directionToEdit.toString());
    }

    protected Object createNewObject() {
        PriceAdjustmentUnit unit = ((TriggeredPriceAdjustmentSearch)this.getSearchFactory()).getSelectedUnit();
        TriggeredPriceAdjustment adj = PriceAdjustmentFactory.getInstance().createTriggeredPriceAdjustment(this.directionToEdit, 1.0, unit, PriceAdjustmentType.NORMAL, "New " + SimplePriceAdjustmentState.neatenString(this.directionToEdit.toString()));
        DefaultTrigger defaultTrigger = AbstractTrigger.getDefaultTriggerIfExists();
        if (defaultTrigger != null) {
            adj.addTrigger((AbstractTrigger)defaultTrigger);
        }
        return adj;
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        BasicEventList unitsList = new BasicEventList();
        unitsList.add((Object)PriceAdjustmentUnit.DOLLAR_UNIT);
        unitsList.add((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT);
        return new TriggeredPriceAdjustmentSearch(new RefreshAction((Refreshable)this), (EventList)unitsList);
    }

    protected AbstractColumnFormat[] getTableColumns() {
        return new AbstractColumnFormat[]{new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.LABEL), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.PERCENTAGE).setCustomRenderer(new PercentageCellRenderer()), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.DOLLAR_AMOUNT).setCustomEditor(new PriceCellEditor(true)), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.CAP_AMOUNT).setCustomEditor(new PriceCellEditor(true){

            @Override
            public Object getCellEditorValue() {
                Object value = super.getCellEditorValue();
                return Price.ZERO_DOLLAR.equals(value) ? null : value;
            }
        }), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.LEVEL).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.levelsList))), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.TRIGGER_ACTIVATION_STRATEGY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.strategyList))), new PopupEditableColumnFormat((PropertiedObject.Property)SimplePriceAdjustment.Properties.TRIGGERS, new PriceAdjustmentTriggersEditor((EventList)this.triggersList), this).setFormatter(new DisplayableListFormat(true)), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.AUTOMATIC), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.DISPLAYABLE), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.FOREGROUND_COLOR), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.BACKGROUND_COLOR), new EditablePropertyColumnFormat(SimplePriceAdjustment.Properties.SEQUENCE)};
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        this.setFilterActive(true);
        ColumnTableFormat format = new ColumnTableFormat((ColumnFormat[])this.getTableColumns());
        PropertiedObject.Property[] propsToHide = new PropertiedObject.Property[]{SimplePriceAdjustment.Properties.FOREGROUND_COLOR, SimplePriceAdjustment.Properties.BACKGROUND_COLOR};
        PersistentObjectTable centralArea = new PersistentObjectTable(this.getObjectList(), format, propsToHide);
        JPanel filterPanel = new JPanel((LayoutManager)new VerticalLayout());
        ColumnVisibilityHelper colorsCheckHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{TriggeredPriceAdjustment.Properties.FOREGROUND_COLOR, TriggeredPriceAdjustment.Properties.BACKGROUND_COLOR}, new JCheckBox("Show Colours"), centralArea.getTable());
        filterPanel.add(colorsCheckHelper.getCheckBox());
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.add((Component)this.getSearchFactory().getSearchPanel(), "West");
        controlPanel.add((Component)filterPanel, "East");
        centralArea.add((Component)controlPanel, "North");
        return centralArea;
    }

    @Override
    protected Class getDisplayingType() {
        return SimplePriceAdjustment.class;
    }

    @Override
    public void refresh() {
        this.triggersList.clear();
        this.triggersList.addAll((Collection)AbstractTrigger.getUserLinkableTriggers());
        PriceAdjustmentUnit unit = ((TriggeredPriceAdjustmentSearch)this.getSearchFactory()).getSelectedUnit();
        TableColumnExt column = this.getCentralArea().getTable().getColumnExt((Object)SimplePriceAdjustment.Properties.CAP_AMOUNT);
        if (column != null) {
            column.setVisible(PriceAdjustmentUnit.PERCENTAGE_UNIT.equals((Object)unit));
        }
        super.refresh();
    }

    static class PercentageCellRenderer
    extends ShadeAlternateRowsTableCellRenderer {
        PercentageCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(((JTextComponent)comp).getText() + "%");
            } else if (comp instanceof JLabel) {
                ((JLabel)comp).setText(((JLabel)comp).getText() + "%");
            }
            return comp;
        }
    }

    public static class PriceAdjustmentTriggersEditor
    extends ChooseListElementsObjectEditor {
        public PriceAdjustmentTriggersEditor(EventList possibleElements) {
            super(possibleElements);
        }

        @Override
        public void addObjectToParent(Object toAdd) {
        }

        @Override
        public void removeObjectFromParent(Object toRemove) {
        }

        @Override
        public Collection<AbstractTrigger> getParentList() {
            ArrayList<AbstractTrigger> list = new ArrayList<AbstractTrigger>(((TriggeredPriceAdjustment)this.getObject()).getTriggers());
            return list;
        }

        @Override
        protected void setParentList(Collection toSet) {
            TriggeredPriceAdjustment adj = (TriggeredPriceAdjustment)this.getObject();
            adj.removeAllTriggers();
            Iterator it = toSet.iterator();
            while (it.hasNext()) {
                adj.addTrigger((AbstractTrigger)it.next());
            }
        }
    }
}

