/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.adjustments;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.SimplePriceAdjustment;
import ordermate.database.searchers.adjustments.PriceAdjustmentSearcher;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class TriggeredPriceAdjustmentSearch
extends ObjectPropertySearch {
    private final EventList levelsList = GlazedLists.eventList(PriceAdjustmentLevel.register.values());
    private final EventList unitsList;
    private final ComboSearchField unitCombo;
    private PriceAdjustmentDirection direction;
    private JXTable centralTable;
    private PriceAdjustmentSearcher searcher;
    private TableColumnExt dollarColumn;
    private TableColumnExt percColumn;

    public TriggeredPriceAdjustmentSearch(EventList priceAdjustmentUnitsList) {
        this((RefreshAction)null, priceAdjustmentUnitsList);
    }

    public TriggeredPriceAdjustmentSearch(RefreshAction refreshAction, EventList priceAdjustmentUnitsList) {
        super(SimplePriceAdjustment.class);
        RefreshAction refresh = refreshAction;
        if (refresh == null) {
            refresh = new RefreshAction((Refreshable)this);
        }
        this.unitsList = priceAdjustmentUnitsList;
        this.searcher = (PriceAdjustmentSearcher)super.getPropertySearcher();
        if (this.direction != null) {
            ISingleValueSearchFilter directionProp = this.searcher.getDirectionFilter();
            directionProp.setSearchValue((Object)this.direction);
        }
        this.addSearchField((SearchGuiField)new StringSearchField("Name", this.searcher.getAdjustmentNameFilter(), (Action)refresh));
        this.unitCombo = new ComboSearchField("Unit", this.searcher.getAdjustmentUnitFilter(), false, (Action)refresh, this.unitsList);
        this.addSearchField((SearchGuiField)this.unitCombo);
        this.addSearchField(new MutuallyExclusiveTextSearchField("Amount", this.searcher.getDollarAmountFilter(), this.searcher.getPercentageAmountFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new ComboSearchField("Level", this.searcher.getAdjustmentLevelFilter(), true, (Action)refresh, this.levelsList));
    }

    public void setDirection(PriceAdjustmentDirection newDirection) {
        this.direction = newDirection;
        this.searcher = (PriceAdjustmentSearcher)super.getPropertySearcher();
        this.searcher.getDirectionFilter().setSearchValue((Object)this.direction);
    }

    public void setJXTable(JXTable priceAdjustmentTable) {
        this.centralTable = priceAdjustmentTable;
        for (TableColumnExt column : this.centralTable.getColumns()) {
            if ("Dollar Amount".equalsIgnoreCase(column.getHeaderValue().toString())) {
                this.dollarColumn = column;
                column.setIdentifier((Object)PriceAdjustmentUnit.DOLLAR_UNIT);
                continue;
            }
            if (!"Percentage".equalsIgnoreCase(column.getHeaderValue().toString())) continue;
            this.percColumn = column;
            column.setIdentifier((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT);
        }
    }

    @Override
    public void doRefresh() {
        this.clearObjectList();
        if (this.centralTable != null) {
            final PriceAdjustmentUnit selection = (PriceAdjustmentUnit)this.unitCombo.getSelectedObject();
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("We're on the EDT.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (selection.equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT)) {
                        TriggeredPriceAdjustmentSearch.this.centralTable.removeColumn((TableColumn)TriggeredPriceAdjustmentSearch.this.percColumn);
                        int index = -1;
                        try {
                            index = TriggeredPriceAdjustmentSearch.this.centralTable.getColumnModel().getColumnIndex(TriggeredPriceAdjustmentSearch.this.dollarColumn.getIdentifier());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (index == -1) {
                            TriggeredPriceAdjustmentSearch.this.centralTable.addColumn((TableColumn)TriggeredPriceAdjustmentSearch.this.dollarColumn);
                            TriggeredPriceAdjustmentSearch.this.centralTable.moveColumn(TriggeredPriceAdjustmentSearch.this.centralTable.getColumnModel().getColumnIndex(TriggeredPriceAdjustmentSearch.this.dollarColumn.getIdentifier()), 1);
                            TriggeredPriceAdjustmentSearch.this.dollarColumn.setVisible(true);
                        }
                    } else if (selection.equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
                        TriggeredPriceAdjustmentSearch.this.centralTable.removeColumn((TableColumn)TriggeredPriceAdjustmentSearch.this.dollarColumn);
                        int index = -1;
                        try {
                            index = TriggeredPriceAdjustmentSearch.this.centralTable.getColumnModel().getColumnIndex(TriggeredPriceAdjustmentSearch.this.percColumn.getIdentifier());
                        }
                        catch (IllegalArgumentException ex) {
                            index = -1;
                        }
                        if (index == -1) {
                            TriggeredPriceAdjustmentSearch.this.centralTable.addColumn((TableColumn)TriggeredPriceAdjustmentSearch.this.percColumn);
                            TriggeredPriceAdjustmentSearch.this.centralTable.moveColumn(TriggeredPriceAdjustmentSearch.this.centralTable.getColumnModel().getColumnIndex(TriggeredPriceAdjustmentSearch.this.percColumn.getIdentifier()), 1);
                            TriggeredPriceAdjustmentSearch.this.percColumn.setVisible(true);
                        }
                    }
                }
            });
        }
        super.doRefresh();
    }

    protected ObjectQuerySearcher constructPropertySearcher() {
        return new PriceAdjustmentSearcher();
    }

    public PriceAdjustmentUnit getSelectedUnit() {
        return (PriceAdjustmentUnit)this.unitCombo.getSelectedObject();
    }

    class MutuallyExclusiveTextSearchField
    extends SearchGuiField {
        private ISingleValueSearchFilter dollarSearch;
        private ISingleValueSearchFilter percSearch;
        private JTextField textField;

        public MutuallyExclusiveTextSearchField(String name, ISingleValueSearchFilter dollarSearch, ISingleValueSearchFilter percSearch, Action action) {
            super(name, action);
            this.dollarSearch = dollarSearch;
            this.percSearch = percSearch;
        }

        public Component getGuiComponent() {
            return this.getTextField();
        }

        public void reset() {
            this.getTextField().setText("");
        }

        public void addAction(Action action) {
            if (action != null) {
                this.getTextField().getDocument().addDocumentListener((DocumentListener)new SearchGuiField.DocumentListenerAdapter((ActionListener)action));
            }
        }

        private JTextField getTextField() {
            if (this.textField == null) {
                this.textField = new JTextField(15);
            }
            return this.textField;
        }

        public SearchFilterI getSearchProperty() {
            ISingleValueSearchFilter searchProperty = this.dollarSearch;
            if (this.isEnabled()) {
                PriceAdjustmentUnit selection = (PriceAdjustmentUnit)TriggeredPriceAdjustmentSearch.this.unitCombo.getSelectedObject();
                if (PriceAdjustmentUnit.PERCENTAGE_UNIT.equals((Object)selection)) {
                    searchProperty = this.percSearch;
                }
                searchProperty.clearSearch();
                if (!this.textField.getText().equals("")) {
                    searchProperty.setSearchValue((Object)this.textField.getText());
                }
            } else {
                searchProperty.setSearchValue(null);
            }
            return searchProperty;
        }

        public void setVisible(boolean flag) {
            this.getGuiComponent().setVisible(flag);
        }

        public boolean isVisible() {
            return this.getGuiComponent().isVisible();
        }

        public void setEnabled(boolean flag) {
            this.getGuiComponent().setEnabled(flag);
        }

        public boolean isEnabled() {
            return this.getGuiComponent().isEnabled();
        }
    }
}

