/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.combosetup;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.EditorDialog;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.screens.setup.menu.combosetup.ComboGroupEditor;
import officemate.screens.setup.menu.combosetup.UserModificationSessionHelper;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;

class ComboEditorGroupPanel
extends JPanel
implements ListEventListener {
    private JButton editButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private EventList<InventoryComboGroup> comboGroupEvent;
    private PersistentObjectTable<InventoryComboGroup> table;
    private InventoryCombo combo;
    private ComboGroupEditor groupEditor;
    private EditorDialog editorDialog;
    private UserModificationSessionHelper<InventoryComboGroup> deleteSessionHelper;
    private Set<InventoryComboGroup> addedItems;

    public ComboEditorGroupPanel(BasicOfficeMateState state, EventList<InventoryComboGroup> comboGroupEvent) {
        super(new BorderLayout());
        this.comboGroupEvent = comboGroupEvent;
        this.comboGroupEvent.addListEventListener((ListEventListener)this);
        this.groupEditor = new ComboGroupEditor();
        this.editorDialog = new EditorDialog("Combo Group", this.groupEditor, "", "");
        this.deleteSessionHelper = new UserModificationSessionHelper();
        this.addedItems = new HashSet<InventoryComboGroup>();
        this.setupComponents();
    }

    private void setupComponents() {
        this.setPreferredSize(new Dimension(300, 140));
        EditGroupAction editGroupAction = new EditGroupAction();
        this.editButton = new JButton((Action)((Object)editGroupAction));
        this.addButton = new JButton((Action)((Object)new AddGroupAction()));
        RemoveGroupAction removeGroupAction = new RemoveGroupAction();
        this.removeButton = new JButton((Action)((Object)removeGroupAction));
        this.removeAllButton = new JButton((Action)((Object)new RemoveAllGroupAction()));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.addButton);
        this.addButton.setName("addGroup");
        buttonPanel.add(this.editButton);
        this.editButton.setName("editGroup");
        buttonPanel.add(this.removeButton);
        this.removeButton.setName("removeGroup");
        buttonPanel.add(this.removeAllButton);
        this.removeAllButton.setName("removeAllGroup");
        this.add((Component)buttonPanel, "East");
        this.removeAllButton.setEnabled(!this.comboGroupEvent.isEmpty());
        this.table = new PersistentObjectTable<InventoryComboGroup>(this.comboGroupEvent, new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new AbstractColumnFormat("Type", InventoryComboGroup.class){

            public Object resolveColumnValue(Object baseObject) {
                InventoryComboGroup item = (InventoryComboGroup)baseObject;
                return item.getLabel();
            }
        }, new EditablePropertyColumnFormat(InventoryComboGroup.Properties.SEQUENCE)}));
        this.add(this.table, "Center");
        this.table.addSelectionDependentAction((Action)((Object)editGroupAction));
        this.table.addSelectionDependentAction((Action)((Object)removeGroupAction));
        this.table.objectDoubleClicked().connect((Object)this, "doEdit");
    }

    private void doEdit() {
        this.groupEditor.setObject(this.table.getSelectedObject());
        if (this.editorDialog.doModal()) {
            this.groupEditor.saveObject();
            this.deleteSessionHelper.sessionConfirmed();
            GlazedListUtils.replace(this.comboGroupEvent, this.groupEditor.getObject(), this.groupEditor.getObject());
            this.groupEditor.subEditorOk();
        } else {
            this.groupEditor.subEditorCancel();
        }
        this.deleteSessionHelper.startNewSession();
    }

    private void doAddGroup() {
        InventoryComboGroup group = new InventoryComboGroup(this.combo);
        group.setSequence(Integer.valueOf(0));
        group.setMinQuantity(SalesQuantity.ONE);
        group.setMaxQuantity(SalesQuantity.ONE);
        this.groupEditor.setObject(group);
        if (this.editorDialog.doModal()) {
            this.groupEditor.saveObject();
            this.groupEditor.subEditorOk();
            if (this.combo != null) {
                GlazedListUtils.add(this.comboGroupEvent, this.groupEditor.getObject());
                this.addedItems.add((InventoryComboGroup)this.groupEditor.getObject());
            }
        } else {
            this.groupEditor.subEditorCancel();
        }
    }

    public void listChanged(ListEvent listChanges) {
        this.removeAllButton.setEnabled(!listChanges.getSourceList().isEmpty());
    }

    public void setObject(InventoryCombo combo) {
        this.combo = combo;
        this.comboGroupEvent.removeAll(this.deleteSessionHelper.getConfirmed());
        this.deleteSessionHelper.startNewSession();
    }

    public void save() {
        for (InventoryComboGroup group : this.deleteSessionHelper.getConfirmed()) {
            group.deleteChild();
        }
        this.groupEditor.save();
    }

    public void cancel() {
        this.deleteSessionHelper.cancelled();
        this.groupEditor.cancel();
    }

    public void mainEditorCancel() {
        this.deleteSessionHelper.sessionCancelled();
        this.groupEditor.mainEditorCancel();
        this.addedItems.clear();
    }

    public void mainEditorOk() {
        this.deleteSessionHelper.sessionConfirmed();
        this.groupEditor.mainEditorOk();
        for (InventoryComboGroup group : this.addedItems) {
            group.getCombo().addGroup(group);
        }
    }

    private class AddGroupAction
    extends BasicAction {
        AddGroupAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add a group...");
        }

        public void actionPerformed(ActionEvent e) {
            ComboEditorGroupPanel.this.doAddGroup();
        }
    }

    private class EditGroupAction
    extends BasicAction {
        EditGroupAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit combo group...");
        }

        public void actionPerformed(ActionEvent e) {
            ComboEditorGroupPanel.this.doEdit();
        }
    }

    private class RemoveGroupAction
    extends BasicAction {
        RemoveGroupAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            ComboEditorGroupPanel.this.deleteSessionHelper.addAllSession(ComboEditorGroupPanel.this.table.getAllSelectedObjects());
            GlazedListUtils.removeInList((EventList)ComboEditorGroupPanel.this.comboGroupEvent, ComboEditorGroupPanel.this.table.getAllSelectedObjects());
        }
    }

    private class RemoveAllGroupAction
    extends BasicAction {
        RemoveAllGroupAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Remove All");
        }

        public void actionPerformed(ActionEvent e) {
            ComboEditorGroupPanel.this.deleteSessionHelper.addAllSession(ComboEditorGroupPanel.this.comboGroupEvent);
            GlazedListUtils.clearAll((EventList)ComboEditorGroupPanel.this.comboGroupEvent);
        }
    }
}

