/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.combosetup;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import officemate.OfficeMate;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryGroupSizesSearchPanel;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.renderers.SalesQuantityEditor;
import officemate.components.tableformat.renderers.SequenceEditor;
import officemate.screens.setup.menu.combosetup.ComboState;
import officemate.screens.setup.menu.combosetup.UserModificationSessionHelper;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.combos.InventoryComboGroupSectionLink;
import ordermate.database.misc.Course;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.beansbinding.Validator;

class ComboGroupEditor
extends AbstractObjectEditor<InventoryComboGroup>
implements ListEventListener {
    private FieldPanelBuilder builder = new FieldPanelBuilder();
    ComboGroupItemTablePanel itemTablePanel;
    ComboGroupSectionTablePanel sectionTablePanel;
    private JSpinner min;
    private JSpinner max;
    private JLabel problemLabel;
    private JCheckBox apportion;
    PersistentObjectTable<InventoryComboGroupItemUnitLink> itemTable;
    PersistentObjectTable<InventoryComboGroupSectionLink> sectionTable;
    EventList<InventoryComboGroupItemUnitLink> groupItems = GlazedLists.eventList(new ArrayList());
    EventList<InventoryComboGroupSectionLink> groupSections = GlazedLists.eventList(new ArrayList());
    private UserModificationSessionHelper<InventoryComboGroupItemUnitLink> itemDeleteSessionHelper;
    private UserModificationSessionHelper<InventoryComboGroupSectionLink> groupDeleteSessionHelper;
    private UserModificationSessionHelper<InventoryComboGroupItemUnitLink> itemAddSessionHelper;
    private UserModificationSessionHelper<InventoryComboGroupSectionLink> groupAddSessionHelper;
    private static final int TABLE_PREF_WIDTH = 450;
    private static final int TABLE_PREF_HEIGHT = 130;
    private boolean allowDecimals = false;

    public ComboGroupEditor() {
        ExperimentalFeature feature = ExperimentalFeature.find((String)"Combo Group Decimals");
        this.allowDecimals = feature != null && feature.getBooleanValue(Boolean.FALSE) != false;
        this.setupComponents();
        this.groupItems.addListEventListener((ListEventListener)this);
        this.groupSections.addListEventListener((ListEventListener)this);
        this.itemDeleteSessionHelper = new UserModificationSessionHelper();
        this.itemAddSessionHelper = new UserModificationSessionHelper();
        this.groupDeleteSessionHelper = new UserModificationSessionHelper();
        this.groupAddSessionHelper = new UserModificationSessionHelper();
    }

    @Override
    public void setObject(InventoryComboGroup toEdit) {
        this.itemDeleteSessionHelper.startNewSubSession();
        this.itemAddSessionHelper.startNewSubSession();
        this.groupDeleteSessionHelper.startNewSubSession();
        this.groupAddSessionHelper.startNewSubSession();
        this.min.setValue(toEdit.getMinQuantity().getValue());
        this.max.setValue(toEdit.getMaxQuantity().getValue());
        this.groupItems.clear();
        this.groupItems.addAll((Collection)toEdit.getGroupUnitLink());
        this.groupSections.clear();
        this.groupSections.addAll((Collection)toEdit.getGroupSectionLink());
        HashSet<InventoryComboGroupItemUnitLink> userItemAdditions = new HashSet<InventoryComboGroupItemUnitLink>();
        for (InventoryComboGroupItemUnitLink item : this.itemAddSessionHelper.getAllConfirmedAndAwaiting()) {
            if (!item.getComboGroup().equals((Object)toEdit)) continue;
            userItemAdditions.add(item);
        }
        this.groupItems.addAll(userItemAdditions);
        HashSet<InventoryComboGroupSectionLink> userGroupAdditions = new HashSet<InventoryComboGroupSectionLink>();
        for (InventoryComboGroupSectionLink item : this.groupAddSessionHelper.getAllConfirmedAndAwaiting()) {
            if (!item.getComboGroup().equals((Object)toEdit)) continue;
            userGroupAdditions.add(item);
        }
        this.groupSections.addAll(userGroupAdditions);
        super.setObject(toEdit);
        this.groupItems.removeAll(this.itemDeleteSessionHelper.getAllConfirmedAndAwaiting());
        this.groupSections.removeAll(this.groupDeleteSessionHelper.getAllConfirmedAndAwaiting());
        if (toEdit.getCombo() != null && !toEdit.getCombo().isApportionable()) {
            this.apportion.setSelected(true);
            this.apportion.setEnabled(false);
        } else {
            this.apportion.setEnabled(true);
        }
    }

    @Override
    public void saveObject() {
        Number minVal = (Number)this.min.getValue();
        Number maxVal = (Number)this.max.getValue();
        if (this.allowDecimals) {
            ((InventoryComboGroup)this.getObject()).setMinQuantity(SalesQuantity.valueOf((String)String.valueOf(minVal)));
            ((InventoryComboGroup)this.getObject()).setMaxQuantity(SalesQuantity.valueOf((String)String.valueOf(maxVal)));
        } else {
            ((InventoryComboGroup)this.getObject()).setMinQuantity(SalesQuantity.valueOf((long)minVal.longValue()));
            ((InventoryComboGroup)this.getObject()).setMaxQuantity(SalesQuantity.valueOf((long)maxVal.longValue()));
        }
        super.saveObject();
    }

    private void setupComponents() {
        JTextField groupName = this.setupTextField(InventoryComboGroup.Properties.NAME, 20, (Validator)new NotEmptyValidator());
        groupName.setName("groupName");
        this.builder.addRow("Name", (Component)groupName, "The name of the combo group");
        JPanel qtyPanel = new JPanel(new FlowLayout(0));
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComboGroupEditor.this.gotSubObjectEdited();
            }
        };
        this.min = this.allowDecimals ? new JSpinner(new SpinnerNumberModel(0.0, 0.0, 100.0, 0.5)) : new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        ((JSpinner.NumberEditor)this.min.getEditor()).getTextField().setColumns(3);
        this.min.addChangeListener(listener);
        qtyPanel.add(new JLabel("Min:"));
        qtyPanel.add(this.min);
        qtyPanel.add(new JLabel("Max:"));
        this.max = this.allowDecimals ? new JSpinner(new SpinnerNumberModel(0.0, 0.0, 100.0, 1.0)) : new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        ((JSpinner.NumberEditor)this.max.getEditor()).getTextField().setColumns(3);
        this.max.addChangeListener(listener);
        qtyPanel.add(this.max);
        this.problemLabel = new JLabel("");
        this.problemLabel.setForeground(Color.RED);
        qtyPanel.add(this.problemLabel);
        this.builder.addRow("Quantity", (Component)qtyPanel);
        this.apportion = this.setupCheckBox(InventoryComboGroup.Properties.APPORTIONABLE);
        this.builder.addRow("Apportionable", (Component)this.apportion, "Whether this groups is used for distributing combo price adjustments");
        this.builder.addSeparator("Group sections");
        this.createAndAddGroupSectionPanel();
        this.builder.addSeparator("Group items");
        this.createAndAddGroupItemPanel();
        this.add((Component)this.builder.getPanel(), "Center");
    }

    private void createAndAddGroupItemPanel() {
        RemoveItemAction removeItemAction = new RemoveItemAction();
        this.itemTable = new PersistentObjectTable<InventoryComboGroupItemUnitLink>(this.groupItems, new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Menu Item", InventoryComboGroupItemUnitLink.Properties.ITEM_UNIT), new EditablePropertyColumnFormat(InventoryComboGroupItemUnitLink.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryComboGroupItemUnitLink.Properties.PRICE_ADD).setCustomEditor(new PriceCellEditor(true)), new EditablePropertyColumnFormat(InventoryComboGroupItemUnitLink.Properties.COURSE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)Course.getCourses()), true))), new EditablePropertyColumnFormat(InventoryComboGroupItemUnitLink.Properties.DEFAULT_QTY).setCustomEditor(new SalesQuantityEditor(true))}));
        this.itemTable.addSelectionDependentAction((Action)((Object)removeItemAction));
        this.itemTable.objectDoubleClicked().connect((Object)this, "addMenuUnit");
        this.setupItemsPanel(removeItemAction);
        this.builder.addRow("Items", (Component)this.itemTablePanel);
    }

    private void setupItemsPanel(RemoveItemAction removeItemAction) {
        this.itemTablePanel = new ComboGroupItemTablePanel(this.itemTable);
        this.itemTablePanel.addGroupButtonAction((Action)((Object)new AddMenuGroup()));
        this.itemTablePanel.addButtonAction((Action)((Object)new AddMenuItemAction()));
        this.itemTablePanel.removeButtonAction((Action)((Object)removeItemAction));
        this.itemTablePanel.removeAllButtonAction((Action)((Object)new RemoveAllItemAction()));
        this.itemTablePanel.setObject((InventoryComboGroup)this.getObject());
        this.itemTablePanel.removeAllButton.setEnabled(!this.groupItems.isEmpty());
        this.itemTablePanel.setPreferredSize(new Dimension(450, 130));
        this.itemTablePanel.objectEdited.connect((Object)this, "gotSubObjectEdited");
    }

    public void gotSubObjectEdited() {
        this.firePropertyChange("guiValid", true, false);
    }

    private void createAndAddGroupSectionPanel() {
        RemoveSectionAction removeSectionAction = new RemoveSectionAction();
        this.sectionTable = new PersistentObjectTable<InventoryComboGroupSectionLink>(this.groupSections, new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Menu Section", InventoryComboGroupSectionLink.Properties.INVENTORY_GROUP), new EditablePropertyColumnFormat(InventoryComboGroupSectionLink.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryComboGroupSectionLink.Properties.COURSE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)Course.getCourses()), true)))}));
        this.sectionTable.addSelectionDependentAction((Action)((Object)removeSectionAction));
        this.sectionTable.objectDoubleClicked().connect((Object)this, "addMenuGroupSection");
        this.setupSectionsPanel(removeSectionAction);
        this.builder.addRow("Sections", (Component)this.sectionTablePanel);
    }

    private void setupSectionsPanel(RemoveSectionAction removeSectionAction) {
        this.sectionTablePanel = new ComboGroupSectionTablePanel(this.sectionTable);
        this.sectionTablePanel.addButtonAction((Action)((Object)new AddMenuGroupSection()));
        this.sectionTablePanel.removeButtonAction((Action)((Object)removeSectionAction));
        this.sectionTablePanel.removeAllButtonAction((Action)((Object)new RemoveAllSectionAction()));
        this.sectionTablePanel.setObject((InventoryComboGroup)this.getObject());
        this.sectionTablePanel.objectEdited.connect((Object)this, "gotSubObjectEdited");
        this.sectionTablePanel.removeAllButton.setEnabled(!this.groupSections.isEmpty());
        this.sectionTablePanel.setPreferredSize(new Dimension(450, 130));
    }

    private void addMenuGroup() {
        InventoryGroupSizesSearchPanel searchPanel = new InventoryGroupSizesSearchPanel(ComboState.getCurrentProfile());
        SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), searchPanel, "Find Menu Section...");
        searchDialog.setVisible(true);
        InventoryGroup groupFound = (InventoryGroup)searchDialog.getFoundObject();
        List sizesToAdd = searchPanel.getSelectedSizes();
        if (groupFound != null && !searchDialog.wasCancelled() && !sizesToAdd.isEmpty()) {
            for (InventoryItem item : groupFound.getRecursiveItems()) {
                for (InventoryItemUnit unit : item.getUnits()) {
                    if (!sizesToAdd.contains(unit.getSize())) continue;
                    InventoryComboGroupItemUnitLink link = new InventoryComboGroupItemUnitLink((InventoryComboGroup)this.getObject(), unit);
                    this.itemAddSessionHelper.addSubSession(link);
                    GlazedListUtils.add(this.groupItems, (Object)link);
                }
            }
        }
    }

    private void addMenuUnit() {
        SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryItemSearchPanel(ComboState.getCurrentProfile(), true), "Find Menu Item...");
        searchDialog.setVisible(true);
        if (!searchDialog.wasCancelled()) {
            InventoryItemUnit unitFound = (InventoryItemUnit)searchDialog.getFoundObject();
            InventoryComboGroupItemUnitLink link = new InventoryComboGroupItemUnitLink((InventoryComboGroup)this.getObject(), unitFound);
            this.itemAddSessionHelper.addSubSession(link);
            GlazedListUtils.add(this.groupItems, (Object)link);
        }
    }

    private void addMenuGroupSection() {
        InventoryGroupSizesSearchPanel searchPanel = new InventoryGroupSizesSearchPanel(ComboState.getCurrentProfile());
        SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), searchPanel, "Find Menu Section...");
        searchDialog.setVisible(true);
        if (!searchDialog.wasCancelled()) {
            InventoryGroup unitFound = (InventoryGroup)searchDialog.getFoundObject();
            InventoryComboGroupSectionLink link = new InventoryComboGroupSectionLink((InventoryComboGroup)this.getObject(), unitFound);
            this.groupAddSessionHelper.addSubSession(link);
            GlazedListUtils.add(this.groupSections, (Object)link);
        }
    }

    @Override
    public boolean isGuiValid() {
        boolean valid = super.isGuiValid() && (this.itemTablePanel.isGuiValid() || this.sectionTablePanel.isGuiValid());
        this.problemLabel.setVisible(false);
        if (this.getObject() != null) {
            Number minValue = (Number)this.min.getValue();
            Number maxValue = (Number)this.max.getValue();
            if (minValue != null && maxValue != null) {
                if (maxValue.doubleValue() < minValue.doubleValue()) {
                    this.problemLabel.setText("Max is less than min");
                    this.problemLabel.setVisible(true);
                    valid = false;
                } else {
                    SalesQuantity qty = SalesQuantity.ZERO;
                    for (InventoryComboGroupItemUnitLink link : ((InventoryComboGroup)this.getObject()).getGroupUnitLink()) {
                        if (link.getDefaultQty() == null) continue;
                        qty = qty.add(link.getDefaultQty());
                    }
                    if (qty.getValue().compareTo(new BigDecimal(maxValue.toString())) > 0) {
                        this.problemLabel.setText("Default ordered quantity " + qty + " is greater than max");
                        this.problemLabel.setVisible(true);
                        valid = false;
                    }
                }
            }
        }
        return valid;
    }

    public void listChanged(ListEvent listChanges) {
        this.itemTablePanel.removeAllButton.setEnabled(!this.groupItems.isEmpty());
        this.sectionTablePanel.removeAllButton.setEnabled(!this.groupSections.isEmpty());
        this.itemTablePanel.objectEdited.emit();
        this.sectionTablePanel.objectEdited.emit();
    }

    public void save() {
        this.itemAddSessionHelper.getConfirmed().removeAll(this.itemDeleteSessionHelper.getConfirmed());
        for (InventoryComboGroupItemUnitLink item : this.itemDeleteSessionHelper.getConfirmed()) {
            item.deleteChild();
        }
        for (InventoryComboGroupItemUnitLink item : this.itemAddSessionHelper.getConfirmed()) {
            item.getComboGroup().addItemUnitLink(item);
        }
        this.groupAddSessionHelper.getConfirmed().removeAll(this.groupDeleteSessionHelper.getConfirmed());
        for (InventoryComboGroupSectionLink group : this.groupDeleteSessionHelper.getConfirmed()) {
            group.deleteChild();
        }
        for (InventoryComboGroupSectionLink group : this.groupAddSessionHelper.getConfirmed()) {
            group.getComboGroup().addSectionLink(group);
        }
    }

    public void cancel() {
        this.itemDeleteSessionHelper.cancelled();
        this.itemAddSessionHelper.cancelled();
        this.groupDeleteSessionHelper.cancelled();
        this.groupAddSessionHelper.cancelled();
    }

    public void subEditorCancel() {
        this.itemDeleteSessionHelper.subSessionCancelled();
        this.itemAddSessionHelper.subSessionCancelled();
        this.groupDeleteSessionHelper.subSessionCancelled();
        this.groupAddSessionHelper.subSessionCancelled();
    }

    public void subEditorOk() {
        this.itemDeleteSessionHelper.subSessionConfirmed();
        this.itemAddSessionHelper.subSessionConfirmed();
        this.groupDeleteSessionHelper.subSessionConfirmed();
        this.groupAddSessionHelper.subSessionConfirmed();
    }

    public void mainEditorOk() {
        this.itemDeleteSessionHelper.sessionConfirmed();
        this.itemAddSessionHelper.sessionConfirmed();
        this.groupDeleteSessionHelper.sessionConfirmed();
        this.groupAddSessionHelper.sessionConfirmed();
    }

    public void mainEditorCancel() {
        this.itemDeleteSessionHelper.sessionCancelled();
        this.itemAddSessionHelper.sessionCancelled();
        this.groupDeleteSessionHelper.sessionCancelled();
        this.groupAddSessionHelper.sessionCancelled();
    }

    private class ComboGroupSectionTablePanel
    extends AbstractObjectEditor<InventoryComboGroup> {
        public JButton addButton;
        public JButton removeButton;
        public JButton removeAllButton;
        private Action addButtonAction;
        private Action removeButtonAction;
        private Action removeAllButtonAction;

        public ComboGroupSectionTablePanel(PersistentObjectTable<InventoryComboGroupSectionLink> table) {
            this.setLayout(new BorderLayout());
            String objectNamePrefix = "ComboGroupSection";
            this.setPreferredSize(new Dimension(300, 140));
            table.getTable().setName("ComboGroupSectionTable");
            table.setName("ComboGroupSectionTable");
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.removeAllButton = new JButton();
            this.addButton.setName("ComboGroupSectionAdd");
            this.removeButton.setName("ComboGroupSectionRemove");
            this.removeAllButton.setName("ComboGroupSectionRemoveAll");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            buttonPanel.add(this.removeAllButton);
            this.add((Component)buttonPanel, "East");
            this.add(table, "Center");
        }

        public void addButtonAction(Action a) {
            this.addButtonAction = a;
            this.addButton.setAction(this.addButtonAction);
        }

        public void removeButtonAction(Action a) {
            this.removeButtonAction = a;
            this.removeButton.setAction(this.removeButtonAction);
        }

        public void removeAllButtonAction(Action a) {
            this.removeAllButtonAction = a;
            this.removeAllButton.setAction(this.removeAllButtonAction);
        }

        @Override
        public void setObject(InventoryComboGroup toEdit) {
            super.setObject(toEdit);
        }

        @Override
        public boolean isGuiValid() {
            return !ComboGroupEditor.this.groupSections.isEmpty() && this.containsItems();
        }

        public boolean containsItems() {
            for (InventoryComboGroupSectionLink sectionLink : ComboGroupEditor.this.groupSections) {
                if (!sectionLink.getInventoryGroup().hasItems()) continue;
                return true;
            }
            return false;
        }
    }

    private class ComboGroupItemTablePanel
    extends AbstractObjectEditor<InventoryComboGroup> {
        public JButton addGroupButton;
        public JButton addButton;
        public JButton removeButton;
        public JButton removeAllButton;
        private Action addGroupButtonAction;
        private Action addButtonAction;
        private Action removeButtonAction;
        private Action removeAllButtonAction;

        public ComboGroupItemTablePanel(PersistentObjectTable<InventoryComboGroupItemUnitLink> table) {
            this.setLayout(new BorderLayout());
            String objectNamePrefix = "ComboGroupItem";
            this.setPreferredSize(new Dimension(300, 140));
            table.getTable().setName("ComboGroupItemTable");
            table.setName("ComboGroupItemTable");
            this.addGroupButton = new JButton();
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.removeAllButton = new JButton();
            this.addGroupButton.setName("ComboGroupItemAddGroup");
            this.addButton.setName("ComboGroupItemAdd");
            this.removeButton.setName("ComboGroupItemRemove");
            this.removeAllButton.setName("ComboGroupItemRemoveAll");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(this.addGroupButton);
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            buttonPanel.add(this.removeAllButton);
            this.add((Component)buttonPanel, "East");
            this.add(table, "Center");
        }

        public void addGroupButtonAction(Action a) {
            this.addGroupButtonAction = a;
            this.addGroupButton.setAction(this.addGroupButtonAction);
        }

        public void addButtonAction(Action a) {
            this.addButtonAction = a;
            this.addButton.setAction(this.addButtonAction);
        }

        public void removeButtonAction(Action a) {
            this.removeButtonAction = a;
            this.removeButton.setAction(this.removeButtonAction);
        }

        public void removeAllButtonAction(Action a) {
            this.removeAllButtonAction = a;
            this.removeAllButton.setAction(this.removeAllButtonAction);
        }

        @Override
        public void setObject(InventoryComboGroup toEdit) {
            super.setObject(toEdit);
        }

        @Override
        public boolean isGuiValid() {
            return !ComboGroupEditor.this.groupItems.isEmpty();
        }
    }

    private class RemoveAllItemAction
    extends BasicAction {
        public RemoveAllItemAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Remove All");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.itemDeleteSessionHelper.addAllSubSession(ComboGroupEditor.this.groupItems);
            GlazedListUtils.clearAll(ComboGroupEditor.this.groupItems);
        }
    }

    private class RemoveItemAction
    extends BasicAction {
        public RemoveItemAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.itemDeleteSessionHelper.addAllSubSession(ComboGroupEditor.this.itemTable.getAllSelectedObjects());
            GlazedListUtils.removeInList(ComboGroupEditor.this.groupItems, ComboGroupEditor.this.itemTable.getAllSelectedObjects());
        }
    }

    private class RemoveAllSectionAction
    extends BasicAction {
        public RemoveAllSectionAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Remove All");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.groupDeleteSessionHelper.addAllSubSession(ComboGroupEditor.this.groupSections);
            GlazedListUtils.clearAll(ComboGroupEditor.this.groupSections);
        }
    }

    private class RemoveSectionAction
    extends BasicAction {
        public RemoveSectionAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.groupDeleteSessionHelper.addAllSubSession(ComboGroupEditor.this.sectionTable.getAllSelectedObjects());
            GlazedListUtils.removeInList(ComboGroupEditor.this.groupSections, ComboGroupEditor.this.sectionTable.getAllSelectedObjects());
        }
    }

    private class AddMenuGroupSection
    extends BasicAction {
        public AddMenuGroupSection() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add a menu group...");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.addMenuGroupSection();
        }
    }

    private class AddMenuGroup
    extends BasicAction {
        public AddMenuGroup() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/group22.png"), "Add a group of items...");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.addMenuGroup();
        }
    }

    private class AddMenuItemAction
    extends BasicAction {
        public AddMenuItemAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add an item...");
        }

        public void actionPerformed(ActionEvent e) {
            ComboGroupEditor.this.addMenuUnit();
        }
    }
}

