/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.coupon;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.menu.coupon.CouponSearch;
import officemate.screens.setup.menu.coupon.InventoryCouponEditor;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.ComboCoupon;
import ordermate.database.inventory.coupon.CouponType;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.coupon.PriceAdjustmentCoupon;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CouponSetupState
extends AbstractEditableTableState<InventoryCoupon> {
    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addAction(new AbstractAction("Customers", IconLoader.get((String)"/officemate/images/customers.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiApp.getAppComplex().getApplicationNavigator().navigateTo("Customers");
            }
        });
    }

    @Override
    protected ObjectEditor<InventoryCoupon> createObjectEditor() {
        return new InventoryCouponEditor();
    }

    @Override
    public String getTypeName() {
        return "Coupon";
    }

    @Override
    protected OfficeMateObjectSearch<InventoryCoupon> createSearchPanelFactory() {
        return new CouponSearch((EventList<InventoryCoupon>)new BasicEventList());
    }

    @Override
    protected TableStateCentralArea<InventoryCoupon> createCentralArea() {
        ColumnTableFormat format = this.createColumnFormat();
        PersistentObjectTable<InventoryCoupon> table = new PersistentObjectTable<InventoryCoupon>(this.getObjectList(), format);
        return table;
    }

    protected ColumnTableFormat createColumnFormat() {
        return new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(InventoryCoupon.Properties.LABEL), new PropertyColumnFormat(InventoryCoupon.Properties.PROTOTYPE), new PropertyColumnFormat(InventoryCoupon.Properties.CREATED), new PropertyColumnFormat(InventoryCoupon.Properties.COMMENCES), new PropertyColumnFormat(InventoryCoupon.Properties.EXPIRES), new PropertyColumnFormat(InventoryCoupon.Properties.LOCAL), new PropertyColumnFormat(InventoryCoupon.Properties.SYSTEM_STATE), new PropertyColumnFormat(InventoryCoupon.Properties.MAX_USES)});
    }

    @Override
    protected void doDelete(List<InventoryCoupon> toDelete) {
        for (InventoryCoupon nextCoupon : toDelete) {
            if (this.isLocal() == nextCoupon.isLocal()) continue;
            Dialogs.showWarningDialog("Cannot Delete Coupon", "The coupon " + nextCoupon + " is not local, and cannot be deleted");
            return;
        }
        super.doDelete(toDelete);
    }

    @Override
    protected boolean doDialog(InventoryCoupon coupon) {
        NumberReport report;
        boolean canEdit = coupon.isLocal() == this.isLocal();
        ((InventoryCouponEditor)this.getObjectEditor()).setEditable(canEdit);
        if (canEdit && !coupon.isPrototype() && (report = (NumberReport)PersistenceManager.getObject(NumberReport.class, (String)Query.count(SalesCoupon.class, (String)"value").equals(SalesCoupon.Properties.INVENTORY_COUPON, (Object)coupon).toString())).getValue().intValue() > 0 && !Dialogs.showWarningDialog("Edit Live Coupon?", "The coupon instance " + coupon.getLabel() + " has " + report.getValue() + " SalesCoupons against it.\r\nEditing this coupon will affect those coupons.\r\nDo you wish to continue?")) {
            return false;
        }
        return super.doDialog(coupon);
    }

    @Override
    protected Class<InventoryCoupon> getDisplayingType() {
        return InventoryCoupon.class;
    }

    @Override
    protected InventoryCoupon createNewObject() {
        UnitAndAmount unitAndAmount;
        OkCancelDialogBuilder builder;
        ComboCoupon coupon = null;
        CouponType type = this.determineType();
        if (type == null) {
            return null;
        }
        if (CouponType.Combo.equals((Object)type)) {
            InventoryCombo combo = (InventoryCombo)Dialogs.showOptionDialog("Combo", "Please Select the Combo", this.getAvailableCombos());
            coupon = new ComboCoupon(combo.getLabel() + " Coupon", combo, this.isLocal());
        } else if (CouponType.PriceAdjustment.equals((Object)type) && (builder = Dialogs.getOkCancelDialogBuilder((unitAndAmount = new UnitAndAmount()).getPanel())).doPack().doShow()) {
            double amount = -((Number)unitAndAmount.amountSpinner.getValue()).doubleValue();
            PriceAdjustmentUnit unit = (PriceAdjustmentUnit)unitAndAmount.unitCombo.getSelectedItem();
            if (PriceAdjustmentUnit.PERCENTAGE_UNIT.equals((Object)unit) && amount < -100.0) {
                Dialogs.showWarningDialog("Discount too great", "A Discount may not be more than 100%");
                coupon = null;
            } else {
                coupon = new PriceAdjustmentCoupon(unit.getFormattedValue(amount) + " Coupon", this.isLocal(), amount, unit);
            }
        }
        return coupon;
    }

    protected boolean isLocal() {
        return true;
    }

    protected CouponType determineType() {
        CouponType choice = (CouponType)Dialogs.showOptionDialog("Coupon Type", "Please Choose A Type", Arrays.asList(CouponType.values()));
        return choice;
    }

    protected CouponAdministrator getCouponAdministrator() {
        return CouponAdministratorRemote.getInstance();
    }

    protected List<InventoryCombo> getAvailableCombos() {
        return InventoryCombo.getAllCombos();
    }

    class UnitAndAmount {
        private JPanel panel;
        private JSpinner amountSpinner;
        private JComboBox unitCombo;

        UnitAndAmount() {
        }

        JPanel getPanel() {
            if (this.panel == null) {
                FieldPanelBuilder builder = new FieldPanelBuilder(5);
                this.unitCombo = new JComboBox<PriceAdjustmentUnit>(new PriceAdjustmentUnit[]{PriceAdjustmentUnit.PERCENTAGE_UNIT, PriceAdjustmentUnit.DOLLAR_UNIT});
                this.unitCombo.setSelectedIndex(0);
                this.amountSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 1000, 1));
                builder.addRow("Unit", (Component)this.unitCombo);
                builder.addRow("Amount", (Component)this.amountSpinner);
                this.panel = builder.getPanel();
            }
            return this.panel;
        }
    }
}

