/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.coupon.admin;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.CSVExportAction;
import officemate.screens.setup.menu.coupon.admin.SalesCouponEditor;
import officemate.screens.setup.menu.coupon.admin.SalesCouponSearchControl;
import ordermate.OrderMate;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CouponAdministrationState
extends AbstractEditableTableState<SalesCoupon> {
    private SalesCouponSearchControl search;
    private PrefixPrepender prefixPrepender;
    private JComboBox prefixSelector;
    private ColumnTableFormat tableFormat;

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addAction(new GenerateCouponsAction());
        this.addAction(this.getExportCouponAction());
        this.addPageControl(((SalesCouponSearchControl)this.getSearchFactory()).getPagerModel());
    }

    @Override
    protected ObjectEditor<SalesCoupon> createObjectEditor() {
        return new SalesCouponEditor();
    }

    @Override
    public String getTypeName() {
        return "Coupon";
    }

    @Override
    public void doDelete(List<SalesCoupon> coupons) {
        User user = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        int count = 0;
        if (user != null) {
            for (SalesCoupon coupon : coupons) {
                try {
                    if (!this.getCouponAdministrator().revokeCoupon(coupon, user)) continue;
                    ++count;
                }
                catch (RemoteException ex) {
                    OrderMate.LOG.error("Cannot revoke coupon", (Throwable)ex);
                }
            }
        }
        Dialogs.showInfoDialog("Revoked Coupons", count + " coupons were revoked.");
        this.getSearchFactory().refresh();
    }

    @Override
    public boolean supportsNew() {
        return false;
    }

    @Override
    protected OfficeMateObjectSearch<SalesCoupon> createSearchPanelFactory() {
        this.search = new SalesCouponSearchControl((EventList<SalesCoupon>)new BasicEventList());
        return this.search;
    }

    @Override
    protected TableStateCentralArea<SalesCoupon> createCentralArea() {
        this.setupPrefix();
        this.tableFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(SalesCoupon.Properties.UNIQUE_ID).setFormatter((Format)this.prefixPrepender), new PropertyColumnFormat(SalesCoupon.Properties.CREATED).setFormatter((Format)DateTimeUtils.getDateOfBirthFormat()), new PropertyColumnFormat(SalesCoupon.Properties.NUM_USES), new PropertyColumnFormat(SalesCoupon.Properties.ACTIVATED).setFormatter((Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat(SalesCoupon.Properties.SYSTEM_STATE)});
        PersistentObjectTable<SalesCoupon> table = new PersistentObjectTable<SalesCoupon>(this.getObjectList(), this.tableFormat);
        return table;
    }

    private Action getExportCouponAction() {
        return new CSVExportAction(this.getObjectList(), this.tableFormat.getColumns().toArray(new ColumnFormat[this.tableFormat.getColumnCount()]), "Coupons.csv");
    }

    private void setupPrefix() {
        this.prefixPrepender = new PrefixPrepender();
        this.prefixPrepender.prefix = null;
        JPanel holder = new JPanel();
        holder.add(new JLabel("Prefix"));
        List prefixes = PersistenceManager.getObjectList(BarcodePrefix.class, (String)Query.select(BarcodePrefix.class).not().equals(BarcodePrefix.Properties.INTERNAL, (Object)"1").toString());
        prefixes.add(0, null);
        this.prefixSelector = new JComboBox<Object>(prefixes.toArray());
        this.prefixSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodePrefix prefix = (BarcodePrefix)CouponAdministrationState.this.prefixSelector.getSelectedItem();
                CouponAdministrationState.this.prefixPrepender.prefix = prefix == null ? null : prefix.getPrefix();
                CouponAdministrationState.this.refresh();
            }
        });
        holder.add(this.prefixSelector);
        this.getSearchFactory().addToSearchPanel(holder);
    }

    @Override
    protected Class<SalesCoupon> getDisplayingType() {
        return SalesCoupon.class;
    }

    private void makeNewBatch(InventoryCoupon coupon, int count) {
        if (count <= 0 || coupon == null) {
            return;
        }
        CouponAdministrator admin = this.getCouponAdministrator();
        if (admin != null) {
            try {
                admin.generateBulkCoupons(coupon, count);
                Dialogs.showMessageDialog("Coupons created", count + " coupons have been created.");
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Cannot generate bulk coupons");
            }
            this.getSearchFactory().refresh();
        } else {
            Dialogs.showWarningDialog("No Coupon Administrator", "The Coupon Administration could not be contacted remotely");
        }
    }

    protected CouponAdministrator getCouponAdministrator() {
        return CouponAdministratorRemote.getInstance();
    }

    class PrefixPrepender
    extends Format {
        private String prefix = null;

        PrefixPrepender() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.prefix != null) {
                toAppendTo.append(this.prefix);
            }
            toAppendTo.append(obj);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source;
        }
    }

    class GenerateCouponsAction
    extends AbstractAction {
        public GenerateCouponsAction() {
            super("Generate Coupons", IconLoader.get((String)"/officemate/images/generate_coupons.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Number value;
            InventoryCoupon coupon = CouponAdministrationState.this.search.getSelectedCoupon();
            if (coupon == null) {
                return;
            }
            JPanel panel = new JPanel();
            panel.add(new JLabel("Number to generate"));
            JSpinner spinner = new JSpinner(new SpinnerNumberModel(1000, 1, 100000, 100));
            panel.add(spinner);
            if (Dialogs.getOkCancelDialogBuilder(panel).doPack().doShow() && (value = (Number)spinner.getValue()) != null) {
                CouponAdministrationState.this.makeNewBatch(coupon, value.intValue());
            }
        }
    }
}

