/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.renderers.TreeNodeListCellRenderer;
import officemate.screens.setup.menu.menuimport.AbstractMenuImportExportScreen;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.integration.menuitem.MenuExportMapping;

public class ImportExportMenuScreen
extends AbstractMenuImportExportScreen
implements ActionListener {
    private JCheckBox checkBarcodes;
    private JComboBox profiles;
    private JComboBox priceLevels;
    private JComboBox stockAreas;
    private JComboBox inventoryGroup;
    private JComboBox versions;
    private JCheckBox identifierGen;
    private JCheckBox meta;
    private EventList inventoryGroupModel;

    public ImportExportMenuScreen(Action runImportAction, Action runExportAction) {
        super(runImportAction, runExportAction);
    }

    @Override
    protected int layoutExportComponents(PanelBuilder builder, FormLayout layout, CellConstraints cc, int row) {
        builder.add((Component)new JLabel("Menu section:"), cc.xy(1, row));
        this.inventoryGroupModel = new BasicEventList();
        this.inventoryGroup = new JComboBox(new EventComboBoxModel(this.inventoryGroupModel));
        this.inventoryGroup.setRenderer(new TreeNodeListCellRenderer());
        ComponentUtils.setupComboBox((JComboBox)this.inventoryGroup);
        builder.add((Component)this.inventoryGroup, cc.xy(3, row));
        builder.add((Component)new JLabel("To version:"), cc.xy(5, row));
        this.versions = new JComboBox<String>(MenuExportMapping.VERSIONS);
        builder.add((Component)this.versions, cc.xy(7, row));
        ComponentUtils.setupComboBox((JComboBox)this.versions);
        builder.add((Component)new JLabel("Identifier:"), cc.xy(9, row));
        this.identifierGen = new JCheckBox();
        this.identifierGen.setToolTipText("Include an identifier so all future updates will be based on the ID instead of the name.\nModifying the name won't result in a new item but in the modification of the existing one.\nThis can be used if there is one and only one master database.");
        builder.add((Component)this.identifierGen, cc.xy(11, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        builder.add((Component)new JLabel("Metadata:"), cc.xy(1, row += 2));
        this.meta = new JCheckBox();
        this.meta.setToolTipText("Include the version, profile, stock area, etc... into the exported file \nso these parameteres will be applied with auto import.");
        builder.add((Component)this.meta, cc.xy(3, row));
        return row;
    }

    @Override
    protected int layoutImportComponents(PanelBuilder builder, FormLayout layout, CellConstraints cc, int row) {
        JLabel profLabel = new JLabel("Menu Profile:");
        this.profiles = new JComboBox(InventoryProfile.getAllProfiles());
        this.profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportExportMenuScreen.this.refreshInventoryGroups();
            }
        });
        builder.add((Component)profLabel, cc.xy(1, row));
        builder.add((Component)this.profiles, cc.xy(3, row));
        ComponentUtils.setupComboBox((JComboBox)this.profiles);
        JLabel priceLabel = new JLabel("Price Level:");
        this.priceLevels = new JComboBox<Object>(PriceLevel.getAllPriceLevels().toArray());
        builder.add((Component)priceLabel, cc.xy(5, row));
        builder.add((Component)this.priceLevels, cc.xy(7, row));
        ComponentUtils.setupComboBox((JComboBox)this.priceLevels);
        JLabel stockAreaLabel = new JLabel("Stock Area:");
        this.stockAreas = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        builder.add((Component)stockAreaLabel, cc.xy(9, row));
        builder.add((Component)this.stockAreas, cc.xy(11, row));
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            this.stockAreas.setEnabled(false);
        }
        ComponentUtils.setupComboBox((JComboBox)this.stockAreas);
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        JLabel barCodeLabel = new JLabel("Check barcodes:");
        this.checkBarcodes = new JCheckBox();
        builder.add((Component)barCodeLabel, cc.xy(1, row += 2));
        builder.add((Component)this.checkBarcodes, cc.xy(3, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        return row += 2;
    }

    public void refresh() {
        this.profiles.removeAllItems();
        Iterator it = InventoryProfile.getAllProfiles().iterator();
        while (it.hasNext()) {
            this.profiles.addItem(it.next());
        }
        this.priceLevels.removeAllItems();
        it = PriceLevel.getAllPriceLevels().iterator();
        while (it.hasNext()) {
            this.priceLevels.addItem(it.next());
        }
        this.stockAreas.removeAllItems();
        it = StockArea.getStockAreas().iterator();
        while (it.hasNext()) {
            this.stockAreas.addItem(it.next());
        }
        this.fileName.setText("");
        this.setImportEnabled(false);
        this.setExportEnabled(false);
        this.progressInfo.setText("");
        this.progress.setValue(0);
        this.refreshInventoryGroups();
    }

    public void setMessage(String text) {
        this.progressInfo.setText(text);
    }

    public boolean getCheckBarcodes() {
        return this.checkBarcodes.isSelected();
    }

    public PriceLevel getPriceLevel() {
        return (PriceLevel)this.priceLevels.getSelectedItem();
    }

    public final InventoryProfile getProfile() {
        return (InventoryProfile)this.profiles.getSelectedItem();
    }

    public StockArea getStockArea() {
        return (StockArea)this.stockAreas.getSelectedItem();
    }

    public InventoryGroup getInventoryGroup() {
        if (this.inventoryGroup.getSelectedItem() instanceof InventoryGroup) {
            return (InventoryGroup)this.inventoryGroup.getSelectedItem();
        }
        return null;
    }

    public String getVersion() {
        return (String)this.versions.getSelectedItem();
    }

    public boolean isIdentifierGenerationSelected() {
        return this.identifierGen.isSelected();
    }

    public boolean isMetadataSelected() {
        return this.meta.isSelected();
    }

    private List getInventoryGroups() {
        if (this.getProfile() != null) {
            return this.getProfile().getProfileGroups(true);
        }
        return new ArrayList();
    }

    private void refreshInventoryGroups() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.inventoryGroupModel, this.getInventoryGroups());
    }

    @Override
    protected String getFileExtension() {
        return "csv";
    }

    @Override
    protected String getFileDescription() {
        return "CSV Files";
    }
}

