/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.screens.setup.menu.menuimport.AbstractMenuImportExportScreen;
import officemate.screens.setup.menu.menuimport.MenuItemSelector;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockSupplier;
import ordermate.jaxb.exporter.handlers.posdatabase.ExportMode;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;

public class XMLImportExportScreen
extends AbstractMenuImportExportScreen
implements ActionListener {
    private JCheckBoxCellRenderer inventoryProfileSelection;
    private JCheckBoxCellRenderer inventoryGroupSelection;
    private JCheckBoxCellRenderer priceLevelsSelection;
    private JCheckBoxCellRenderer stockAreasSelection;
    private JCheckBoxCellRenderer stockSupplierSelection;
    private JCheckBoxCellRenderer stockGroupsSelection;
    private JCheckBoxCellRenderer inventoryComboSelection;
    private JCheckBoxCellRenderer inventoryDiscountSelection;
    private EventList<InventoryProfile> inventoryProfiles;
    private EventList<InventoryGroup> inventoryGroups;
    private EventList<PriceLevel> allPriceLevels;
    private EventList<StockArea> stockAreas;
    private EventList<StockSupplier> suppliers;
    private EventList<StockGroup> stockGroups;
    private EventList<InventoryPriceAdjustment> inventoryDiscounts;
    private EventList<InventoryCombo> inventoryCombos;
    private EnumComboBoxModel<ExportMode> exportModeModel;
    private JButton menuItemsButton;
    private MenuItemSelector menuItemSelectorDialog;
    private List<InventoryItem> selectionMenuItems = new ArrayList<InventoryItem>();

    public XMLImportExportScreen(Action runImportAction, Action runExportAction) {
        super(runImportAction, runExportAction);
    }

    @Override
    protected int layoutExportComponents(PanelBuilder builder, FormLayout layout, CellConstraints cc, int row) {
        this.inventoryProfiles = new BasicEventList();
        this.inventoryGroups = new BasicEventList();
        this.allPriceLevels = new BasicEventList();
        this.stockAreas = new BasicEventList();
        this.suppliers = new BasicEventList();
        this.stockGroups = new BasicEventList();
        this.inventoryCombos = new BasicEventList();
        this.inventoryDiscounts = new BasicEventList();
        JLabel profLabel = new JLabel("Menu Profile:");
        JComboBox inventoryProfileCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.inventoryProfiles));
        this.inventoryProfileSelection = JCheckBoxCellRenderer.install((JComboBox)inventoryProfileCombo, (String)"All");
        this.inventoryProfileSelection.getSelectionEventList().addListEventListener(new ListEventListener(){

            public void listChanged(ListEvent arg0) {
                XMLImportExportScreen.this.refreshInventoryGroups();
            }
        });
        this.exportModeModel = new EnumComboBoxModel(ExportMode.class);
        this.exportModeModel.setSelectedItem((Object)ExportMode.Incremental);
        JComboBox exportModeBox = this.createComboBox((ComboBoxModel)this.exportModeModel);
        exportModeBox.setModel(this.exportModeModel);
        builder.add((Component)new JLabel("Export Mode:"), cc.xy(1, row));
        builder.add((Component)exportModeBox, cc.xy(3, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        builder.add((Component)profLabel, cc.xy(1, row += 2));
        builder.add((Component)inventoryProfileCombo, cc.xy(3, row));
        JLabel stockAreaLabel = new JLabel("Stock Area:");
        JComboBox stockAreasCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.stockAreas));
        builder.add((Component)stockAreaLabel, cc.xy(5, row));
        builder.add((Component)stockAreasCombo, cc.xy(7, row));
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            stockAreasCombo.setEnabled(false);
        }
        this.stockAreasSelection = JCheckBoxCellRenderer.install((JComboBox)stockAreasCombo, (String)"All");
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        JLabel priceLabel = new JLabel("Price Level:");
        JComboBox priceLevelsCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.allPriceLevels));
        builder.add((Component)priceLabel, cc.xy(1, row += 2));
        builder.add((Component)priceLevelsCombo, cc.xy(3, row));
        this.priceLevelsSelection = JCheckBoxCellRenderer.install((JComboBox)priceLevelsCombo, (String)"All");
        JLabel stockSupplierLabel = new JLabel("Supplier:");
        JComboBox stockSupplierCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.suppliers));
        builder.add((Component)stockSupplierLabel, cc.xy(5, row));
        builder.add((Component)stockSupplierCombo, cc.xy(7, row));
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            stockSupplierCombo.setEnabled(false);
        }
        this.stockSupplierSelection = JCheckBoxCellRenderer.install((JComboBox)stockSupplierCombo, (String)"All");
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        JLabel inventoryGroupLabel = new JLabel("Menu Section:");
        JComboBox inventoryGroupCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.inventoryGroups));
        builder.add((Component)inventoryGroupLabel, cc.xy(1, row += 2));
        builder.add((Component)inventoryGroupCombo, cc.xy(3, row));
        this.inventoryGroupSelection = JCheckBoxCellRenderer.install((JComboBox)inventoryGroupCombo, (String)"All");
        JLabel inventoryCombosLabel = new JLabel("Menu Combos:");
        JComboBox inventoryMenuComboCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.inventoryCombos));
        builder.add((Component)inventoryCombosLabel, cc.xy(5, row));
        builder.add((Component)inventoryMenuComboCombo, cc.xy(7, row));
        this.inventoryComboSelection = JCheckBoxCellRenderer.install((JComboBox)inventoryMenuComboCombo, (String)"All");
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        JLabel inventoryDiscountsLabel = new JLabel("Menu Discounts:");
        JComboBox inventoryMenuDiscountsCombo = this.createComboBox((ComboBoxModel)new EventComboBoxModel(this.inventoryDiscounts));
        builder.add((Component)inventoryDiscountsLabel, cc.xy(1, row += 2));
        builder.add((Component)inventoryMenuDiscountsCombo, cc.xy(3, row));
        this.inventoryDiscountSelection = JCheckBoxCellRenderer.install((JComboBox)inventoryMenuDiscountsCombo, (String)"All");
        JLabel menuItemsLabel = new JLabel("Menu Items:");
        this.menuItemsButton = new JButton("All Menu Items selected");
        this.menuItemsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XMLImportExportScreen.this.getMenuItemSelectorDialog().start()) {
                    XMLImportExportScreen.this.selectionMenuItems = XMLImportExportScreen.this.getMenuItemSelectorDialog().getSelectedInventoryItems();
                    if (!XMLImportExportScreen.this.selectionMenuItems.isEmpty()) {
                        XMLImportExportScreen.this.menuItemsButton.setText("Menu Selection active");
                    } else {
                        XMLImportExportScreen.this.menuItemsButton.setText("All Menu Items selected");
                    }
                }
            }
        });
        builder.add((Component)menuItemsLabel, cc.xy(5, row));
        builder.add((Component)this.menuItemsButton, cc.xy(7, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec("10px"));
        return row += 2;
    }

    private void refreshInventoryGroups() {
        Collection<InventoryProfile> profiles = this.getSelectedInventoryProfiles();
        List refreshedGroups = profiles.isEmpty() ? InventoryGroupQueries.getAllGroups() : PersistenceManager.getObjectList(InventoryGroup.class, (String)Query.select(InventoryGroup.class).wherePropertyIn(InventoryGroup.Properties.PROFILE, this.getSelectedInventoryProfiles()).toString());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.inventoryGroups, refreshedGroups);
    }

    private void refreshMenuItemsList() {
        this.menuItemsButton.setText("All Menu Items selected");
        if (this.menuItemSelectorDialog != null) {
            this.getMenuItemSelectorDialog().refreshComponentsWithData();
        }
    }

    @Override
    protected int layoutImportComponents(PanelBuilder builder, FormLayout layout, CellConstraints cc, int row) {
        return row;
    }

    private JComboBox createComboBox(ComboBoxModel model) {
        JComboBox box = new JComboBox(model);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(box);
        return box;
    }

    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.inventoryProfiles, InventoryProfile.getAllProfiles());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPriceLevels, PriceLevel.getAllPriceLevels());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.stockAreas, StockArea.getStockAreas());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.suppliers, StockSupplier.getSuppliers());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.stockGroups, StockGroup.getAllStockGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.inventoryCombos, InventoryCombo.getAllCombos());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.inventoryDiscounts, InventoryPriceAdjustment.getAllPriceAdjustments());
        this.refreshInventoryGroups();
        this.refreshMenuItemsList();
    }

    public Collection<InventoryGroup> getSelectedInventoryGroups() {
        LinkedHashSet groups = this.inventoryGroupSelection.getSelectedElements();
        if (groups.isEmpty()) {
            return PersistenceManager.getObjectList(InventoryGroup.class, (String)Query.select(InventoryGroup.class).wherePropertyIn(InventoryGroup.Properties.PROFILE, this.getSelectedInventoryProfiles()).toString());
        }
        return groups;
    }

    public Collection<InventoryProfile> getSelectedInventoryProfiles() {
        LinkedHashSet profiles = this.inventoryProfileSelection.getSelectedElements();
        if (profiles.isEmpty()) {
            return InventoryProfile.getAllProfiles();
        }
        return profiles;
    }

    public Collection<PriceLevel> getSelectedPriceLevels() {
        LinkedHashSet priceLevels = this.priceLevelsSelection.getSelectedElements();
        if (priceLevels.isEmpty()) {
            return PriceLevel.getAllPriceLevels();
        }
        return priceLevels;
    }

    public Collection<StockArea> getSelectedStockAreas() {
        LinkedHashSet selectedAreas = this.stockAreasSelection.getSelectedElements();
        if (selectedAreas.isEmpty()) {
            return StockArea.getStockAreas();
        }
        return selectedAreas;
    }

    public Collection<StockSupplier> getSelectedSuppliers() {
        LinkedHashSet selectedSuppliers = this.stockSupplierSelection.getSelectedElements();
        if (selectedSuppliers.isEmpty()) {
            return StockSupplier.getSuppliers();
        }
        return selectedSuppliers;
    }

    public Collection<InventoryCombo> getSelectedMenuCombos() {
        LinkedHashSet combos = this.inventoryComboSelection.getSelectedElements();
        if (combos.isEmpty()) {
            return InventoryCombo.getAllCombos();
        }
        return combos;
    }

    public Collection<InventoryPriceAdjustment> getSelectedMenuDiscounts() {
        LinkedHashSet menuDiscounts = this.inventoryDiscountSelection.getSelectedElements();
        if (menuDiscounts.isEmpty()) {
            return InventoryPriceAdjustment.getAllPriceAdjustments();
        }
        return menuDiscounts;
    }

    public Collection getSelectedMenuItems() {
        HashSet<InventoryItem> menuItems = new HashSet<InventoryItem>(this.getMenuItemSelectorDialog().getSelectedInventoryItems());
        if (!menuItems.isEmpty()) {
            return menuItems;
        }
        return null;
    }

    public Set<InventoryItem> getSelectedMenuItemsAsSet() {
        HashSet<InventoryItem> menuItems = new HashSet<InventoryItem>(this.getMenuItemSelectorDialog().getSelectedInventoryItems());
        if (!menuItems.isEmpty()) {
            return menuItems;
        }
        return null;
    }

    public ExportMode getSelectedExportMode() {
        return (ExportMode)this.exportModeModel.getSelectedItem();
    }

    @Override
    protected String getFileExtension() {
        return "xml";
    }

    @Override
    protected String getFileDescription() {
        return "Xml Files";
    }

    private MenuItemSelector getMenuItemSelectorDialog() {
        if (this.menuItemSelectorDialog == null) {
            this.menuItemSelectorDialog = new MenuItemSelector(OfficeMate.getApplicationFrame());
        }
        return this.menuItemSelectorDialog;
    }
}

