/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import officemate.components.AbstractObjectEditor;
import ordermate.database.inventory.ItemSummary;

public class HTMLPreviewEditor
extends AbstractObjectEditor<ItemSummary>
implements ActionListener {
    private JEditorPane htmlPreview;
    private JTextArea textEditor;
    private JButton refreshButton;
    private JScrollPane scroller;
    private PropertiedObject.Property prop;

    public HTMLPreviewEditor(PropertiedObject.Property listProp) {
        this.prop = listProp;
        this.setLayout(new BorderLayout());
        JPanel textFieldsPanel = new JPanel();
        textFieldsPanel.setLayout(new BoxLayout(textFieldsPanel, 0));
        this.htmlPreview = new JEditorPane("text/html", "");
        this.htmlPreview.setBorder(new BevelBorder(1));
        this.htmlPreview.setEditable(false);
        this.htmlPreview.setPreferredSize(new Dimension(300, 300));
        this.htmlPreview.setBackground(new Color(241, 242, 243));
        this.htmlPreview.setName("htmlPreview");
        this.scroller = new JScrollPane(this.htmlPreview);
        this.scroller.setHorizontalScrollBarPolicy(30);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.textEditor = new JTextArea();
        this.textEditor.setBorder(new BevelBorder(1));
        this.textEditor.setPreferredSize(new Dimension(200, 300));
        this.textEditor.setName("textEditor");
        this.textEditor.setLineWrap(true);
        textFieldsPanel.add(this.textEditor);
        textFieldsPanel.add(this.scroller);
        this.add((Component)textFieldsPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        buttonPanel.add(this.refreshButton);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.refreshButton)) {
            this.htmlPreview.setText(this.textEditor.getText());
            this.htmlPreview.invalidate();
            this.htmlPreview.repaint();
        }
    }

    @Override
    public void setObject(ItemSummary toEdit) {
        super.setObject(toEdit);
        this.textEditor.setText((String)toEdit.getPropertyValue(this.prop));
        this.htmlPreview.setText(this.textEditor.getText());
    }

    @Override
    public void saveObject() {
        ((ItemSummary)this.getObject()).setPropertyValue(this.prop, (Object)this.textEditor.getText());
        super.saveObject();
    }
}

