/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import ordermate.OrderMate;

public class ImagePreviewChooser
extends JFileChooser {
    private PreviewPanel previewPanel = new PreviewPanel(this);

    public ImagePreviewChooser() {
        super.setFileFilter(new FileNameExtensionFilter(".png, .jpg, .gif", "png", "jpg", "gif"));
        super.setAccessory(this.previewPanel);
    }

    public class PreviewPanel
    extends JPanel
    implements PropertyChangeListener {
        private final int DEFAULTINSET = 5;

        public PreviewPanel(JFileChooser chooser) {
            super(new BorderLayout());
            this.DEFAULTINSET = 5;
            chooser.addPropertyChangeListener(this);
            this.setPreferredSize(new Dimension(300, 300));
            this.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(5, 5, 5, 5))));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
                JFileChooser chooser = (JFileChooser)evt.getSource();
                File newFile = (File)evt.getNewValue();
                this.updatePreview(newFile);
            }
        }

        private void updatePreview(File toPreview) {
            this.removeAll();
            Dimension DIM = this.getPreferredSize();
            DIM = new Dimension(DIM.width - 10, DIM.height - 10);
            JLabel label = new JLabel();
            label.setPreferredSize(DIM);
            this.add(label);
            Image image = null;
            try {
                image = ImageIO.read(toPreview);
                if (image != null) {
                    ImageHelper helper = new ImageHelper();
                    image = helper.fitImageTo(image, DIM.width, DIM.height);
                    label.setIcon(new ImageIcon(image));
                } else {
                    label.setText("This is not a valid image");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("The given resource is not a valid image:" + toPreview.getAbsolutePath());
                label.setText("This image cannot be loaded.");
            }
            this.validate();
            this.repaint();
        }
    }
}

