/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import ca.odell.glazedlists.BasicEventList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.screens.setup.stock.ingredients.IngredientEditor;
import officemate.screens.setup.stock.ingredients.IngredientsPanel;
import officemate.screens.setup.stock.units.UnitsUsageStockCostPanel;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.reports.table.ColumnFormat;

class MinusObjectEditor
extends TableListObjectEditor<ItemSummary, InventoryRemove> {
    private AbstractEditableTableState<ItemSummary> parentState;
    private UnitsUsageStockCostPanel stockCostPanel;
    private IngredientsPanel ingredientsPanel;

    public MinusObjectEditor(AbstractEditableTableState<ItemSummary> parentState) {
        super(new PersistentObjectTable(new BasicEventList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(InventoryRemove.Properties.LABEL), new EditablePropertyColumnFormat(InventoryRemove.Properties.PRICE), new EditablePropertyColumnFormat(InventoryRemove.Properties.FOREGROUND_COLOR), new EditablePropertyColumnFormat(InventoryRemove.Properties.BACKGROUND_COLOR), new EditablePropertyColumnFormat(InventoryRemove.Properties.AVAILABLE_ONLINE)})));
        this.getPersistentObjectTable().getTable().setSortable(false);
        this.parentState = parentState;
    }

    private void optionallyAddIngredientsPanel() {
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            this.stockCostPanel = new UnitsUsageStockCostPanel();
            List<ColumnFormat> ingredientEditorCols = IngredientEditor.getColumnFormat(StockUsageLink.class, true);
            ingredientEditorCols.add(new EditablePropertyColumnFormat(StockInventoryUsageLink.Properties.REMOVABLE));
            ingredientEditorCols.add(new EditablePropertyColumnFormat("Minus price", StockInventoryUsageLink.Properties.REMOVE_PRICE));
            ingredientEditorCols.add(new EditablePropertyColumnFormat("Foreground", StockInventoryUsageLink.Properties.FOREGROUND_COLOR));
            ingredientEditorCols.add(new EditablePropertyColumnFormat("Background", StockInventoryUsageLink.Properties.BACKGROUND_COLOR));
            IngredientEditor<ItemSummary, StockInventoryUsageLink> editor = IngredientEditor.create(this.parentState.getSaveStrategy(), this.parentState.getCentralArea(), StockInventoryUsageLink.class, ingredientEditorCols, true);
            this.ingredientsPanel = new IngredientsPanel<ItemSummary, StockInventoryUsageLink>(this.parentState, this.stockCostPanel, editor, 650);
            this.add((Component)this.ingredientsPanel.getGuiComponent(), "South");
        }
    }

    @Override
    public void revertObject() {
        super.revertObject();
        if (this.ingredientsPanel != null && this.ingredientsPanel.getIngredientEditor() != null) {
            this.ingredientsPanel.getIngredientEditor().revertObject();
        }
    }

    @Override
    protected void setParentList(Collection<InventoryRemove> toSet) {
        if (toSet != null) {
            ((ItemSummary)this.getObject()).setMinuses(new ArrayList<InventoryRemove>(toSet));
        } else {
            ((ItemSummary)this.getObject()).setMinuses(null);
        }
    }

    @Override
    public Collection<InventoryRemove> getParentList() {
        ItemSummary summary = (ItemSummary)this.getObject();
        List minuses = summary.getMinuses();
        ArrayList<InventoryRemove> freshList = new ArrayList<InventoryRemove>(minuses.size());
        for (InventoryRemove remove : minuses) {
            freshList.add(new InventoryRemove(remove));
        }
        return freshList;
    }

    @Override
    public void addObjectToParent(InventoryRemove toAdd) {
    }

    @Override
    public void removeObjectFromParent(InventoryRemove toRemove) {
    }

    @Override
    public InventoryRemove createNewObject() {
        return new InventoryRemove();
    }

    public void initialize() {
        this.optionallyAddIngredientsPanel();
    }

    @Override
    public void setObject(ItemSummary toEdit) {
        super.setObject(toEdit);
        if (this.ingredientsPanel != null) {
            this.ingredientsPanel.setObject(toEdit.getInventoryItemUnitObject());
        }
    }
}

