/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.SequenceEditor;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.ItemSummary;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class OptionGroupLinkEditor
extends AbstractObjectEditor<ItemSummary>
implements ListEventListener<InventoryOptionGroupLink> {
    private JButton removeGroupBtn;
    private JButton removeAllBtn;
    private EventList<InventoryOptionGroupLink> optionGroupLinks = GlazedLists.eventList(new ArrayList());
    private EventList<InventoryOptionGroup> allOptionGroups;
    private PersistentObjectTable<InventoryOptionGroupLink> table;

    public OptionGroupLinkEditor(EventList<InventoryOptionGroup> possibleElements) {
        this.allOptionGroups = possibleElements;
        this.setupComponents();
        this.optionGroupLinks.addListEventListener((ListEventListener)this);
    }

    public void setupComponents() {
        this.setLayout(new BorderLayout());
        JButton addGroupBtn = new JButton((Action)((Object)new AddOptionGroup()));
        RemoveOptionAction removeOptionAction = new RemoveOptionAction();
        this.removeGroupBtn = new JButton((Action)((Object)removeOptionAction));
        this.removeAllBtn = new JButton((Action)((Object)new RemoveAllOptionsAction()));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(addGroupBtn);
        buttonPanel.add(this.removeGroupBtn);
        buttonPanel.add(this.removeAllBtn);
        this.add((Component)buttonPanel, "East");
        this.removeAllBtn.setEnabled(!this.optionGroupLinks.isEmpty());
        this.table = new PersistentObjectTable<InventoryOptionGroupLink>(this.optionGroupLinks, new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new PropertyColumnFormat(InventoryOptionGroupLink.Properties.OPTION_GROUP), new EditablePropertyColumnFormat(InventoryOptionGroupLink.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryOptionGroupLink.Properties.MIN_QTY).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryOptionGroupLink.Properties.MAX_QTY).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryOptionGroupLink.Properties.REDUCED_ZONE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor()))}));
        this.add(this.table, "Center");
        this.table.addSelectionDependentAction((Action)((Object)removeOptionAction));
    }

    private EventList<InventoryOptionGroup> getAvaliableOptionGroups() {
        EventList groupsAval = GlazedLists.eventList(this.allOptionGroups);
        if (this.getObject() != null && ((ItemSummary)this.getObject()).getInventoryItemUnitObject() != null) {
            for (InventoryOptionGroupLink link : ((ItemSummary)this.getObject()).getInventoryItemUnitObject().getOptionGroupLinks()) {
                groupsAval.remove((Object)link.getOptionGroup());
            }
        }
        groupsAval.removeAll(this.getGroupsFromLinks((List<InventoryOptionGroupLink>)this.optionGroupLinks));
        return groupsAval;
    }

    private List<InventoryOptionGroup> getGroupsFromLinks(List<InventoryOptionGroupLink> optionsLinksList) {
        ArrayList<InventoryOptionGroup> groupList = new ArrayList<InventoryOptionGroup>();
        for (InventoryOptionGroupLink link : this.optionGroupLinks) {
            groupList.add(link.getOptionGroup());
        }
        return groupList;
    }

    @Override
    public void saveObject() {
        ((ItemSummary)this.getObject()).setOptionGroupLinks(this.optionGroupLinks);
        super.saveObject();
    }

    @Override
    public void setObject(ItemSummary toEdit) {
        super.setObject(toEdit);
        this.optionGroupLinks.clear();
        this.optionGroupLinks.addAll((Collection)toEdit.getOptionGroupLinks());
    }

    private void addNew() {
        ArrayList<InventoryOptionGroup> groupPool = new ArrayList<InventoryOptionGroup>((Collection<InventoryOptionGroup>)this.allOptionGroups);
        int highest = 0;
        for (InventoryOptionGroupLink link : this.optionGroupLinks) {
            groupPool.remove(link.getOptionGroup());
            highest = Math.max(highest, link.getSequence());
        }
        if (groupPool.isEmpty()) {
            Dialogs.showInfoDialog("No Other Option Groups", "There are no other Option Groups left to add.");
            return;
        }
        InventoryOptionGroup group = (InventoryOptionGroup)Dialogs.showOptionDialog("Option Group", "Please select an option group", groupPool);
        if (group != null) {
            InventoryOptionGroupLink link;
            link = new InventoryOptionGroupLink(((ItemSummary)this.getObject()).getInventoryItemUnitObject(), group);
            link.setSequence(highest + 1);
            GlazedListUtils.add(this.optionGroupLinks, (Object)link);
        }
    }

    private void removeOption() {
        for (InventoryOptionGroupLink link : this.table.getAllSelectedObjects()) {
            GlazedListUtils.delete(this.optionGroupLinks, (Object)link);
        }
    }

    public void listChanged(ListEvent listChanges) {
        this.removeAllBtn.setEnabled(!listChanges.getSourceList().isEmpty());
    }

    private void removeAllOptions() {
        GlazedListUtils.clearAll(this.optionGroupLinks);
    }

    private class RemoveAllOptionsAction
    extends BasicAction {
        public RemoveAllOptionsAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Remove All");
        }

        public void actionPerformed(ActionEvent e) {
            OptionGroupLinkEditor.this.removeAllOptions();
        }
    }

    private class RemoveOptionAction
    extends BasicAction {
        public RemoveOptionAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            OptionGroupLinkEditor.this.removeOption();
        }
    }

    private class AddOptionGroup
    extends BasicAction {
        public AddOptionGroup() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add An Option Group");
        }

        public void actionPerformed(ActionEvent e) {
            OptionGroupLinkEditor.this.addNew();
        }
    }
}

