/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.defaultmod;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ParentChildRenderer<P extends PropertiedObject, C extends PropertiedObject>
extends JPanel
implements ListCellRenderer {
    private final JLabel parentLabel;
    private final JLabel childLabel;
    private final PropertyAccessor<P> parentProperty;

    public ParentChildRenderer(PropertyAccessor<P> childToParent) {
        super(new GridLayout(1, 2));
        this.parentProperty = childToParent;
        this.parentLabel = new JLabel();
        this.childLabel = new JLabel();
        this.add(this.parentLabel);
        this.add(this.childLabel);
        this.setBackground(null);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        PropertiedObject parent = (PropertiedObject)this.parentProperty.resolveValue(value);
        int childIndex = index;
        for (int i = index; i > 0; --i) {
            if (parent.equals(this.parentProperty.resolveValue(list.getModel().getElementAt(i - 1)))) continue;
            childIndex = index - i;
            break;
        }
        this.styleParent(this.parentLabel, parent, (PropertiedObject)value, childIndex);
        this.styleChild(this.childLabel, parent, (PropertiedObject)value, childIndex);
        if (cellHasFocus) {
            this.setBackground(Color.GRAY);
        } else {
            this.setBackground(isSelected ? Color.lightGray : null);
        }
        return this;
    }

    protected void styleParent(JLabel label, P parent, C child, int childIndex) {
        if (childIndex != 0) {
            label.setVisible(false);
        } else {
            label.setText(parent.toString());
            label.setVisible(true);
        }
    }

    protected void styleChild(JLabel label, P parent, C child, int childIndex) {
        label.setText(child.toString());
    }
}

