/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.components.table.EditMultiple;
import officemate.components.table.PersistentObjectTable;
import officemate.screens.setup.menu.menuitemsetup.multi.defadds.MultiDefaultAddEditor;
import officemate.screens.setup.menu.menuitemsetup.multi.defoption.MultiDefaultOptionEditor;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.MultiOptionGroupLinkEditor;
import ordermate.database.inventory.ItemSummary;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;

public class ItemSummaryEditMultiple
extends EditMultiple
implements ActionListener {
    private JButton optionGroupsButton;
    private JButton defaultAddsButton;
    private JButton defaultOptionsButton;
    private MultiOptionGroupLinkEditor optionGroupEditor;
    private MultiDefaultAddEditor defaultAddEditor;
    private MultiDefaultOptionEditor defaultOptionsEditor;
    private BindingHelper<ItemSummary> bindings;
    private Map<EditMultiple.EditorWrapper, Binding> wrapperBindingMap;

    @Override
    public void initialise(PersistentObjectTable objectTable, PropertiedObject.Property[] propertiesToExclude) {
        this.bindings = new BindingHelper();
        this.bindings.setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.wrapperBindingMap = new HashMap<EditMultiple.EditorWrapper, Binding>();
        super.initialise(objectTable, propertiesToExclude);
        ItemSummary summary = (ItemSummary)this.getTable().getSelectedObject();
        this.bindings.setObject((Object)summary);
    }

    @Override
    protected EditMultiple.EditorWrapper createEditorComponent(TableColumn column) {
        EditMultiple.EditorWrapper wrapper;
        Object identifier = column.getIdentifier();
        if (ItemSummary.Properties.OPTION_GROUPS.equals(identifier)) {
            this.optionGroupsButton = new JButton("Option Groups...");
            this.optionGroupsButton.addActionListener(this);
            wrapper = this.wrap(this.optionGroupsButton, column);
        } else if (ItemSummary.Properties.DEFAULT_ADDS.equals(identifier)) {
            this.defaultAddsButton = new JButton("Default Adds...");
            this.defaultAddsButton.addActionListener(this);
            wrapper = this.wrap(this.defaultAddsButton, column);
        } else if (ItemSummary.Properties.DEFAULT_OPTIONS.equals(identifier)) {
            this.defaultOptionsButton = new JButton("Default Options...");
            this.defaultOptionsButton.addActionListener(this);
            wrapper = this.wrap(this.defaultOptionsButton, column);
        } else {
            wrapper = ItemSummary.Properties.NAME.equals(identifier) || ItemSummary.Properties.SHORT_NAME.equals(identifier) || ItemSummary.Properties.ICON.equals(identifier) || ItemSummary.Properties.LOYALTY_ADD.equals(identifier) || ItemSummary.Properties.LOYALTY_REDEEM.equals(identifier) ? this.makeText((PropertiedObject.Property)identifier, column) : (ItemSummary.Properties.OPEN_PRICE.equals(identifier) || ItemSummary.Properties.AUTO_ITEM_NOTE.equals(identifier) ? this.makeCheck((PropertiedObject.Property)identifier, column) : super.createEditorComponent(column));
        }
        return wrapper;
    }

    private EditMultiple.EditorWrapper makeText(PropertiedObject.Property property, TableColumn column) {
        JTextField field = new JTextField(20);
        field.setName("multi-" + property.getName());
        EditMultiple.EditorWrapper wrapper = this.wrap(field, column);
        this.wrapperBindingMap.put(wrapper, this.bindings.createBinding(property, (Object)field, "text"));
        return wrapper;
    }

    private EditMultiple.EditorWrapper makeCheck(PropertiedObject.Property property, TableColumn column) {
        JCheckBox box = new JCheckBox();
        box.setName("multi-" + property.getName());
        EditMultiple.EditorWrapper wrapper = this.wrap(box, column);
        this.wrapperBindingMap.put(wrapper, this.bindings.createBinding(property, (Object)box, "selected"));
        return wrapper;
    }

    private EditMultiple.EditorWrapper wrap(JComponent wrap, TableColumn column) {
        int actualCol = this.getTable().getTable().convertColumnIndexToView(column.getModelIndex());
        return new EditMultiple.EditorWrapper(null, wrap, actualCol, String.valueOf(column.getHeaderValue()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.optionGroupsButton) {
            this.doOptionGroups();
        } else if (e.getSource() == this.defaultAddsButton) {
            this.doDefaultAdds();
        } else if (e.getSource() == this.defaultOptionsButton) {
            this.doDefaultOptions();
        }
    }

    @Override
    protected void saveWrapper(EditMultiple.EditorWrapper wrapper) {
        if (this.optionGroupsButton == wrapper.getEditorComponent()) {
            if (this.optionGroupEditor != null) {
                this.optionGroupEditor.applyToList(this.getTable().getAllSelectedObjects());
            }
        } else if (this.defaultAddsButton == wrapper.getEditorComponent()) {
            if (this.defaultAddEditor != null) {
                this.defaultAddEditor.applyToList(this.getTable().getAllSelectedObjects());
            }
        } else if (this.defaultOptionsButton == wrapper.getEditorComponent()) {
            if (this.defaultOptionsEditor != null) {
                this.defaultOptionsEditor.applyToList(this.getTable().getAllSelectedObjects());
            }
        } else if (this.wrapperBindingMap.containsKey(wrapper)) {
            Binding binding = this.wrapperBindingMap.get(wrapper);
            for (Object summary : this.getTable().getAllSelectedObjects()) {
                if (binding.isBound()) {
                    binding.unbind();
                }
                binding.setSourceObject(summary);
                binding.save();
            }
        } else {
            super.saveWrapper(wrapper);
        }
    }

    @Override
    public void save() {
        super.save();
        this.optionGroupEditor = null;
        this.defaultAddEditor = null;
        this.defaultOptionsEditor = null;
        this.bindings = null;
        this.wrapperBindingMap = null;
    }

    private void doOptionGroups() {
        if (this.optionGroupEditor == null) {
            this.optionGroupEditor = new MultiOptionGroupLinkEditor();
        }
        OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(this.optionGroupEditor.getComponent());
        builder.hideCancel().doPack();
        builder.doShow();
    }

    private void doDefaultAdds() {
        List<ItemSummary> summaries;
        if (this.defaultAddEditor == null) {
            this.defaultAddEditor = new MultiDefaultAddEditor();
        }
        if (this.defaultAddEditor.canDisplay(summaries = this.getTable().getAllSelectedObjects())) {
            this.defaultAddEditor.setList(summaries);
            OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(this.defaultAddEditor.getComponent());
            builder.hideCancel().doPack();
            builder.doShow();
        } else {
            Dialogs.showWarningDialog("Cannot Multiple Edit", "The selected items have differing Plus Groups, Multi Select is not possible.");
        }
    }

    private void doDefaultOptions() {
        List<ItemSummary> summaries;
        if (this.defaultOptionsEditor == null) {
            this.defaultOptionsEditor = new MultiDefaultOptionEditor();
        }
        if (this.defaultOptionsEditor.canDisplay(summaries = this.getTable().getAllSelectedObjects())) {
            this.defaultOptionsEditor.setList(summaries);
            OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(this.defaultOptionsEditor.getComponent());
            builder.hideCancel().doPack();
            builder.doShow();
        } else {
            Dialogs.showWarningDialog("Cannot Multiple Edit", "The selected items have no Option Groups in common, Multi Select is not possible.");
        }
    }
}

