/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi.optiongroup;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.tableformat.renderers.AbstractDialogCellEditor;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.MultiOptionTableModel;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.OptionGroupAction;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.OptionGroupActionType;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.ItemSummary;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class MultiOptionGroupLinkEditor {
    private static final Color ADD = new Color(200, 255, 200);
    private static final Color UPDATE = new Color(255, 255, 200);
    private static final Color REMOVE = new Color(255, 200, 200);
    private MultiOptionTableModel model;
    private JTable table;
    private JComponent component;

    public MultiOptionGroupLinkEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.model = new MultiOptionTableModel(this);
        this.model.reset();
        this.table = new JTable(this.model);
        JComboBox<OptionGroupActionType> typeCombo = new JComboBox<OptionGroupActionType>(OptionGroupActionType.values());
        this.table.setDefaultEditor(OptionGroupActionType.class, (TableCellEditor)new ComboBoxCellEditor(typeCombo));
        this.table.setDefaultEditor(String.class, new AbstractDialogCellEditor(){

            @Override
            public Object doDialog() {
                OptionGroupAction action = ((MultiOptionGroupLinkEditor)MultiOptionGroupLinkEditor.this).model.actions.get(MultiOptionGroupLinkEditor.this.table.getSelectedRow());
                Dialogs.showInfoDialog("Action Summary", "<html>" + action.createMessageForAction() + "</html>");
                return null;
            }
        });
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                OptionGroupActionType type = (OptionGroupActionType)((Object)MultiOptionGroupLinkEditor.this.model.getValueAt(row, 0));
                switch (type) {
                    case None: {
                        this.setBackground(null);
                        break;
                    }
                    case Add: {
                        this.setBackground(ADD);
                        break;
                    }
                    case Update: {
                        this.setBackground(UPDATE);
                        break;
                    }
                    case Remove: {
                        this.setBackground(REMOVE);
                    }
                }
                this.setForeground(Color.BLACK);
                return this;
            }
        });
        this.component = new JScrollPane(this.table);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void applyToList(List<ItemSummary> allSelectedObjects) {
        for (OptionGroupAction nextAction : this.model.actions) {
            switch (nextAction.getType()) {
                case Add: {
                    this.doAdd(nextAction, allSelectedObjects);
                    break;
                }
                case Remove: {
                    this.doRemove(nextAction, allSelectedObjects);
                    break;
                }
                case Update: {
                    this.doUpdate(nextAction, allSelectedObjects);
                    break;
                }
            }
        }
    }

    private void doAdd(OptionGroupAction nextAction, List<ItemSummary> allSelectedObjects) {
        Integer sequence = nextAction.getSequence();
        for (ItemSummary summary : allSelectedObjects) {
            InventoryOptionGroupLink link = summary.addOptionGroup(nextAction.getGroup());
            link.setMinQty(nextAction.getMin() != null ? nextAction.getMin() : 0);
            link.setMaxQty(nextAction.getMax() != null ? nextAction.getMax() : 0);
            link.setReducedZone(nextAction.getReduced() != null ? nextAction.getReduced() : 0);
            if (sequence == null) continue;
            link.setSequence(sequence.intValue());
        }
    }

    private void doRemove(OptionGroupAction nextAction, List<ItemSummary> allSelectedObjects) {
        for (ItemSummary summary : allSelectedObjects) {
            InventoryOptionGroupLink toRemove = null;
            for (InventoryOptionGroupLink link : summary.getOptionGroupLinks()) {
                if (!nextAction.getGroup().equals((Object)link.getOptionGroup())) continue;
                toRemove = link;
                break;
            }
            if (toRemove == null) continue;
            summary.getOptionGroupLinks().remove(toRemove);
        }
    }

    private void doUpdate(OptionGroupAction nextAction, List<ItemSummary> allSelectedObjects) {
        block0: for (ItemSummary summary : allSelectedObjects) {
            for (InventoryOptionGroupLink link : summary.getOptionGroupLinks()) {
                if (!link.getOptionGroup().equals((Object)nextAction.getGroup())) continue;
                if (nextAction.getMin() != null) {
                    link.setMinQty(nextAction.getMin().intValue());
                }
                if (nextAction.getMax() != null) {
                    link.setMaxQty(nextAction.getMax().intValue());
                }
                if (nextAction.getReduced() != null) {
                    link.setReducedZone(nextAction.getReduced().intValue());
                }
                if (nextAction.getSequence() == null) continue block0;
                link.setSequence(nextAction.getSequence().intValue());
                continue block0;
            }
        }
    }
}

