/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menusection;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.controls.ColourSelector;
import officemate.screens.setup.menu.menusection.TriggerPropertyEditor;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.triggers.activation.StrategyRegister;
import ordermate.database.users.PermissionGroup;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Validator;

public class MenuSectionPanel
extends AbstractObjectEditor<InventoryGroup> {
    private JComboBox permissionCombo;

    public MenuSectionPanel() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT");
        }
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JTextField name = this.setupTextField(InventoryGroup.Properties.LABEL, 20, (Validator)new NotEmptyValidator());
        name.setName("sectionName");
        builder.addRow("Menu Section name", (Component)name);
        JFormattedTextField sequence = this.setupPositiveIntegerField(InventoryGroup.Properties.SEQUENCE, 20, true, false);
        builder.addRow("Sequence", (Component)sequence);
        ColourSelector foregroundSelect = this.setupColorSelection(InventoryGroup.Properties.FOREGROUND_COLOR);
        builder.addRow("Foreground color", (Component)foregroundSelect);
        ColourSelector backgroundSelect = this.setupColorSelection(InventoryGroup.Properties.BACKGROUND_COLOR);
        builder.addRow("Background color", (Component)backgroundSelect);
        JTextField extID = this.setupTextField(InventoryGroup.Properties.EXTERNAL_ID, 20);
        builder.addRow("External ID", (Component)extID);
        JCheckBox active = new JCheckBox();
        Binding activeBinding = this.getBindings().createBinding("active", (Object)active, "selected");
        activeBinding.addBindingListener((BindingListener)this.getListener());
        builder.addRow("Active", (Component)active);
        TriggerPropertyEditor triggerEditor = new TriggerPropertyEditor();
        Binding triggerBinding = this.getBindings().createBinding("triggers", (Object)triggerEditor, "list");
        triggerBinding.addBindingListener((BindingListener)this.getListener());
        builder.addRow("Triggers", (Component)triggerEditor);
        JComboBox strategyCombo = this.setupComboBox(InventoryGroup.Properties.TRIGGER_ACTIVATION_STRATEGY, GlazedLists.eventList((Collection)StrategyRegister.getAllStrategies()));
        builder.addRow("Activation Strategy", (Component)strategyCombo);
        this.permissionCombo = this.setupNullableComboBox(InventoryGroup.Properties.PERMISSION_GROUP, GlazedLists.eventList((Collection)PermissionGroup.getPermissionGroups()), "Default");
        this.permissionCombo.setToolTipText("Sets the minimum permission available to edit a menu section");
        builder.addRow("Editing Permission", (Component)this.permissionCombo);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(InventoryGroup group) {
        PermissionGroup clearance = GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup();
        boolean mayEdit = group.canModify(clearance);
        for (Binding nextBinding : this.getBindings().getAllBindings()) {
            Object target = nextBinding.getTargetObject();
            if (!(target instanceof JComponent)) continue;
            ((JComponent)target).setEnabled(mayEdit);
        }
        this.permissionCombo.setEnabled(clearance.getLevel() >= PermissionGroup.getPermissionGroupForName((String)"Administrator").getLevel());
        super.setObject(group);
    }

    @Override
    public void saveObject() {
        InventoryGroup group = (InventoryGroup)this.getObject();
        if (group.canModify(GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup())) {
            super.saveObject();
        } else {
            super.setObject(group);
            Dialogs.showWarningDialog("Cannot save", "You don't have adequate permission to save this group");
        }
    }
}

