/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.options;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.menu.menusection.TriggerPropertyEditor;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.triggers.activation.StrategyRegister;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.model.NullableEventComboBoxModel;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;

class InventoryOptionGroupEditor
extends AbstractObjectEditor<InventoryOptionGroup> {
    private final EventList<InventoryItemSize> allSizes = GlazedLists.eventList((Collection)InventoryItemSize.getAllSizes());
    private final EventList<InventoryOption> currentOptions = new BasicEventList();
    private final EventList<InventoryOptionGroup> allExistingGroups;
    private NullableEventComboBoxModel copyFromModel;

    public InventoryOptionGroupEditor() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Label", (Component)this.setupTextField(InventoryOptionGroup.Properties.LABEL, 20));
        builder.addRow("Size", (Component)this.setupComboBox(InventoryOptionGroup.Properties.SIZE, this.allSizes));
        builder.addRow("Printable", (Component)this.setupCheckBox(InventoryOptionGroup.Properties.PRINTABLE));
        JFormattedTextField sequence = this.setupPositiveIntegerField(InventoryOptionGroup.Properties.SEQUENCE, 20, true, false);
        builder.addRow("Sequence", (Component)sequence);
        TriggerPropertyEditor triggerEditor = new TriggerPropertyEditor();
        Binding triggerBinding = this.getBindings().createBinding("triggers", (Object)triggerEditor, "list");
        triggerBinding.addBindingListener((BindingListener)this.getListener());
        builder.addRow("Triggers", (Component)triggerEditor);
        JComboBox strategyCombo = this.setupComboBox(InventoryOptionGroup.Properties.TRIGGER_ACTIVATION_STRATEGY, GlazedLists.eventList((Collection)StrategyRegister.getAllStrategies()));
        builder.addRow("Activation Strategy", (Component)strategyCombo);
        JComboBox defaultOptionCombo = this.setupNullableComboBox(InventoryOptionGroup.Properties.DEFAULT_OPTION, this.currentOptions, "<No Default>");
        builder.addRow("Default Option", (Component)defaultOptionCombo);
        this.allExistingGroups = new BasicEventList();
        this.copyFromModel = new NullableEventComboBoxModel(this.allExistingGroups);
        JComboBox copyFromCombo = new JComboBox(this.copyFromModel);
        copyFromCombo.setName("copyFrom");
        builder.addRow("Copy Options From", copyFromCombo);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(InventoryOptionGroup toEdit) {
        this.loadOptions(toEdit);
        super.setObject(toEdit);
    }

    @Override
    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allSizes, InventoryItemSize.getAllSizes());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allExistingGroups, (List)GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups()));
        this.copyFromModel.prependNullPlaceholder(this.allExistingGroups);
    }

    private void loadOptions(Object toLoad) {
        this.currentOptions.clear();
        if (toLoad != null) {
            this.currentOptions.addAll((Collection)((InventoryOptionGroup)toLoad).getOptions());
        }
        this.currentOptions.add(0, null);
    }

    boolean isCopyFromInventoryOptionGroupSelected() {
        return this.copyFromModel.getSelectedItem() != null;
    }

    InventoryOptionGroup getCopyFromInventoryOptionGroup() {
        return (InventoryOptionGroup)this.copyFromModel.getSelectedItem();
    }
}

