/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.options;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.searchers.inventoryitem.InventoryOptionSearcher;

class InventoryOptionSearch
extends ObjectPropertySearch<InventoryOption> {
    private final ComboSearchField groupSearchField;
    private EventList allOptionGroups = GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups());
    private InventoryOptionSearcher searcher = (InventoryOptionSearcher)super.getPropertySearcher();

    public InventoryOptionSearch(RefreshAction action) {
        super(InventoryOption.class);
        this.groupSearchField = new ComboSearchField("Option Group", this.searcher.getOptionGroupFilter(), true, (Action)action, this.allOptionGroups);
        this.addSearchField((SearchGuiField)this.groupSearchField);
        this.addSearchField((SearchGuiField)new StringSearchField("Name", this.searcher.getOptionNameFilter(), (Action)action));
    }

    @Override
    protected ObjectQuerySearcher<InventoryOption> constructPropertySearcher() {
        return new InventoryOptionSearcher();
    }

    @Override
    public void reaquireSearchOptions() {
        super.reaquireSearchOptions();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allOptionGroups, InventoryOptionGroup.getOptionGroups());
    }

    public ComboSearchField getOptionGroupSearchField() {
        return this.groupSearchField;
    }
}

