/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.options;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.ColorCellEditor;
import officemate.components.tableformat.renderers.ColorCellRenderer;
import officemate.components.tableformat.renderers.NumberFormatRenderer;
import officemate.components.tableformat.renderers.PercentageEditor;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.renderers.SequenceEditor;
import officemate.screens.setup.menu.options.InventoryOptionGroupEditor;
import officemate.screens.setup.menu.options.InventoryOptionSearch;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class InventoryOptionState
extends AbstractEditableTableState {
    private BasicAction newGroupAction;
    private BasicAction editGroupAction;
    private BasicAction deleteGroupAction;
    private BasicAction newOptionAction;
    private ComboSearchField groupSearchField;
    private EventList allOptionGroups = GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups());

    public InventoryOptionState() {
        super("Options", AllPermissions.INVENTORY_OPTIONS, "Add, modify and remove Options and Option Groups.");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this, 1L));
    }

    protected ObjectEditor createObjectEditor() {
        return new InventoryOptionGroupEditor();
    }

    @Override
    public String getTypeName() {
        return "Option Group";
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.newOptionAction = new NewOptionAction();
        this.addAction((Action)this.newOptionAction);
        this.newGroupAction = new NewGroupAction();
        this.addAction((Action)this.newGroupAction);
        this.editGroupAction = new EditGroupAction();
        this.addAction((Action)this.editGroupAction);
        this.deleteGroupAction = new DeleteGroupAction();
        this.addAction((Action)this.deleteGroupAction);
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
        this.groupSearchField = ((InventoryOptionSearch)this.getSearchFactory()).getOptionGroupSearchField();
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        this.setFilterActive(true);
        PersistentObjectTable centralArea = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new PropertyColumnFormat("Option ID", InventoryOption.Properties.ID), new PropertyColumnFormat("Master ID", InventoryOption.Properties.MASTER_ID), new EditablePropertyColumnFormat(InventoryOption.Properties.LABEL), new EditablePropertyColumnFormat(InventoryOption.Properties.PRICE).setCustomEditor(new PriceCellEditor(true)), new EditablePropertyColumnFormat(InventoryOption.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(InventoryOption.Properties.BACKGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()), new EditablePropertyColumnFormat(InventoryOption.Properties.FOREGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()), new EditablePropertyColumnFormat(InventoryOption.Properties.OPTION_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.allOptionGroups))), new EditablePropertyColumnFormat(InventoryOption.Properties.REDUCED_FACTOR).setCustomEditor((TableCellEditor)((Object)new PercentageEditor())).setCustomRenderer(new NumberFormatRenderer(DecimalFormat.getPercentInstance())), new EditablePropertyColumnFormat(InventoryOption.Properties.AVAILABLE_ONLINE)}));
        centralArea.setPropertiesToBulkExclude(new PropertiedObject.Property[]{InventoryOption.Properties.ID, InventoryOption.Properties.MASTER_ID});
        centralArea.getTable().getColumn(2).setHeaderValue("Name");
        ((TableColumnExt)centralArea.getTable().getColumn(1)).setVisible(false);
        ((TableColumnExt)centralArea.getTable().getColumn(0)).setVisible(ExperimentalFeatureHelper.isShowItemIds());
        return centralArea;
    }

    @Override
    protected Class getDisplayingType() {
        return InventoryOptionGroup.class;
    }

    @Override
    public void gotObjectDoubleClicked(Object toEdit) {
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        return new InventoryOptionSearch(new RefreshAction((Refreshable)this));
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.editGroupAction != null) {
            boolean notOnAny = this.groupSearchField.getSelectedObject() != null && !this.groupSearchField.getSelectedObject().toString().equalsIgnoreCase("Any");
            this.editGroupAction.setEnabled(notOnAny);
            this.deleteGroupAction.setEnabled(notOnAny);
            this.newOptionAction.setEnabled(notOnAny);
        }
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allOptionGroups, InventoryOptionGroup.getOptionGroups());
    }

    private void copyInventoryOptionGroup(InventoryOptionGroup newGroup, InventoryOptionGroup toCopyGroup) {
        for (InventoryOption inventoryOption : toCopyGroup.getModifications()) {
            newGroup.addOption(new InventoryOption(inventoryOption));
        }
    }

    @Override
    protected String getTypeFromObject(Object value) {
        if (value instanceof InventoryOption) {
            return "Option";
        }
        return super.getTypeFromObject(value);
    }

    private class NewOptionAction
    extends BasicAction {
        NewOptionAction() {
            super("New", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!InventoryOptionState.this.canCreateOrDelete()) {
                return;
            }
            InventoryOption toAdd = new InventoryOption();
            InventoryOptionGroup group = (InventoryOptionGroup)InventoryOptionState.this.groupSearchField.getSelectedObject();
            toAdd.setOptionGroup(group);
            InventoryOptionState.this.gotObjectEdited(toAdd);
            EventList objectList = InventoryOptionState.this.getObjectList();
            objectList.getReadWriteLock().writeLock().lock();
            try {
                objectList.add((Object)toAdd);
            }
            finally {
                objectList.getReadWriteLock().writeLock().unlock();
            }
            JXTable table = InventoryOptionState.this.getCentralArea().getTable();
            int lastAddedRow = table.getFilters().convertRowIndexToView(table.getRowCount() - 1);
            table.clearSelection();
            table.addRowSelectionInterval(lastAddedRow, lastAddedRow);
            table.scrollRowToVisible(lastAddedRow);
        }
    }

    private class EditGroupAction
    extends BasicAction {
        EditGroupAction() {
            super("Edit Group", (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            InventoryOptionGroup selection = (InventoryOptionGroup)InventoryOptionState.this.groupSearchField.getSelectedObject();
            if (selection != null && !selection.getLabel().equalsIgnoreCase("Any")) {
                String oldName = selection.getLabel();
                InventoryOptionState.this.doDialog(selection);
                if (selection.getLabel().trim().isEmpty() || selection.getLabel().trim().equalsIgnoreCase("any")) {
                    selection.setLabel(oldName);
                }
                selection.save();
                InventoryOptionState.this.getSearchFactory().reaquireSearchOptions();
            }
        }
    }

    private class DeleteGroupAction
    extends BasicAction {
        DeleteGroupAction() {
            super("Remove Group", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object selection = InventoryOptionState.this.groupSearchField.getSelectedObject();
            ArrayList<Object> toDelete = new ArrayList<Object>();
            toDelete.add(selection);
            if (toDelete.size() > 1) {
                // empty if block
            }
            if (InventoryOptionState.this.isDeleteAllowed(toDelete)) {
                ((InventoryOptionGroup)selection).delete();
                InventoryOptionState.this.getSearchFactory().reaquireSearchOptions();
                InventoryOptionState.this.getSearchFactory().resetSearch();
                InventoryOptionState.this.getSearchFactory().refresh();
            }
        }
    }

    private class NewGroupAction
    extends BasicAction {
        NewGroupAction() {
            super("New Group", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!InventoryOptionState.this.canCreateOrDelete()) {
                return;
            }
            InventoryOptionGroup newGroup = new InventoryOptionGroup();
            newGroup.setSize((InventoryItemSize)InventoryItemSize.getAllSizes().get(0));
            newGroup.addTrigger((AbstractTrigger)AbstractTrigger.getDefaultTriggerIfExists());
            if (InventoryOptionState.this.doDialog(newGroup)) {
                String label = newGroup.getLabel();
                if (!label.isEmpty() && !label.equalsIgnoreCase("Any")) {
                    if (InventoryOptionState.this.getObjectEditor() instanceof InventoryOptionGroupEditor && ((InventoryOptionGroupEditor)InventoryOptionState.this.getObjectEditor()).isCopyFromInventoryOptionGroupSelected()) {
                        InventoryOptionState.this.copyInventoryOptionGroup(newGroup, ((InventoryOptionGroupEditor)InventoryOptionState.this.getObjectEditor()).getCopyFromInventoryOptionGroup());
                    }
                    newGroup.save();
                    InventoryOptionState.this.getSearchFactory().reaquireSearchOptions();
                    ((DeferredSaveStrategy)InventoryOptionState.this.getSaveStrategy()).clear();
                    InventoryOptionState.this.groupSearchField.setSelectedObject((Object)newGroup);
                } else {
                    newGroup.delete();
                }
            }
        }
    }
}

