/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pricelevels;

import au.com.ordermate.util.Price;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.database.inventory.PriceLevel;

public class PriceLevelEditorPanel
extends DefaultObjectEditorPanel {
    @Override
    public boolean requestSaveAllowed() {
        boolean allowed = super.requestSaveAllowed();
        if (allowed) {
            PriceLevel priceLevel;
            String label = (String)this.getFieldValue("Name");
            if (label == null || label.isEmpty()) {
                Dialogs.showErrorDialog("Invalid Settings", "<html>You cannot create a Price Level without a name!<br/> Please enter a name for this Price Level.</html>");
                allowed = false;
                return allowed;
            }
            Price newDollar = (Price)this.getFieldValue(PriceLevel.Properties.DOLLAR_TO_APPLY.getUserVisibleLabel());
            double newPercentage = (Double)this.getFieldValue(PriceLevel.Properties.PERCENTAGE_TO_APPLY.getUserVisibleLabel());
            if (!newDollar.isZero() && !(Math.abs(newPercentage) < 0.001)) {
                Dialogs.showErrorDialog("Invalid Settings", "<html>You cannot set a value for both dollar to apply and percentage to apply!<br/> Please ensure that only one is filled with a value, or cancel.</html>");
                allowed = false;
            }
            if (allowed && (priceLevel = (PriceLevel)this.getFieldValue(PriceLevel.Properties.REFERENCE_PRICE_LEVEL.getUserVisibleLabel())) == null) {
                Dialogs.showErrorDialog("Invalid Settings", "<html>You must select the reference price level.<br/> Please ensure that a price level is selected, or cancel.</html>");
                allowed = false;
            }
            if (allowed && newPercentage < -100.0) {
                Dialogs.showErrorDialog("Invalid Settings", "<html>You cannot discount the price over 100%!<br/> Please ensure that a correct percentage is filled, or cancel.</html>");
                allowed = false;
            }
        }
        return allowed;
    }
}

