/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pricelevels;

import au.com.ordermate.gui.ObjectEditor;
import javax.swing.Action;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.menu.pricelevels.PriceLevelLoyaltyEditor;
import officemate.screens.setup.menu.pricelevels.UpdateLoyaltyAction;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.users.AllPermissions;
import ordermate.internationalization.Internationalization;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PriceLevelsLoyaltyState
extends AbstractEditableTableState<PriceLevel> {
    private UpdateLoyaltyAction updateLoyaltyAction = new UpdateLoyaltyAction();

    public PriceLevelsLoyaltyState() {
        super("Price Level Loyalty", AllPermissions.VIEW_PRICE_LEVELS, "View, create and modify loyalty linked to price levels.");
        UpdateLoyaltyAction.preActionPerformed.connect((Object)this, "getSelected");
        UpdateLoyaltyAction.postActionPerformed.connect((Object)this, "refresh");
        this.addSelectionDependentAction((Action)((Object)this.updateLoyaltyAction));
    }

    @Override
    protected EditorDialog createEditorDialog() {
        return new EditorDialog(this.getTypeName(), this.getObjectEditor(), "", "Edit the loyalty the Price Level will apply to items. The way it calculates the Loyalty values is: Unit Price x Loyalty Factor. <p> eg: " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "4.50 x 100 = 450 loyalty");
    }

    @Override
    protected boolean canCreateOrDelete() {
        return false;
    }

    @Override
    protected ObjectEditor<PriceLevel> createObjectEditor() {
        return new PriceLevelLoyaltyEditor();
    }

    @Override
    public String getTypeName() {
        return "Price Level Loyalty";
    }

    @Override
    protected TableStateCentralArea<PriceLevel> createCentralArea() {
        PersistentObjectTable<PriceLevel> table = new PersistentObjectTable<PriceLevel>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(PriceLevel.Properties.LABEL), new PropertyColumnFormat(PriceLevel.Properties.LOYALTY_EARN_FACTOR), new PropertyColumnFormat(PriceLevel.Properties.LOYALTY_REDEEM_FACTOR), new PropertyColumnFormat(PriceLevel.Properties.FORCE_LOYALTY_FACTOR)}));
        return table;
    }

    @Override
    protected Class<PriceLevel> getDisplayingType() {
        return PriceLevel.class;
    }

    @Override
    protected OfficeMateObjectSearch getSearchFactory() {
        OfficeMateObjectSearch searcher = super.getSearchFactory();
        searcher.setSystemStateFilterActive(true);
        return searcher;
    }

    private void getSelected() {
        this.updateLoyaltyAction.setSelectedPriceLevels(this.getCentralArea().getAllSelectedObjects());
    }

    @Override
    public void refresh() {
        super.refresh();
    }
}

