/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pricelevels;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.templates.Templates;
import officemate.screens.setup.menu.pricelevels.PriceLevelsPanel;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.PriceLevelRule;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.AllPermissions;

public class PriceLevelsSetupState
extends BasicOfficeMateState {
    private PriceLevelsPanel panel = new PriceLevelsPanel();
    private Action updatePriceAction;

    public PriceLevelsSetupState() {
        super("Price Levels", AllPermissions.VIEW_PRICE_LEVELS, "View, create and modify price levels.");
        this.panel.objectChosen.connect((Object)this, "editPriceLevel");
        this.panel.objectSelected.connect((Object)this, "updateButtonState");
        this.panel.objectDeselected.connect((Object)this, "updateButtonState");
        this.panel.spinUpPressed.connect((Object)this, "increasePriceLevelSequence");
        this.panel.spinDownPressed.connect((Object)this, "decreasePriceLevelSequence");
        this.setScreenPanel(this.panel);
        this.updatePriceAction = new UpdatePriceAction();
        this.addAction(this.updatePriceAction);
    }

    @Override
    public void onStart() {
        if (SystemCurrentInfo.getInstance().needsUpdate()) {
            PersistenceManager.getInstance().clearLocalCaches();
        }
        this.refresh();
        this.panel.setOverrideAllowed(this.checkOverrideAllowed());
    }

    @Override
    public void refresh() {
        this.panel.setObjects(PriceLevel.getAllPriceLevels());
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public boolean supportsNew() {
        return true;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doNewAction() {
        PriceLevel newPriceLevel = null;
        ObjectEditorPanel editorPanel = Templates.PRICE_LEVEL.getNewEditPanel(null);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorPanel);
        if (result == 0) {
            editorPanel.saveObject();
            newPriceLevel = (PriceLevel)editorPanel.getEditedObject();
            newPriceLevel.setSequence();
            newPriceLevel.save();
            newPriceLevel = (PriceLevel)PersistenceManager.reacquire((PersistentObjectI)newPriceLevel);
            this.panel.addObject(newPriceLevel);
            this.setUpdateRequired();
            SystemCurrentInfo.setMenuUpdate((String)("PriceLevel " + newPriceLevel + " added"));
        }
    }

    @Override
    public void doEditAction() {
        this.editPriceLevel(this.panel.getSelectedObject());
    }

    private void editPriceLevel(PriceLevel priceLevel) {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing Price Level:  " + priceLevel.getLabel());
        ObjectEditorPanel editorPanel = Templates.PRICE_LEVEL.getNewEditPanel(priceLevel);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorPanel);
        if (result == 0) {
            editorPanel.saveObject();
            priceLevel.save();
            this.setUpdateRequired();
            this.refresh();
            this.panel.setSelection(priceLevel);
            SystemCurrentInfo.setMenuUpdate((String)("PriceLevel " + priceLevel + " edited"));
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    public void updateButtonState() {
        boolean itemSelected = this.panel.getSelectedObject() != null;
        boolean canDelete = this.panel.getObjects().size() > 1;
        this.toggleDefaultAction(this.getEditAction(), itemSelected);
        this.toggleDefaultAction(this.getDeleteAction(), itemSelected && canDelete);
        boolean canApply = itemSelected && this.panel.isAutoFillOutValid();
        this.updatePriceAction.setEnabled(canApply);
    }

    @Override
    public void doDeleteAction() {
        this.removePriceLevel(this.panel.getSelectedObject());
    }

    private void removePriceLevel(PriceLevel priceLevel) {
        if (Dialogs.showWarningDialog("Delete price level?", "Are you sure you wish to delete the price level \"" + priceLevel.getLabel() + "\"? \nThis operation cannot be undone.")) {
            this.panel.removeObject(priceLevel);
            Dialogs.showProgressDialog(new RemoveTask(priceLevel));
            this.setUpdateRequired();
            SystemCurrentInfo.setMenuUpdate((String)("PriceLevel " + priceLevel + " removed"));
        }
    }

    public void increasePriceLevelSequence() {
        this.changePriceLevelSequence(this.panel.getSelectedObject(), true);
        this.panel.repaint();
    }

    public void decreasePriceLevelSequence() {
        this.changePriceLevelSequence(this.panel.getSelectedObject(), false);
        this.panel.repaint();
    }

    private void changePriceLevelSequence(PriceLevel priceLevel, boolean increaseSequence) {
        if (priceLevel == null) {
            Dialogs.showInfoDialog("Please select a price level", "No price level selected.  Please select a price level to continue");
            return;
        }
        List priceLevelList = this.panel.getObjects();
        PriceLevel nextLevel = null;
        Iterator it = priceLevelList.iterator();
        int nextSequence = 0;
        if (increaseSequence) {
            nextSequence = Integer.MAX_VALUE;
        }
        while (it.hasNext()) {
            PriceLevel currentLevel = (PriceLevel)it.next();
            if ((!increaseSequence || currentLevel.getSequence() <= priceLevel.getSequence() || currentLevel.getSequence() >= nextSequence) && (increaseSequence || currentLevel.getSequence() >= priceLevel.getSequence() || currentLevel.getSequence() <= nextSequence)) continue;
            nextSequence = currentLevel.getSequence();
            nextLevel = currentLevel;
        }
        if (nextLevel != null) {
            int currentSequence = priceLevel.getSequence();
            nextLevel.deleteSequence();
            priceLevel.setSequenceIfAvailable(nextSequence);
            priceLevel.save();
            nextLevel.setSequenceIfAvailable(currentSequence);
            nextLevel.save();
            Collections.swap(priceLevelList, priceLevelList.indexOf(priceLevel), priceLevelList.indexOf(nextLevel));
            this.panel.setObjects(priceLevelList);
            this.panel.setSelection(priceLevel);
            this.setUpdateRequired();
            SystemCurrentInfo.setMenuUpdate((String)("Changed sequence of PriceLevel " + priceLevel));
        } else if (increaseSequence) {
            Dialogs.showInfoDialog("Cannot increase sequence", "This is the highest price level.  You cannot increase the sequence of this price level any higher.");
        } else if (priceLevel.getSequence() > 1) {
            priceLevel.setSequenceIfAvailable(priceLevel.getSequence() - 1);
            this.setUpdateRequired();
            SystemCurrentInfo.setMenuUpdate((String)("Changed sequence of PriceLevel " + priceLevel));
        } else {
            Dialogs.showInfoDialog("Cannot reduce sequence", "You can not reduce the sequence of a price level below one.");
        }
    }

    public void applyAutoFillOut() {
        String unit;
        double value;
        PriceLevel priceLevel = this.panel.getSelectedObject();
        if (priceLevel == null) {
            return;
        }
        if (Math.abs(priceLevel.getPercentageToApply()) < 0.001) {
            value = priceLevel.getDollarToApply().doubleValue();
            unit = " dollars";
        } else {
            value = priceLevel.getPercentageToApply();
            unit = "%";
        }
        String theMessage = "Will apply " + value + " " + unit + " from the item prices\nof the price level " + priceLevel.getReferencePriceLevel().getLabel() + "\nto the price level " + priceLevel.getLabel() + "\nusing the rule " + priceLevel.getRuleToApply().getLabel() + ":\n\n" + priceLevel.getRuleToApply().getDescription();
        boolean accept = false;
        accept = priceLevel.getRuleToApply().equals((Object)PriceLevelRule.OVERRIDE_RULE) || priceLevel.getRuleToApply().equals((Object)PriceLevelRule.REPLICATE_RULE) ? Dialogs.showWarningDialog("Auto fill out price", theMessage) : Dialogs.showChoiceDialog("Auto fill out price", theMessage);
        if (accept) {
            this.setUpdateRequired();
            Dialogs.showProgressDialog(new AutoFilloutTask(priceLevel));
        }
    }

    private boolean checkOverrideAllowed() {
        String accessLevel = "DISABLED";
        if (this.getUser() != null && AllPermissions.AUTO_FILL_OUT_OVERRIDE_PRICE_LEVEL != null) {
            accessLevel = this.getUser().getPermissionAccessLevel(AllPermissions.AUTO_FILL_OUT_OVERRIDE_PRICE_LEVEL);
        }
        return accessLevel.equals("ENABLED");
    }

    private class UpdatePriceAction
    extends PermissibleAction {
        public UpdatePriceAction() {
            super("Update Prices", AllPermissions.EDIT_PRICES, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/right_arrow.png"), "Apply the fill out price level parameters", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        public void actionPerformed(ActionEvent e) {
            PriceLevelsSetupState.this.applyAutoFillOut();
        }
    }

    private class AutoFilloutTask
    extends AbstractTask {
        PriceLevel priceLevel;

        public AutoFilloutTask(PriceLevel priceLevelToFill) {
            this.priceLevel = priceLevelToFill;
        }

        public String getName() {
            return "Auto fill out price level...";
        }

        public void performTask() throws Exception {
            this.priceLevel.autoFillOut(PriceLevelsSetupState.this.getUser());
        }

        public int getTotalSubTasks() {
            return 1;
        }
    }

    private static class RemoveTask
    extends AbstractTask {
        PriceLevel priceLevel;

        public RemoveTask(PriceLevel priceLevelToDelete) {
            this.priceLevel = priceLevelToDelete;
        }

        public String getName() {
            return "Deleting price level...";
        }

        public void performTask() throws Exception {
            this.priceLevel.delete();
        }

        public int getTotalSubTasks() {
            return 1;
        }
    }
}

