/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pricelevels;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import ordermate.OrderMate;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.PriceLevelHelper;
import ordermate.gui.FieldPanelBuilder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class UpdateLoyaltyAction
extends BasicAction {
    public static final Signal postActionPerformed = Signals.createSignal();
    public static final Signal preActionPerformed = Signals.createSignal();
    private JPanel checkEarnRedeemPanel;
    private JCheckBox earnCheckBox;
    private JCheckBox redeemCheckBox;
    List<PriceLevel> selectedPriceLevels = new ArrayList<PriceLevel>();

    public UpdateLoyaltyAction() {
        super("Update Loyalty", (Icon)IconLoader.get((String)"/officemate/images/selectAll.png"), "Apllies earn and redeem loyalty factors to the selected price levels");
        this.earnCheckBox = new JCheckBox();
        this.earnCheckBox.setName("earnCheckBox");
        this.redeemCheckBox = new JCheckBox();
        this.redeemCheckBox.setName("redeemCheckBox");
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Update Loyalty Earnt", (Component)this.earnCheckBox);
        builder.addRow("Update Loyalty Redeemed", (Component)this.redeemCheckBox);
        this.checkEarnRedeemPanel = builder.getPanel();
        this.refreshDialogCheckboxes();
    }

    private void refreshDialogCheckboxes() {
        this.earnCheckBox.setSelected(true);
        this.redeemCheckBox.setSelected(true);
    }

    public void actionPerformed(ActionEvent e) {
        preActionPerformed.emit();
        this.refreshDialogCheckboxes();
        OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(this.checkEarnRedeemPanel);
        dialog.setTitle("Update Loyalty").setHtmlHeader("Select which loyalty values to update").doPack();
        if (this.selectedPriceLevels != null && !this.selectedPriceLevels.isEmpty() && dialog.doShow() && (this.earnCheckBox.isSelected() || this.redeemCheckBox.isSelected())) {
            Dialogs.showProgressDialog((AbstractTask)new UpdateLoyaltyTask());
        }
    }

    public void setSelectedPriceLevels(List<PriceLevel> selectedPriceLevels) {
        this.selectedPriceLevels = selectedPriceLevels;
    }

    class UpdateLoyaltyTask
    extends AbstractGuiTask {
        UpdateLoyaltyTask() {
        }

        protected void doGuiTask() throws Exception {
            for (PriceLevel level : UpdateLoyaltyAction.this.selectedPriceLevels) {
                if (UpdateLoyaltyAction.this.earnCheckBox.isSelected()) {
                    PriceLevelHelper.applyEarnFactorToUnitPriceLevels((PriceLevel)level);
                    OrderMate.LOG.info("Earn Loyalty Updated for Price Level: " + level);
                }
                this.emitProgress();
                if (UpdateLoyaltyAction.this.redeemCheckBox.isSelected()) {
                    PriceLevelHelper.applyRedeemFactorToUnitPriceLevels((PriceLevel)level);
                    OrderMate.LOG.info("Redeem Loyalty Updated for Price Level: " + level);
                }
                this.emitProgress();
            }
            postActionPerformed.emit();
        }

        public String getName() {
            return "Updating Loyalty Values...";
        }

        protected int getTotalSubTasks() {
            return UpdateLoyaltyAction.this.selectedPriceLevels.size() * 2;
        }
    }
}

