/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.prices;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.MenuGroupTreePanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.table.DefaultGroupedTableModel;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.QueryTable;
import officemate.screens.setup.menu.prices.PriceScreenTableColumnModel;
import officemate.screens.setup.menu.prices.PriceScreenTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PricePanel
extends JPanel {
    public final Signal setPrice = Signals.createSignal(Price.class, (String)"newPrice", Long.class, (String)"unitID", Long.class, (String)"priceLevelID");
    public final Signal deletePrice = Signals.createSignal();
    public final Signal rowSelected = Signals.createSignal();
    private PriceScreenTableModel priceModel;
    private DefaultGroupedTableModel groupedModel;
    private JSplitPane splitter;
    private JTable table;
    private JComboBox profilesCombobox;
    private JCheckBox groupResultsCheckbox;
    private MenuGroupTreePanel tree;
    private DBConnectionInterface control;

    public PricePanel(ObjectManager manager, DBConnectionInterface dbControl) {
        this.setLayout(new BorderLayout());
        this.setName("Item Prices");
        this.control = dbControl;
        JPanel northPanel = new JPanel(new FlowLayout(0));
        this.profilesCombobox = new JComboBox();
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.profilesCombobox);
        this.profilesCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PricePanel.this.setProfile((InventoryProfile)PricePanel.this.profilesCombobox.getSelectedItem());
            }
        });
        JLabel label = new JLabel("Profile");
        label.setLabelFor(this.profilesCombobox);
        northPanel.add(label);
        northPanel.add(this.profilesCombobox);
        this.groupResultsCheckbox = new JCheckBox("Group results");
        this.groupResultsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PricePanel.this.initTable(PricePanel.this.groupResultsCheckbox.isSelected(), true);
            }
        });
        northPanel.add(this.groupResultsCheckbox);
        this.add((Component)northPanel, "North");
        this.splitter = new JSplitPane();
        this.add((Component)this.splitter, "Center");
        this.tree = new MenuGroupTreePanel(manager, null);
        this.tree.setModifiableOnly(true);
        this.tree.objectSelected.connect((Object)this, "setGroup");
        this.splitter.setLeftComponent(this.tree);
        this.initTable(false, false);
    }

    public void refreshAll() {
        this.profilesCombobox.setModel(new DefaultComboBoxModel(InventoryProfile.getAllProfiles()));
        this.priceModel.refreshQuery();
        this.setProfile((InventoryProfile)this.profilesCombobox.getSelectedItem());
    }

    public void initTable(boolean isGrouped, boolean refresh) {
        Object newTable;
        this.priceModel = new PriceScreenTableModel(this.control);
        this.priceModel.newPriceInput.connect((Object)this, "newPriceInput");
        this.groupedModel = new DefaultGroupedTableModel(this.priceModel, "Section", new String[0]);
        if (isGrouped) {
            newTable = new GroupedTable(this.groupedModel);
            this.table = newTable;
            OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)newTable);
            newTable.setColumnModel((TableColumnModel)new PriceScreenTableColumnModel(3));
            this.splitter.setRightComponent(((GroupedTable)((Object)newTable)).getScroller());
        } else {
            newTable = new QueryTable(this.priceModel);
            this.table = newTable;
            OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)newTable);
            ((JTable)newTable).setColumnModel(new PriceScreenTableColumnModel(4));
            this.splitter.setRightComponent(((QueryTable)newTable).getScroller());
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PricePanel.this.rowSelected.emit();
            }
        });
        if (refresh) {
            this.priceModel.refreshQuery();
            InventoryProfile profile = (InventoryProfile)this.profilesCombobox.getSelectedItem();
            Object selected = this.tree.getSelectedObject();
            InventoryGroup group = null;
            if (selected instanceof InventoryGroup) {
                group = (InventoryGroup)selected;
            }
            this.priceModel.setProfileGroup(profile, group);
            this.groupedModel.createTable();
        }
        this.splitter.setDividerLocation(160);
    }

    public void setProfile(InventoryProfile profile) {
        this.tree.setMenuProfile(profile);
        this.priceModel.setProfile(profile);
        this.groupedModel.createTable();
    }

    public void priceRemoved() {
        this.priceModel.priceRemoved(this.getSelectedRow(), this.getSelectedCol());
    }

    public void priceChanged(Price newPrice) {
        this.priceModel.priceChanged(newPrice, this.getSelectedRow(), this.getSelectedCol());
    }

    void setGroup(Object group) {
        if (group != null && group instanceof InventoryGroup) {
            this.priceModel.setGroup((InventoryGroup)group);
        } else {
            this.priceModel.setGroup(null);
        }
        this.groupedModel.createTable();
    }

    void newPriceInput(String newPriceString, Long unitID, Long priceLevelID) {
        if (newPriceString.length() == 0) {
            if (this.isDeleteAllowed()) {
                this.deletePrice.emit();
            } else {
                Dialogs.showErrorDialog("Error", "An item unit must always have a price.");
            }
        } else {
            try {
                Price newPrice = new Price(Double.parseDouble(newPriceString), 0.01);
                this.setPrice.emit((Object)newPrice, (Object)unitID, (Object)priceLevelID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isDeleteAllowed() {
        UnitPriceLevel level = this.getUnitPriceLevel(this.getSelectedRow(), this.getSelectedCol());
        return level != null && level.getUnit().getUnitPriceLevels().size() > 1;
    }

    public int getSelectedRow() {
        int row = this.table.getSelectedRow();
        if (this.groupResultsCheckbox.isSelected()) {
            row = this.groupedModel.getOriginalRow(row);
        }
        return row;
    }

    public int getSelectedCol() {
        int col = this.table.getSelectedColumn();
        if (this.groupResultsCheckbox.isSelected()) {
            col = this.groupedModel.getOriginalColumn(col);
        }
        return col;
    }

    public UnitPriceLevel getUnitPriceLevel(int row, int col) {
        long unitID = this.priceModel.getID(row);
        long priceLevelID = this.priceModel.getPriceLevelID(col);
        UnitPriceLevel unitPriceLevel = this.getUnitPriceLevel(unitID, priceLevelID);
        return unitPriceLevel;
    }

    public InventoryItemUnit getUnit(int row) {
        Long unitID = this.priceModel.getID(row);
        return (InventoryItemUnit)PersistenceManager.getByID((long)unitID, InventoryItemUnit.class);
    }

    public PriceLevel getPriceLevel(int col) {
        long priceLevelID = this.priceModel.getPriceLevelID(col);
        return (PriceLevel)PersistenceManager.getByID((long)priceLevelID, PriceLevel.class);
    }

    private UnitPriceLevel getUnitPriceLevel(long unitID, long priceLevelID) {
        InventoryItemUnit unit = (InventoryItemUnit)PersistenceManager.getByID((long)unitID, InventoryItemUnit.class);
        PriceLevel priceLevel = (PriceLevel)PersistenceManager.getByID((long)priceLevelID, PriceLevel.class);
        UnitPriceLevel unitPriceLevel = null;
        if (unit != null) {
            unitPriceLevel = unit.getUnitPriceLevel(priceLevel);
        }
        return unitPriceLevel;
    }

    public void clearCache() {
        this.priceModel.clearCache();
    }
}

