/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.prices;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.inventory.UnitPriceLevelQueries;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.commons.lang.ArrayUtils;

public class PriceScreenTableModel
extends QueryTableModel {
    public final Signal newPriceInput = Signals.createSignal(String.class, (String)"price", Long.class, (String)"unitID", Long.class, (String)"priceLevelID");
    private static final String[] DISPLAY_DB_COLS = new String[]{"inventory_group.Name", "inventory_item.Name", "inventory_size.Name", "inventory_portion.Name", "inventory_item_unit_tax.FK_system_tax_code"};
    private static final int START_PRICE_COL = 5;
    private final int TAX_COL = 4;
    private final String EMPTY_PRICE_COL_VALUE = "______";
    private static final String[] DB_COL_NAMES = new String[]{"Section", "Name", "Size", "Portion", "Tax"};
    private InventoryProfile profile;
    private long[] priceLevelIDs;
    private final Map<Long, InventoryItemUnit> unitMap = new HashMap<Long, InventoryItemUnit>();
    private final Map<Long, PriceLevel> priceLevelMap = new HashMap<Long, PriceLevel>();

    public PriceScreenTableModel(DBConnectionInterface conn) {
        super(UnitPriceLevelQueries.EditPrices.createQuery((String[])new String[0]), conn, "inventory_item_unit.ID", DISPLAY_DB_COLS, DB_COL_NAMES);
    }

    public void refreshQuery() {
        List priceLevels = PriceLevel.getAllPriceLevels();
        this.priceLevelIDs = new long[priceLevels.size()];
        Object[] priceLevelNames = new String[priceLevels.size()];
        for (int i = 0; i < priceLevels.size(); ++i) {
            PriceLevel level = (PriceLevel)priceLevels.get(i);
            priceLevelNames[i] = level.getLabel();
            this.priceLevelIDs[i] = level.intID();
        }
        SelectQuery query = UnitPriceLevelQueries.EditPrices.createQuery((String[])priceLevelNames);
        this.setQuery(query);
        String[] displayCols = (String[])ArrayUtils.addAll((Object[])DISPLAY_DB_COLS, (Object[])priceLevelNames);
        String[] dbCols = (String[])ArrayUtils.addAll((Object[])DB_COL_NAMES, (Object[])priceLevelNames);
        this.setDisplayColumns(displayCols, dbCols);
    }

    private void modifyQueryForRestrictedSections(SelectQuery query) {
        if (this.profile == null) {
            return;
        }
        HashSet forbiddenGroups = new HashSet(this.profile.getProfileGroups(true));
        forbiddenGroups.removeAll(this.profile.getModifiableProfileGroups(GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup()));
        if (!forbiddenGroups.isEmpty()) {
            StringBuilder SB = new StringBuilder(" NOT inventory_item.fk_inventory_group IN (");
            SB.append(StringUtils.mergeToStringWithSeparator(forbiddenGroups, (String)",", (Stringifier)new Stringifier<InventoryGroup>(){

                public String stringify(InventoryGroup object) {
                    return object.getID().toString();
                }
            }));
            SB.append(")");
            query.addWhere(SB.toString());
        }
    }

    public void setProfileGroup(InventoryProfile newProfile, InventoryGroup group) {
        this.profile = newProfile;
        this.setGroup(group);
    }

    public void setProfile(InventoryProfile newProfile) {
        this.profile = newProfile;
        this.setGroup(null);
    }

    public void setGroup(InventoryGroup group) {
        if (this.profile == null) {
            throw new IllegalStateException("Must set a profile before calling setGroup");
        }
        this.getQuery().clearWhere();
        if (group != null) {
            List allChildren = group.getRecursiveSubGroups();
            String[] conditions = new String[allChildren.size() + 1];
            conditions[0] = "inventory_group.ID = '" + group.getID() + "'";
            for (int i = 0; i < allChildren.size(); ++i) {
                InventoryGroup child = (InventoryGroup)allChildren.get(i);
                conditions[i + 1] = "inventory_group.ID = '" + child.getID() + "'";
            }
            this.getQuery().addWhereOr(conditions);
        }
        this.getQuery().addWhere("inventory_profile.ID = '" + this.profile.getID() + "'");
        this.modifyQueryForRestrictedSections(this.getQuery());
        this.update();
    }

    public long getPriceLevelID(int columnNumber) {
        if (columnNumber > this.priceLevelIDs.length + DISPLAY_DB_COLS.length) {
            return this.priceLevelIDs[this.priceLevelIDs.length - 1];
        }
        if (columnNumber < DISPLAY_DB_COLS.length) {
            return this.priceLevelIDs[0];
        }
        return this.priceLevelIDs[columnNumber - DISPLAY_DB_COLS.length];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex >= 5;
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        Object value = super.getTableValue(row, col, colName, dbColIndex, rs);
        if (col == 4) {
            CachedFKReference ref = new CachedFKReference(TaxCode.class);
            try {
                ref.setObjectID(new Long(value.toString()));
                TaxCode code = (TaxCode)ref.resolve();
                return code.getCode();
            }
            catch (Exception ex) {
                return "---";
            }
        }
        if (col >= 5) {
            if (value == null) {
                return "______";
            }
            if (SystemProperty.getInstance().isExTax()) {
                Long unitID = this.getID(row);
                long priceLevelID = this.priceLevelIDs[col - DISPLAY_DB_COLS.length];
                UnitPriceLevel unitPriceLevel = this.getUnitPriceLevel(unitID, priceLevelID);
                return unitPriceLevel != null ? Double.valueOf(unitPriceLevel.getPriceExTax().doubleValue()) : "______";
            }
            return value;
        }
        return value;
    }

    private UnitPriceLevel getUnitPriceLevel(long unitID, long priceLevelID) {
        InventoryItemUnit unit = this.getItemUnit(unitID);
        PriceLevel priceLevel = this.getPriceLevel(priceLevelID);
        UnitPriceLevel unitPriceLevel = null;
        if (unit != null) {
            unitPriceLevel = unit.getUnitPriceLevel(priceLevel);
        }
        return unitPriceLevel;
    }

    private InventoryItemUnit getItemUnit(long unitID) {
        if (!this.unitMap.containsKey(unitID)) {
            InventoryItemUnit unit = (InventoryItemUnit)PersistenceManager.getByID((long)unitID, InventoryItemUnit.class);
            this.unitMap.put(unitID, unit);
            return unit;
        }
        return this.unitMap.get(unitID);
    }

    private PriceLevel getPriceLevel(long priceLevelID) {
        if (!this.priceLevelMap.containsKey(priceLevelID)) {
            PriceLevel priceLevel = (PriceLevel)PersistenceManager.getByID((long)priceLevelID, PriceLevel.class);
            this.priceLevelMap.put(priceLevelID, priceLevel);
            return priceLevel;
        }
        return this.priceLevelMap.get(priceLevelID);
    }

    public void priceRemoved(int row, int col) {
        int adjustedCol = col;
        if (adjustedCol < DISPLAY_DB_COLS.length) {
            adjustedCol = DISPLAY_DB_COLS.length;
        }
        super.setValueAt("______", row, adjustedCol);
    }

    public void priceChanged(Price newPrice, int row, int col) {
        int adjustedCol = col;
        if (adjustedCol < DISPLAY_DB_COLS.length) {
            adjustedCol = DISPLAY_DB_COLS.length;
        }
        super.setValueAt(newPrice.doubleValue(), row, adjustedCol);
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        Long unitID = this.getID(row);
        this.unitMap.remove(unitID);
        long priceLevelID = this.priceLevelIDs[col - DISPLAY_DB_COLS.length];
        this.newPriceInput.emit(val, (Object)unitID, (Object)new Long(priceLevelID));
    }

    public void clearCache() {
        this.unitMap.clear();
        this.priceLevelMap.clear();
    }
}

