/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.prices;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JOptionPane;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.templates.Templates;
import officemate.screens.ObjectManagerI;
import officemate.screens.setup.menu.prices.PricePanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;

public class PriceState
extends BasicOfficeMateState {
    private PricePanel screen = new PricePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager(), GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection());
    private Action editAction;
    private int menuRevisionCount;

    public PriceState() {
        super("Item Prices", AllPermissions.VIEW_PRICES, "Modify item prices.");
        this.screen.setPrice.connect((Object)this, "setPrice");
        this.screen.deletePrice.connect((Object)this, "deletePrice");
        this.screen.rowSelected.connect((Object)this, "cellSelected");
        this.setScreenPanel(this.screen);
        this.editAction = new BasicAction("Edit", IconLoader.get((String)"/ordermate/images/edit_icon22.png")){

            public void actionPerformed(ActionEvent e) {
                PriceState.this.editPrice();
            }
        };
        this.addAction(this.editAction);
        this.menuRevisionCount = SystemCurrentInfo.getMenuRevisionCount();
    }

    public void cellSelected() {
        PriceLevel priceLevel = this.screen.getPriceLevel(this.screen.getSelectedCol());
        this.editAction.setEnabled(this.screen.getSelectedCol() >= 5 && !priceLevel.isForceLoyaltyFactor());
    }

    @Override
    public void onStart() {
        if (SystemCurrentInfo.getInstance().needsUpdate()) {
            PersistenceManager.getInstance().clearLocalCaches();
        }
    }

    @Override
    public void refresh() {
        this.screen.refreshAll();
        int currentMenuRevisionCount = SystemCurrentInfo.getMenuRevisionCount();
        if (this.menuRevisionCount != currentMenuRevisionCount) {
            this.menuRevisionCount = currentMenuRevisionCount;
            this.screen.clearCache();
        }
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    void setPrice(Price newPrice, Long unitID, Long priceLevelID) {
        PriceLevel priceLevel;
        InventoryItemUnit unit = (InventoryItemUnit)PersistenceManager.getByID((long)unitID, InventoryItemUnit.class);
        UnitPriceLevel unitPriceLevel = unit.getUnitPriceLevel(priceLevel = (PriceLevel)PersistenceManager.getByID((long)priceLevelID, PriceLevel.class));
        if (unitPriceLevel == null) {
            unitPriceLevel = new UnitPriceLevel();
            unit.addUnitPriceLevel(unitPriceLevel);
            priceLevel.addUnitPriceLevel(unitPriceLevel);
        }
        Price priceForScreenChange = newPrice;
        if (SystemProperty.getInstance().isExTax()) {
            newPrice = unitPriceLevel.getPriceIncTaxFor(newPrice);
        }
        SystemCurrentInfo.setMenuUpdate((String)("Changed " + unitPriceLevel + " to " + newPrice));
        unitPriceLevel.setPrice(newPrice);
        unitPriceLevel.save();
        this.setUpdateRequired();
        this.screen.priceChanged(priceForScreenChange);
    }

    public void deletePrice() {
        int selectedCol;
        int selectedRow = this.screen.getSelectedRow();
        UnitPriceLevel unitPriceLevel = this.screen.getUnitPriceLevel(selectedRow, selectedCol = this.screen.getSelectedCol());
        if (unitPriceLevel != null) {
            unitPriceLevel.delete();
            this.screen.priceRemoved();
            this.setUpdateRequired();
            SystemCurrentInfo.setMenuUpdate((String)("Deleted " + unitPriceLevel));
        }
    }

    public void addPrice() {
        int selectedRow = this.screen.getSelectedRow();
        int selectedCol = this.screen.getSelectedCol();
        if (selectedCol < 0 || selectedRow < 0) {
            JOptionPane.showMessageDialog(this.screen, "Please select an item and price column to add a price to", "Select an item", 0);
            return;
        }
        UnitPriceLevel unitPriceLevel = this.screen.getUnitPriceLevel(selectedRow, selectedCol);
        if (unitPriceLevel == null) {
            ObjectEditorPanel editorPanel = Templates.UNIT_PRICE_LEVEL.getNewEditPanel(null);
            int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorPanel);
            if (result == 0) {
                editorPanel.saveObject();
                unitPriceLevel = (UnitPriceLevel)editorPanel.getEditedObject();
                InventoryItemUnit unit = this.screen.getUnit(selectedRow);
                PriceLevel priceLevel = this.screen.getPriceLevel(selectedCol);
                unit.addUnitPriceLevel(unitPriceLevel);
                priceLevel.addUnitPriceLevel(unitPriceLevel);
                unitPriceLevel.save();
                this.setUpdateRequired();
                this.screen.priceChanged(unitPriceLevel.getPrice());
                SystemCurrentInfo.setMenuUpdate((String)("Created " + unitPriceLevel));
            }
        } else {
            JOptionPane.showMessageDialog(this.screen, "Please select an empty price column to add a price to", "Select a price column", 0);
        }
    }

    public void editPrice() {
        int selectedCol;
        int selectedRow = this.screen.getSelectedRow();
        UnitPriceLevel unitPriceLevel = this.screen.getUnitPriceLevel(selectedRow, selectedCol = this.screen.getSelectedCol());
        if (unitPriceLevel != null) {
            GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing Unit Price :  ");
            ObjectEditorPanel editorPanel = Templates.UNIT_PRICE_LEVEL.getNewEditPanel(unitPriceLevel);
            int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorPanel);
            if (result == 0) {
                editorPanel.saveObject();
                Price exTaxPrice = unitPriceLevel.getPrice();
                if (SystemProperty.getInstance().isExTax()) {
                    Price incTaxPrice = unitPriceLevel.getPriceIncTaxFor(unitPriceLevel.getPrice());
                    unitPriceLevel.setPrice(incTaxPrice);
                }
                unitPriceLevel.save();
                this.screen.priceChanged(exTaxPrice);
                this.setUpdateRequired();
                SystemCurrentInfo.setMenuUpdate((String)("Edited " + unitPriceLevel));
            }
            GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
        } else {
            JOptionPane.showMessageDialog(this.screen, "Please select an existing price column to edit", "Select a price column", 0);
        }
    }
}

