/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.sectionimport;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.DefaultTask;
import au.com.ordermate.util.image.IconLoader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.SystemCurrentInfo;

public class ImportTask
extends DefaultTask {
    private List<InventoryGroup> sourceGroupsToImport;
    private List<InventoryGroup> sourceGroupsCopied;
    private InventoryProfile targetP;
    private InventoryGroup targetParentGroup;
    private GuiHandler gui;

    public ImportTask() {
        super("Start Import", 0, (Icon)IconLoader.get((String)"/ordermate/images/right_arrow.png"));
        this.setRunOnce(false);
    }

    public void setup(List<InventoryGroup> sourceGroups, InventoryGroup targetParent, InventoryProfile targetProfile, GuiHandler guiHandler) {
        this.sourceGroupsToImport = sourceGroups;
        this.targetP = targetProfile;
        this.sourceGroupsCopied = new ArrayList<InventoryGroup>();
        this.targetParentGroup = targetParent;
        this.gui = guiHandler;
    }

    private Set<InventoryGroup> getRequiredComboItemSections(InventoryCombo combo) {
        HashSet<InventoryGroup> sections = new HashSet<InventoryGroup>();
        for (InventoryComboGroup grp : combo.getGroups()) {
            for (InventoryItem item : grp.getItems()) {
                sections.add(item.getMenuGroup());
            }
        }
        return sections;
    }

    private ArrayDeque<InventoryGroup> getGroupsToCopy(InventoryGroup groupToCopy) {
        ArrayDeque<InventoryGroup> allGroupsToCopy = new ArrayDeque<InventoryGroup>();
        allGroupsToCopy.add(groupToCopy);
        this.getGroupsToCopy(groupToCopy, allGroupsToCopy);
        return allGroupsToCopy;
    }

    private void getGroupsToCopy(InventoryGroup groupToCopy, ArrayDeque<InventoryGroup> allGroupsToCopy) {
        HashSet<InventoryGroup> sourceGroupsRequired = new HashSet<InventoryGroup>();
        for (InventoryCombo combo : groupToCopy.getCombos()) {
            sourceGroupsRequired.addAll(this.getRequiredComboItemSections(combo));
        }
        List targetGroups = InventoryProfile.getActiveGroupNames((InventoryProfile)this.targetP);
        Iterator it = sourceGroupsRequired.iterator();
        while (it.hasNext()) {
            InventoryGroup group = (InventoryGroup)it.next();
            if (targetGroups.contains(group.getLabel())) {
                it.remove();
                continue;
            }
            if (allGroupsToCopy.contains(group)) {
                it.remove();
                continue;
            }
            if (!this.sourceGroupsToImport.contains(group)) continue;
            it.remove();
            allGroupsToCopy.addAll(this.getGroupsToCopy(group));
        }
        if (!sourceGroupsRequired.isEmpty()) {
            String message = groupToCopy.getLabel() + " contains combos which use items from the following sections:\n";
            for (InventoryGroup group : sourceGroupsRequired) {
                message = message + group.getLabel() + "\n";
            }
            boolean yes = this.gui.displayForcedChoiceDialog("Import Menu Sections needed by combos?", message = message + "Would you like to import these sections?", "Yes", "No");
            if (yes) {
                for (InventoryGroup group : sourceGroupsRequired) {
                    allGroupsToCopy.addAll(this.getGroupsToCopy(group));
                }
            }
        }
    }

    public void performTask() {
        for (InventoryGroup group : this.sourceGroupsToImport) {
            for (InventoryGroup groupToCopy : this.getGroupsToCopy(group)) {
                if (this.sourceGroupsCopied.contains(groupToCopy)) continue;
                InventoryGroup copy = new InventoryGroup(groupToCopy, this.targetP);
                if (this.targetParentGroup != null) {
                    this.targetParentGroup.addSubGroup(copy);
                }
                copy.save();
                this.sourceGroupsCopied.add(groupToCopy);
            }
        }
        if (this.targetParentGroup != null) {
            this.targetParentGroup.save();
        }
        SystemCurrentInfo.setMenuUpdate((String)"Section Import Completed");
    }
}

