/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.sectionimport;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import officemate.components.table.PersistentObjectTable;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.gui.UIFSplitPane;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXTitledSeparator;

public class SectionImportPanel
extends JPanel {
    private PersistentObjectTable sourceTable;
    private PersistentObjectTable targetTable;
    private EventList sourceGroupList;
    private EventList targetGroupList;
    private JComboBox sourceCombo;
    private JComboBox targetCombo;
    private UIFSplitPane splitPane;
    private Action refresh;

    public SectionImportPanel(Action importAction, Action refreshAction) {
        super(new BorderLayout());
        this.refresh = refreshAction;
        this.addComponentListener(new Resizer());
        JXHeader instructionsHeading = new JXHeader("", "Use this screen to import Menu Sections between Profiles.\nSelect the source Profile and the Sections you would like to copy, then select the target Profile to import the sections into. Optionally choose a target Section to become the parent of the copied Sections.", (Icon)IconLoader.get((String)"/officemate/images/xferProfileToProfile.png"));
        JButton importButton = new JButton();
        importButton.setHorizontalTextPosition(0);
        importButton.setVerticalTextPosition(3);
        importButton.setAction(importAction);
        this.sourceGroupList = new BasicEventList();
        this.targetGroupList = new BasicEventList();
        this.sourceCombo = new JComboBox();
        this.sourceCombo.setMaximumSize(this.sourceCombo.getPreferredSize());
        this.sourceCombo.setAction(refreshAction);
        ComponentUtils.setupComboBox((JComboBox)this.sourceCombo);
        this.targetCombo = new JComboBox();
        this.targetCombo.setMaximumSize(this.targetCombo.getPreferredSize());
        this.targetCombo.setAction(refreshAction);
        ComponentUtils.setupComboBox((JComboBox)this.targetCombo);
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 0));
        controls.add(Box.createHorizontalStrut(20));
        controls.add(new JLabel("Source Profile: "));
        controls.add(this.sourceCombo);
        controls.add(Box.createHorizontalGlue());
        controls.add(importButton);
        controls.add(Box.createHorizontalGlue());
        controls.add(new JLabel("Target Profile: "));
        controls.add(this.targetCombo);
        controls.add(Box.createHorizontalStrut(20));
        Box box = new Box(1);
        box.add((Component)instructionsHeading);
        box.add(new JSeparator());
        box.add(controls);
        this.add((Component)box, "North");
        PropertiedObject.Property[] propsToShow = new PropertiedObject.Property[]{InventoryGroup.Properties.LABEL, InventoryGroup.Properties.PARENT_GROUP, InventoryGroup.Properties.BACKGROUND_COLOR};
        this.sourceTable = new PersistentObjectTable(this.sourceGroupList, propsToShow);
        this.sourceTable.getTable().setSelectionMode(1);
        this.sourceTable.add((Component)new JXTitledSeparator("Source Profile Sections"), "North");
        this.sourceTable.setBorder(Borders.DLU2_BORDER);
        this.targetTable = new PersistentObjectTable(this.targetGroupList, propsToShow);
        this.targetTable.add((Component)new JXTitledSeparator("Target Profile Sections"), "North");
        this.targetTable.setBorder(Borders.DLU2_BORDER);
        this.splitPane = new UIFSplitPane();
        this.splitPane.setLeftComponent((Component)this.sourceTable);
        this.splitPane.setRightComponent((Component)this.targetTable);
        this.add((Component)this.splitPane, "Center");
    }

    public void refresh() {
        this.sourceCombo.setAction(null);
        this.targetCombo.setAction(null);
        this.sourceCombo.removeAllItems();
        this.targetCombo.removeAllItems();
        Vector profiles = InventoryProfile.getAllProfiles();
        for (Object profile : profiles) {
            this.sourceCombo.addItem(profile);
            this.targetCombo.addItem(profile);
        }
        if (profiles.size() > 0) {
            this.sourceCombo.setSelectedIndex(0);
            this.targetCombo.setSelectedIndex(profiles.size() - 1);
        }
        this.sourceCombo.setAction(this.refresh);
        this.targetCombo.setAction(this.refresh);
    }

    public EventList getSourceList() {
        return this.sourceGroupList;
    }

    public List<InventoryGroup> getSelectedSourceGroups() {
        ArrayList<InventoryGroup> groups = new ArrayList<InventoryGroup>();
        int first = this.sourceTable.getTable().getSelectionModel().getAnchorSelectionIndex();
        int last = this.sourceTable.getTable().getSelectionModel().getMaxSelectionIndex();
        if (first == -1) {
            return groups;
        }
        for (int i = first; i <= last; ++i) {
            groups.add((InventoryGroup)this.sourceTable.getObjectAt(i));
        }
        return groups;
    }

    public InventoryGroup getSelectedTargetGroup() {
        return (InventoryGroup)this.targetTable.getSelectedObject();
    }

    public InventoryProfile getSourceProfile() {
        return (InventoryProfile)this.sourceCombo.getSelectedItem();
    }

    public EventList getTargetList() {
        return this.targetGroupList;
    }

    public InventoryProfile getTargetProfile() {
        return (InventoryProfile)this.targetCombo.getSelectedItem();
    }

    public void update() {
    }

    private class Resizer
    extends ComponentAdapter {
        private Resizer() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SectionImportPanel.this.splitPane.setDividerLocation(0.5);
            SectionImportPanel.this.revalidate();
        }
    }
}

