/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.triggers;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryGroupSearchPanel;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.adminkit.templates.ItemsOrderedTriggerTemplate;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.screens.setup.menu.triggers.TriggerEmbeddedEditor;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.triggers.ItemsOrderedTypeTrigger;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

class ItemsOrderedTriggerEditor
implements TriggerEmbeddedEditor<ItemsOrderedTypeTrigger>,
ActionListener {
    private DefaultFormBuilder formBuilder;
    private EventList<InventoryItemUnit> itemUnitLinks = GlazedLists.eventList(new ArrayList());
    private EventList<InventoryGroup> groupLinks = GlazedLists.eventList(new ArrayList());
    private JComboBox profileCombo;
    private JLabel includeSavedItemsLabel = new JLabel("Include Saved Items and New Items");
    private JCheckBox includeSavedItemsCheck;
    private JLabel onlySavedNotPrintedLabel = new JLabel("Reprinted Receipts Don't Trigger");
    private JCheckBox onlySavedNotPrintedCheck;

    ItemsOrderedTriggerEditor() {
    }

    @Override
    public void construct(DefaultFormBuilder builder) {
        this.formBuilder = builder;
        this.buildProfileCombo();
        this.formBuilder.nextRow();
        this.buildItemsTablePanel();
        this.formBuilder.nextRow();
        this.buildGroupsTablePanel();
        this.formBuilder.nextRow();
        this.includeSavedItemsCheck = new JCheckBox();
        this.includeSavedItemsCheck.setToolTipText("Checking the trigger will consider both saved and new sale items on the account.");
        this.includeSavedItemsCheck.addActionListener(this);
        this.formBuilder.append((Component)this.includeSavedItemsLabel, (Component)this.includeSavedItemsCheck);
        this.formBuilder.nextRow();
        this.onlySavedNotPrintedCheck = new JCheckBox();
        this.onlySavedNotPrintedCheck.setToolTipText("Checking the trigger will disregard items that have already been printed on a receipt previously");
        this.onlySavedNotPrintedCheck.addActionListener(this);
        this.formBuilder.append((Component)this.onlySavedNotPrintedLabel, (Component)this.onlySavedNotPrintedCheck);
        this.formBuilder.nextRow();
    }

    private void buildProfileCombo() {
        this.profileCombo = new JComboBox(InventoryProfile.getAllProfiles());
        this.formBuilder.append("Profile", (Component)this.profileCombo);
    }

    private void buildGroupsTablePanel() {
        TablePanel<InventoryGroup> groupTablePanel = new TablePanel<InventoryGroup>(this.groupLinks, new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Section", InventoryGroup.Properties.LABEL)}), new AddMenuGroupAction());
        this.formBuilder.append("Sections", groupTablePanel);
    }

    private void buildItemsTablePanel() {
        TablePanel<InventoryItemUnit> itemTablePanel = new TablePanel<InventoryItemUnit>(this.itemUnitLinks, new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new AbstractColumnFormat("Menu Item", String.class){

            public Object resolveColumnValue(Object baseObject) {
                return ((InventoryItemUnit)baseObject).toString();
            }
        }, new PropertyAccessorColumnFormat("Section", new PropertiedObject.Property[]{InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.MENU_GROUP}, null)}), new AddMenuItemAction());
        this.formBuilder.append("Items", itemTablePanel);
    }

    private void addMenuSection() {
        SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryGroupSearchPanel((InventoryProfile)this.profileCombo.getSelectedItem()), "Find Menu Section...");
        searchDialog.setVisible(true);
        if (!searchDialog.wasCancelled()) {
            InventoryGroup groupSelected = (InventoryGroup)searchDialog.getFoundObject();
            if (!this.groupLinks.contains((Object)groupSelected)) {
                GlazedListUtils.add(this.groupLinks, (Object)groupSelected);
            } else {
                Dialogs.showInfoDialog("Section Not Added", "Section already exists within the list.");
            }
        }
    }

    private void addMenuUnit() {
        SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), new InventoryItemSearchPanel((InventoryProfile)this.profileCombo.getSelectedItem(), true), "Find Menu Item...");
        searchDialog.setVisible(true);
        if (!searchDialog.wasCancelled()) {
            InventoryItemUnit itemSelected = (InventoryItemUnit)searchDialog.getFoundObject();
            if (!this.itemUnitLinks.contains((Object)itemSelected)) {
                GlazedListUtils.add(this.itemUnitLinks, (Object)itemSelected);
            } else {
                Dialogs.showInfoDialog("Menu Item Not Added", "Menu Item already exists within the list.");
            }
        }
    }

    @Override
    public void saveObject(ItemsOrderedTypeTrigger trigger) {
        trigger.setItemUnits(this.itemUnitLinks);
        trigger.setGroups(this.groupLinks);
    }

    public void saveProperties(ItemsOrderedTriggerTemplate template, ItemsOrderedTypeTrigger trigger) {
        template.setObjectProperty(trigger, ItemsOrderedTypeTrigger.Properties.INCLUDE_SAVED_ITEMS.getUserVisibleLabel(), this.includeSavedItemsCheck.isSelected());
        template.setObjectProperty(trigger, ItemsOrderedTypeTrigger.Properties.ONLY_SAVED_NOT_PRINTED.getUserVisibleLabel(), this.onlySavedNotPrintedCheck.isSelected());
    }

    @Override
    public void setEditedObject(ItemsOrderedTypeTrigger trigger) {
        GlazedListUtils.clearAll(this.itemUnitLinks);
        GlazedListUtils.clearAll(this.groupLinks);
        OfficeMateAdminGuiUtils.getInstance().refreshListWithCollection(this.itemUnitLinks, trigger.getItemUnits());
        OfficeMateAdminGuiUtils.getInstance().refreshListWithCollection(this.groupLinks, trigger.getGroups());
        this.includeSavedItemsCheck.setSelected(trigger.isIncludeSavedItems());
        this.onlySavedNotPrintedCheck.setSelected(trigger.isOnlySavedNotPrinted());
        this.setOnlySavedNotPrintedVisibility(this.includeSavedItemsCheck.isSelected());
    }

    private void setOnlySavedNotPrintedVisibility(boolean isIncludeSavedItemsSelected) {
        if (isIncludeSavedItemsSelected) {
            this.onlySavedNotPrintedCheck.setVisible(true);
            this.onlySavedNotPrintedLabel.setVisible(true);
        } else {
            this.onlySavedNotPrintedCheck.setVisible(false);
            this.onlySavedNotPrintedLabel.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.includeSavedItemsCheck) {
            this.setOnlySavedNotPrintedVisibility(this.includeSavedItemsCheck.isSelected());
        }
    }

    private class TablePanel<T extends PersistentObject>
    extends JPanel
    implements ListEventListener<T> {
        public JButton removeAllButton;

        public TablePanel(EventList<T> eventList, ColumnTableFormat tableCols, BasicAction addAction) {
            super(new BorderLayout());
            PersistentObjectTable<T> table = new PersistentObjectTable<T>(eventList, tableCols);
            this.setPreferredSize(new Dimension(300, 120));
            JButton addButton = new JButton((Action)addAction);
            JButton removeButton = new JButton((Action)((Object)new RemoveItemAction<T>(eventList, table)));
            this.removeAllButton = new JButton((Action)((Object)new RemoveAllItemAction<T>(eventList)));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(addButton);
            buttonPanel.add(removeButton);
            buttonPanel.add(this.removeAllButton);
            this.add((Component)buttonPanel, "East");
            this.add(table, "Center");
            this.removeAllButton.setEnabled(!eventList.isEmpty());
            table.addSelectionDependentAction(removeButton.getAction());
            eventList.addListEventListener((ListEventListener)this);
        }

        public void listChanged(ListEvent arg0) {
            this.removeAllButton.setEnabled(!arg0.getSourceList().isEmpty());
        }
    }

    private class AddMenuGroupAction
    extends BasicAction {
        public AddMenuGroupAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add a Section...");
        }

        public void actionPerformed(ActionEvent e) {
            ItemsOrderedTriggerEditor.this.addMenuSection();
        }
    }

    private class AddMenuItemAction
    extends BasicAction {
        public AddMenuItemAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add an item...");
        }

        public void actionPerformed(ActionEvent e) {
            ItemsOrderedTriggerEditor.this.addMenuUnit();
        }
    }

    private class RemoveAllItemAction<T extends PersistentObject>
    extends BasicAction {
        private EventList<T> eventList;

        public RemoveAllItemAction(EventList<T> objList) {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"), "Remove All");
            this.eventList = objList;
        }

        public void actionPerformed(ActionEvent e) {
            GlazedListUtils.clearAll(this.eventList);
        }
    }

    private class RemoveItemAction<T extends PersistentObject>
    extends BasicAction {
        private EventList<T> eventList;
        private PersistentObjectTable<T> table;

        public RemoveItemAction(EventList<T> srcList, PersistentObjectTable<T> srcTable) {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
            this.eventList = srcList;
            this.table = srcTable;
        }

        public void actionPerformed(ActionEvent e) {
            GlazedListUtils.removeInList(this.eventList, this.table.getAllSelectedObjects());
        }
    }
}

