/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.triggers;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.queries.inventory.TriggerQueries;
import ordermate.maps.inventory.triggers.AbstractTriggerMap;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class TriggersPanel
extends JPanel {
    public final Signal objectSelected = Signals.createSignal();
    public final Signal objectDeselected = Signals.createSignal();
    public final Signal objectChosen = Signals.createSignal(AbstractTrigger.class, (String)"abstractTrigger");
    private QueryTable table;

    public TriggersPanel() {
        super(new BorderLayout());
        this.setupTable();
        JPanel sidePanel = new JPanel(new BorderLayout());
        this.add((Component)sidePanel, "East");
    }

    public int getCountTriggers() {
        return this.table.getRowCount();
    }

    private void setupTable() {
        QueryTableModel tableModel = new QueryTableModel(TriggerQueries.getAllTriggersExcluding(), GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), AbstractTriggerMap.instance().getColumn(AbstractTrigger.Properties.ID), new String[]{AbstractTriggerMap.instance().getColumn(AbstractTrigger.Properties.LABEL), "Type"}, new String[]{"Name", "Type"});
        this.table = new QueryTable(tableModel);
        this.table.objectChosen.connect((Object)this, "gotObjectChosen");
        this.table.objectSelected.connect((Object)this, "gotObjectSelected");
        this.table.objectDeselected.connect((Object)this, "gotObjectDeselected");
        this.add((Component)this.table.getScroller(), "Center");
    }

    public void refresh() {
        this.table.updateModel();
    }

    public boolean hasSelectedObject() {
        return this.table.getSelectedObjectID() != -1L;
    }

    public AbstractTrigger getSelectedObject() {
        long id = this.table.getSelectedObjectID();
        if (id == -1L) {
            return null;
        }
        AbstractTrigger trigger = (AbstractTrigger)PersistenceManager.getByID((long)id, AbstractTrigger.class);
        return trigger;
    }

    public void gotObjectSelected(Long obj) {
        this.objectSelected.emit();
    }

    public void gotObjectDeselected(Long obj) {
        this.objectDeselected.emit();
    }

    public void gotObjectChosen(Long obj) {
        AbstractTrigger trigger = this.getSelectedObject();
        if (obj != null && !obj.equals(trigger.getID())) {
            trigger = (AbstractTrigger)PersistenceManager.getByID((long)obj, AbstractTrigger.class);
        }
        this.objectChosen.emit((Object)trigger);
    }
}

