/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.triggers;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import javax.swing.Action;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.templates.Templates;
import officemate.screens.ObjectManagerI;
import officemate.screens.setup.menu.triggers.TriggersPanel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.AllPermissions;

public class TriggersState
extends BasicOfficeMateState {
    private TriggersPanel panel = new TriggersPanel();

    public TriggersState() {
        super("Triggers", AllPermissions.VIEW_TRIGGERS, "View, create and modify triggers.");
        this.panel.objectChosen.connect((Object)this, "doEditAction");
        this.panel.objectSelected.connect((Object)this, "updateButtonStates");
        this.panel.objectDeselected.connect((Object)this, "updateButtonStates");
        this.setScreenPanel(this.panel);
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.EDIT_TRIGGERS));
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_TRIGGERS));
        this.addAction((Action)ActionFactory.createPermissibleDeleteAction(this, AllPermissions.EDIT_TRIGGERS));
    }

    @Override
    public void onStart() {
        if (SystemCurrentInfo.getInstance().needsUpdate()) {
            PersistenceManager.getInstance().clearLocalCaches();
        }
        this.refresh();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void refresh() {
        this.panel.refresh();
    }

    @Override
    public void doNewAction() {
        ObjectEditorPanel editor = Templates.TIME_TRIGGER.getNewEditPanel(null);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editor);
        if (result == 0) {
            editor.saveObject();
            AbstractTrigger newTrigger = (AbstractTrigger)editor.getEditedObject();
            newTrigger.save();
            this.panel.refresh();
            this.setUpdateRequired();
        }
    }

    @Override
    public void doEditAction() {
        if (this.panel.hasSelectedObject()) {
            AbstractTrigger trigger = this.panel.getSelectedObject();
            if (!trigger.isEditable()) {
                return;
            }
            ObjectEditorPanel editor = ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().getTemplate(trigger.getClass()).getNewEditPanel(trigger);
            int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editor);
            if (result == 0) {
                editor.saveObject();
                trigger = (AbstractTrigger)editor.getEditedObject();
                trigger.save();
                this.panel.refresh();
                this.setUpdateRequired();
            }
        }
    }

    @Override
    public void doDeleteAction() {
        if (this.panel.hasSelectedObject()) {
            AbstractTrigger trigger = this.panel.getSelectedObject();
            if (!this.mayDeleteTrigger(trigger)) {
                return;
            }
            List affectedLevels = trigger.getPriceLevels();
            if (Dialogs.showWarningDialog("Delete trigger?", this.buildDeleteString(trigger, affectedLevels))) {
                for (PriceLevel level : affectedLevels) {
                    level.removeTrigger(trigger);
                    level.save();
                }
                trigger.delete();
                this.panel.refresh();
                this.setUpdateRequired();
            }
        } else {
            Dialogs.showMessageDialog("Select a trigger.", "Please select a trigger.  \n\nYou need to select a trigger for deletion first");
        }
    }

    public void updateButtonStates() {
        boolean isObjectSelected = this.panel.getSelectedObject() != null;
        this.toggleDefaultAction(this.getEditAction(), isObjectSelected);
        this.toggleDefaultAction(this.getDeleteAction(), isObjectSelected);
    }

    private String buildDeleteString(AbstractTrigger trigger, List affectedLevels) {
        StringBuffer message = new StringBuffer();
        message.append("Are you sure you wish to delete the trigger \"" + trigger.getLabel() + "\"? \n\n");
        if (affectedLevels.size() > 0) {
            message.append("Price Levels activated by this trigger:\n");
            for (PriceLevel level : affectedLevels) {
                message.append("- " + level.getLabel() + "\n");
            }
            message.append("\n");
        }
        message.append("This operation cannot be undone.");
        return message.toString();
    }

    private boolean mayDeleteTrigger(AbstractTrigger trigger) {
        if (trigger == null) {
            return false;
        }
        if (AbstractTrigger.Types.DEFAULT_TYPE.equals((Object)trigger.getDiscriminatorType())) {
            Dialogs.showWarningDialog("Cannot Delete Trigger", "<html>" + trigger.getLabel() + " may not be deleted.</html>");
            return false;
        }
        PriceAdjustmentManager priceAdjust = PriceAdjustmentManager.getInstance();
        List triggerLink = priceAdjust.getDeliveryFee().getTriggers();
        if (triggerLink.contains(trigger)) {
            Dialogs.showWarningDialog("Cannot Delete Trigger", "<html>" + trigger.getLabel() + " may not be deleted. It is linked to the Delivery Surcharge Fee</html>");
            return false;
        }
        return true;
    }
}

