/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.areas;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.actions.OfficematePermissableAction;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemParLevel;
import ordermate.database.stock.StockParLevel;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class SetupStockAreasState
extends AbstractEditableTableState<StockArea>
implements StrategySaveCancelListener {
    public SetupStockAreasState() {
        super("Stock Areas", AllPermissions.ACCESS_STOCK_AREAS_SCREEN, "View, create and modify stock areas");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
        this.getSaveStrategy().addSaveCancelListener(this);
    }

    @Override
    protected TableStateCentralArea<StockArea> createCentralArea() {
        this.setFilterActive(true);
        ColumnFormat[] colFormat = SystemProperty.getInstance().isLiquorfileEnabled() ? new ColumnFormat[]{new EditablePropertyColumnFormat("Name", StockArea.Properties.LABEL), new EditablePropertyColumnFormat("Scandata Exported?", StockArea.Properties.SCANDATA_EXPORTED), new EditablePropertyColumnFormat("Consolidated?", StockArea.Properties.SCANDATA_CONSOLIDATED)} : new ColumnFormat[]{new EditablePropertyColumnFormat("Name", StockArea.Properties.LABEL)};
        PersistentObjectTable<StockArea> centralArea = new PersistentObjectTable<StockArea>(this.getObjectList(), new ColumnTableFormat(colFormat));
        return centralArea;
    }

    @Override
    protected Class<StockArea> getDisplayingType() {
        return StockArea.class;
    }

    @Override
    protected ObjectEditor<StockArea> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Stock Area";
    }

    @Override
    public Action getNewAction() {
        OfficematePermissableAction newAction = new OfficematePermissableAction("New", AllPermissions.ADD_STOCK_AREAS, IconLoader.get((String)"/officemate/images/new.png"), "Create a new Stock Area"){

            public void actionPerformed(ActionEvent e) {
                SetupStockAreasState.this.doNewAction();
            }
        };
        return newAction;
    }

    @Override
    public Action getDeleteAction() {
        OfficematePermissableAction deleteAction = new OfficematePermissableAction("Delete", AllPermissions.DELETE_STOCK_AREAS, IconLoader.get((String)"/officemate/images/delete_new.png"), "Delete a Stock Area"){

            public void actionPerformed(ActionEvent e) {
                SetupStockAreasState.this.doDeleteAction();
            }
        };
        return deleteAction;
    }

    @Override
    public void doDeleteAction() {
        final StockArea area = (StockArea)this.getCentralArea().getSelectedObject();
        if (area == null) {
            return;
        }
        final AtomicBoolean canDelete = new AtomicBoolean(true);
        Dialogs.showProgressDialog(new AbstractTask(){

            protected int getTotalSubTasks() {
                return 0;
            }

            protected void performTask() throws Exception {
                List terminals = Terminal.getAllTerminals();
                List groups = InventoryGroupQueries.getAllGroups();
                for (Terminal term : terminals) {
                    if (!area.equals((Object)term.getStockArea())) continue;
                    canDelete.set(false);
                    Dialogs.showErrorDialog("Cannot delete area", "The terminal : " + term + " is configured to decrement from this stock area : " + area);
                    return;
                }
                for (InventoryGroup group : groups) {
                    for (DecrementStockArea decArea : group.getDecrementStockAreas()) {
                        if (!area.equals((Object)decArea.getStockArea())) continue;
                        canDelete.set(false);
                        Dialogs.showErrorDialog("Cannot delete area", "The menu group :" + decArea.getInventoryGroup() + "\n is configured to decrement from this area on terminal : " + decArea.getTerminal());
                        return;
                    }
                }
                for (Terminal term : terminals) {
                    for (InventoryGroup group : groups) {
                        for (StockArea decArea : group.getDecrementStockAreasForAllItems(term)) {
                            if (!area.equals((Object)decArea)) continue;
                            canDelete.set(false);
                            Dialogs.showErrorDialog("Cannot delete area", "The menu group :" + group + "\n is configured with items to decrement from this area on terminal : " + term);
                            return;
                        }
                    }
                }
            }

            public String getName() {
                return "Validating deletion of " + area.getLabel() + "...";
            }
        });
        if (canDelete.get()) {
            super.doDeleteAction();
        }
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
        try {
            for (StockArea stockArea : StockArea.getStockAreas()) {
                this.ensureStockParLinksExistForLevel(stockArea);
            }
            this.ensureAllDeleteAreasRemovedFromParLevels();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error ensuring StockItemParLevel are maintained.", (Throwable)ex);
        }
    }

    private void ensureAllDeleteAreasRemovedFromParLevels() {
        ObjectQuery deletedAreasQry = Query.select(StockArea.class).not().active(StockArea.class);
        List deletedAreas = PersistenceManager.getObjectList(StockArea.class, (String)deletedAreasQry.toString());
        for (StockArea stockArea : deletedAreas) {
            ObjectQuery parLevelQry = Query.select(StockItemParLevel.class).equals(StockItemParLevel.Properties.STOCK_AREA, (Object)stockArea);
            List allStockItemsParLevels = PersistenceManager.getObjectList(StockItemParLevel.class, (String)parLevelQry.toString());
            for (StockItemParLevel parLevel : allStockItemsParLevels) {
                parLevel.deleteChild();
            }
        }
    }

    private void ensureStockParLinksExistForLevel(StockArea stockArea) {
        ObjectQuery parLevelQry = Query.select(StockItemParLevel.class).equals(StockItemParLevel.Properties.STOCK_AREA, (Object)stockArea).limit(1);
        List parLevelsFound = PersistenceManager.getObjectList(StockItemParLevel.class, (String)parLevelQry.toString());
        if (parLevelsFound.isEmpty()) {
            ObjectQuery allStockQry = Query.select(StockItem.class).active(StockItem.class);
            List allStockItems = PersistenceManager.getObjectList(StockItem.class, (String)allStockQry.toString());
            List allParLevels = StockParLevel.getAllParLevels();
            for (StockItem stockItem : allStockItems) {
                for (StockParLevel parLevel : allParLevels) {
                    StockItemParLevel itemParLevel = new StockItemParLevel();
                    itemParLevel.setStockItem(stockItem);
                    itemParLevel.setStockParLevel(parLevel);
                    itemParLevel.setStockArea(stockArea);
                    itemParLevel.saveChild();
                }
            }
        }
    }
}

