/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.ingredients;

import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.AbstractTableState;
import officemate.screens.setup.stock.ingredients.IngredientEditor;
import officemate.screens.setup.stock.ingredients.StockLinkableCostPanel;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import org.jdesktop.swingx.JXCollapsiblePane;

public class IngredientsPanel<T extends PersistentObjectI & StockLinkable<L>, L extends StockLink> {
    private JPanel panel;
    private StockLinkableCostPanel<T> stockCostPanel;
    private final IngredientEditor<T, L> ingredientEditor;

    public IngredientsPanel(AbstractEditableTableState<T> state, Class<L> stockLinkClass, StockLinkableCostPanel<T> stockCostPanel) {
        this(state, stockCostPanel, IngredientEditor.create(state.getSaveStrategy(), state.getCentralArea(), stockLinkClass), 650);
    }

    public IngredientsPanel(final AbstractTableState<T> state, final StockLinkableCostPanel<T> stockCostPanel, IngredientEditor<T, L> ingredEditor, int width) {
        this.ingredientEditor = ingredEditor;
        this.stockCostPanel = stockCostPanel;
        if (state != null) {
            state.addSelectionChangeListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PersistentObjectI selectedObject = (PersistentObjectI)state.getCentralArea().getSelectedObject();
                    if (selectedObject != null) {
                        IngredientsPanel.this.setObject(selectedObject);
                    } else {
                        stockCostPanel.updateForStockLinkableObject(null);
                        IngredientsPanel.this.ingredientEditor.setObject(null);
                    }
                }
            });
        }
        this.ingredientEditor.objectEdited.connect((Object)this, "gotObjectEdited");
        this.panel = new JPanel(new BorderLayout());
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)stockCostPanel.getGuiComponent(), "North");
        westPanel.add((Component)new JPanel(), "Center");
        this.panel.setPreferredSize(new Dimension(width, 200));
        this.panel.add((Component)westPanel, "West");
        this.panel.add((Component)this.ingredientEditor.getComponent(), "Center");
    }

    public JComponent getGuiComponent() {
        return this.panel;
    }

    public IngredientEditor getIngredientEditor() {
        return this.ingredientEditor;
    }

    public void gotObjectEdited() {
        this.ingredientEditor.saveObject();
        this.updateStockCostPanel((PersistentObjectI)this.ingredientEditor.getObject());
    }

    public void setObject(T obj) {
        this.ingredientEditor.setObject((StockLinkable)obj);
        this.updateStockCostPanel(obj);
    }

    private void updateStockCostPanel(T obj) {
        if (obj instanceof ItemSummary) {
            obj = ((ItemSummary)obj).getInventoryItemUnitObject();
        }
        this.stockCostPanel.updateForStockLinkableObject((StockLinkable)obj);
    }

    public JXCollapsiblePane getCollapsiblePanel(JCheckBox showIngredients) {
        JXCollapsiblePane collapsiblePanel = new JXCollapsiblePane((LayoutManager)new BorderLayout());
        showIngredients.setAction(collapsiblePanel.getActionMap().get("toggle"));
        showIngredients.setSelected(true);
        showIngredients.setText("Show Ingredients");
        collapsiblePanel.add((Component)this.getGuiComponent(), (Object)"South");
        return collapsiblePanel;
    }
}

