/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.ingredients;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import ordermate.database.stock.StockLinkable;
import ordermate.internationalization.Internationalization;

public interface StockLinkableCostPanel<T extends StockLinkable & PersistentObjectI> {
    public static final String DOLLAR_SIGN = Internationalization.getLiteralFor((String)"DOLLAR_SIGN");
    public static final String GST = Internationalization.getLiteralFor((String)"GST");
    public static final String COST_EX_LABEL = MessageFormat.format("{0} Ex {1}", GST, DOLLAR_SIGN);
    public static final String COST_INC_LABEL = "Inc " + DOLLAR_SIGN;
    public static final String GP_DOLLAR_LABEL = "G.P. " + DOLLAR_SIGN;
    public static final String GP_PERC_LABEL = "G.P. %";
    public static final String RETAIL_LABEL = DOLLAR_SIGN;

    public void updateForStockLinkableObject(T var1);

    public JComponent getGuiComponent();

    public static class Helper {
        public static double getDoubleFromSpinner(JSpinner spinner) {
            return ((Number)spinner.getValue()).doubleValue();
        }

        public static Double getDoubleForSpinner(Price price) {
            if (price == null) {
                return new Double(0.0);
            }
            return new Double(MathsUtils.roundDoubleToDecPlaces((double)price.doubleValue(), (int)2));
        }
    }
}

