/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.ingredients;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import officemate.screens.setup.stock.ingredients.StockLinkableCostPanel;
import officemate.screens.setup.stock.items.UsageCostPanel;
import ordermate.database.finance.CostedItem;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockLinkable;

public class UsageCostProfitPanel<T extends CostedItem & StockLinkable>
extends JPanel
implements StockLinkableCostPanel<T> {
    private final ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
    private JPanel retailPanel;
    private JPanel profitPanel;
    private JSpinner retailSpinner;
    private JSpinner gpDollarSpinner;
    private JSpinner profitMarginSpinner;
    private JLabel retailLabel;
    private JLabel profitLabel;
    private JLabel profitPercentLabel;
    private StockLinkableCostPanel<T> costPanel = new UsageCostPanel();

    public UsageCostProfitPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.retailSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.retailSpinner.setName("retailSpinner");
        this.retailSpinner.setEnabled(false);
        this.gpDollarSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.gpDollarSpinner.setName("profitSpinner");
        this.gpDollarSpinner.setEnabled(false);
        this.profitMarginSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.profitMarginSpinner.setName("profitMarginSpinner");
        this.profitMarginSpinner.setEnabled(false);
        this.retailPanel = new JPanel(new BorderLayout());
        this.retailPanel.setName("Retail");
        this.retailPanel.setBorder(BorderFactory.createTitledBorder("Retail"));
        JPanel retailSpinnerPanel = new JPanel(new BorderLayout());
        this.retailLabel = new JLabel(RETAIL_LABEL);
        this.retailLabel.setLabelFor(this.retailSpinner);
        retailSpinnerPanel.add((Component)this.retailLabel, "West");
        retailSpinnerPanel.add((Component)this.retailSpinner, "Center");
        this.retailPanel.add((Component)retailSpinnerPanel, "West");
        this.profitPanel = new JPanel(new GridLayout(1, 2));
        this.profitPanel.setName("profitPanel");
        this.profitPanel.setBorder(BorderFactory.createTitledBorder("Gross Profit"));
        JPanel profitSpinnerPanel = new JPanel();
        profitSpinnerPanel.setLayout(new BoxLayout(profitSpinnerPanel, 0));
        this.profitLabel = new JLabel(GP_DOLLAR_LABEL);
        this.profitLabel.setLabelFor(this.gpDollarSpinner);
        JPanel profitDollarPanel = new JPanel(new BorderLayout());
        profitDollarPanel.add((Component)this.profitLabel, "West");
        profitDollarPanel.add((Component)this.gpDollarSpinner, "Center");
        profitSpinnerPanel.add(profitDollarPanel);
        JPanel profitPercentSpinnerPanel = new JPanel();
        profitPercentSpinnerPanel.setLayout(new BoxLayout(profitPercentSpinnerPanel, 0));
        this.profitPercentLabel = new JLabel("G.P. %");
        this.profitPercentLabel.setLabelFor(this.profitMarginSpinner);
        JPanel profitMarginPanel = new JPanel(new BorderLayout());
        profitMarginPanel.add((Component)this.profitPercentLabel, "West");
        profitMarginPanel.add((Component)this.profitMarginSpinner, "Center");
        profitPercentSpinnerPanel.add(profitMarginPanel);
        this.profitPanel.add(profitSpinnerPanel);
        this.profitPanel.add(profitPercentSpinnerPanel);
        this.add((Component)this.retailPanel, "Center");
        this.add((Component)this.costPanel.getGuiComponent(), "Center");
        this.add((Component)this.profitPanel, "Center");
    }

    private void updateTextColor() {
        double profitInc = StockLinkableCostPanel.Helper.getDoubleFromSpinner(this.gpDollarSpinner);
        boolean unprofitable = profitInc < 0.0;
        Color labelColor = unprofitable ? Color.red : Color.black;
        this.profitLabel.setForeground(labelColor);
        this.profitPercentLabel.setForeground(labelColor);
        if (unprofitable) {
            this.frame.setStatusBarText("UNPROFITABLE ITEM", Color.red);
        } else {
            this.frame.resetStatusBarText();
        }
    }

    @Override
    public void updateForStockLinkableObject(T stockLinkable) {
        this.costPanel.updateForStockLinkableObject((StockLinkable)stockLinkable);
        if (stockLinkable != null) {
            this.retailSpinner.setValue(StockLinkableCostPanel.Helper.getDoubleForSpinner(stockLinkable.getPrice()));
            Price taxAmount = FinanceUtils.getTaxValue((Price)stockLinkable.getPrice(), (double)SystemProperty.getInstance().getBaseTaxRate());
            Price gpPerItem = FinanceUtils.calcGrossProfit((Price)stockLinkable.getPrice(), (Price)taxAmount, (Price)stockLinkable.getIngredientCostExTax());
            this.gpDollarSpinner.setValue(StockLinkableCostPanel.Helper.getDoubleForSpinner(gpPerItem));
            double gpPerc = FinanceUtils.calcGrossProfitMargin((Price)stockLinkable.getPrice(), (Price)taxAmount, (Price)stockLinkable.getIngredientCostExTax());
            this.profitMarginSpinner.setValue(new Double(MathsUtils.roundDoubleToDecPlaces((double)gpPerc, (int)1)));
        }
        this.updateTextColor();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        this.costPanel.getGuiComponent().setEnabled(b);
    }

    @Override
    public JComponent getGuiComponent() {
        return this;
    }
}

