/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.PriceFieldType;
import ordermate.database.misc.SystemProperty;
import ordermate.internationalization.Internationalization;

public class IncExTaxPricePanel
extends FieldPanel {
    private boolean taxEnabled = true;
    private boolean processEventsAllowed = true;
    private PriceFieldType fieldType;
    private JLabel incLabel;
    private JLabel exLabel;
    private SpinnerNumberModel incSpinnerModel;
    private SpinnerNumberModel exSpinnerModel;
    private JSpinner incSpinner;
    private JSpinner exSpinner;
    private JTextField incText;
    private JTextField exText;

    public IncExTaxPricePanel(ObjectManager manager) {
        String taxLabel = SystemProperty.getInstance().getBaseTaxLabel();
        this.incLabel = new JLabel("Inc " + taxLabel + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        this.exLabel = new JLabel("Ex " + taxLabel + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        this.setLayout(new BorderLayout());
    }

    public void setTaxEnabled(boolean enableIt) {
        if (enableIt != this.taxEnabled && this.fieldType != null) {
            if (enableIt) {
                double incValue = ((Number)this.incSpinner.getValue()).doubleValue();
                double exValue = FinanceUtils.removeTax((double)incValue, (double)SystemProperty.getInstance().getBaseTaxRate());
                this.processEventsAllowed = false;
                this.exSpinner.setValue(new Price(exValue, 0.0));
                this.processEventsAllowed = true;
            } else {
                this.processEventsAllowed = false;
                this.exSpinner.setValue(this.incSpinner.getValue());
                this.processEventsAllowed = true;
            }
        }
        this.taxEnabled = enableIt;
        this.updateEnabledState();
    }

    private void updateForNewCostIncTax() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double inc = IncExTaxPricePanel.getDoubleFromSpinner(this.incSpinner);
            double ex = FinanceUtils.removeTax((double)inc, (double)SystemProperty.getInstance().getBaseTaxRate());
            this.exSpinner.setValue(new Price(ex, 0.0).doubleValue());
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewCostExTax() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double ex = IncExTaxPricePanel.getDoubleFromSpinner(this.exSpinner);
            if (this.taxEnabled) {
                double inc = FinanceUtils.addTax((double)ex, (double)SystemProperty.getInstance().getBaseTaxRate());
                this.incSpinner.setValue(new Price(inc, 0.0).doubleValue());
            } else {
                this.incSpinner.setValue(new Price(ex, 0.0).doubleValue());
            }
            this.processEventsAllowed = true;
        }
    }

    public boolean isTaxEnabled() {
        return this.taxEnabled;
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (PriceFieldType)fType;
        Price minObj = this.fieldType.getMinValue();
        Price maxObj = this.fieldType.getMaxValue();
        Price defObj = this.fieldType.getDefaultValue();
        double min = minObj != null ? minObj.doubleValue() : -1.0E7;
        double max = maxObj != null ? maxObj.doubleValue() : 1.0E7;
        double def = defObj != null ? defObj.doubleValue() : 0.0;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        if (this.incSpinner != null) {
            innerPanel.remove(this.incSpinner);
        }
        if (this.exSpinner != null) {
            innerPanel.remove(this.exSpinner);
        }
        this.exSpinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.incSpinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.exSpinner = new JSpinner(this.exSpinnerModel);
        this.incSpinner = new JSpinner(this.incSpinnerModel);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.exSpinner);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.incSpinner);
        JSpinner.DefaultEditor incEditor = (JSpinner.DefaultEditor)this.incSpinner.getEditor();
        JSpinner.DefaultEditor exEditor = (JSpinner.DefaultEditor)this.exSpinner.getEditor();
        this.exSpinner.setPreferredSize(new Dimension(70, 20));
        this.incSpinner.setPreferredSize(new Dimension(70, 20));
        this.incText = incEditor.getTextField();
        this.incText.setColumns(20);
        this.exText = exEditor.getTextField();
        this.exText.setColumns(20);
        InnerEventListener iel = new InnerEventListener();
        this.incSpinner.addChangeListener(iel);
        this.exSpinner.addChangeListener(iel);
        this.incText.addFocusListener(iel);
        this.exText.addFocusListener(iel);
        FieldPanel.ControlKeyListener controlListener = new FieldPanel.ControlKeyListener();
        this.incText.addKeyListener(controlListener);
        this.exText.addKeyListener(controlListener);
        if (this.taxEnabled) {
            this.incText.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
            this.exText.addActionListener(new FieldPanel.InnerSecondaryActionListener());
        } else {
            this.exText.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
            this.incText.addActionListener(new FieldPanel.InnerSecondaryActionListener());
        }
        this.updateEnabledState();
        this.incLabel.setLabelFor(this.incSpinner);
        this.exLabel.setLabelFor(this.exSpinner);
        JPanel northPanel = new JPanel(new GridLayout(2, 1));
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.incSpinner, "East");
        leftPanel.add((Component)this.incLabel, "West");
        rightPanel.add((Component)this.exSpinner, "East");
        rightPanel.add((Component)this.exLabel, "West");
        northPanel.add(leftPanel);
        northPanel.add(rightPanel);
        innerPanel.add((Component)northPanel, "North");
        this.add((Component)innerPanel, "North");
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        JSpinner spinner = this.taxEnabled ? this.incSpinner : this.exSpinner;
        return new Price(IncExTaxPricePanel.getDoubleFromSpinner(spinner), 0.0);
    }

    private static double getDoubleFromSpinner(JSpinner spinner) {
        return ((Number)spinner.getValue()).doubleValue();
    }

    @Override
    public void setValue(Object o) {
        double val = ((Price)o).doubleValue();
        Price max = this.fieldType.getMaxValue();
        Price min = this.fieldType.getMinValue();
        if (min != null && val < min.doubleValue()) {
            val = min.doubleValue();
        } else if (max != null && val > max.doubleValue()) {
            val = max.doubleValue();
        }
        JSpinner toUse = this.taxEnabled ? this.incSpinner : this.exSpinner;
        toUse.setValue(val);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.incLabel.setToolTipText(text);
        this.exLabel.setToolTipText(text);
        this.incSpinner.setToolTipText(text);
        this.exSpinner.setToolTipText(text);
        this.incText.setToolTipText(text);
        this.exText.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        this.incLabel.setEnabled(this.isEnabled() && this.taxEnabled);
        this.exLabel.setEnabled(this.isEnabled());
        this.incSpinner.setEnabled(this.isEnabled() && this.taxEnabled);
        this.exSpinner.setEnabled(this.isEnabled());
        this.incText.setEnabled(this.isEnabled() && this.taxEnabled);
        this.exText.setEnabled(this.isEnabled());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.taxEnabled ? this.incText : this.exText;
    }

    private class InnerEventListener
    implements ChangeListener,
    FocusListener {
        private InnerEventListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == IncExTaxPricePanel.this.exSpinner) {
                IncExTaxPricePanel.this.updateForNewCostExTax();
            } else if (e.getSource() == IncExTaxPricePanel.this.incSpinner) {
                IncExTaxPricePanel.this.updateForNewCostIncTax();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() == IncExTaxPricePanel.this.exText) {
                IncExTaxPricePanel.this.updateForNewCostExTax();
            } else if (e.getSource() == IncExTaxPricePanel.this.incText) {
                IncExTaxPricePanel.this.updateForNewCostIncTax();
            }
        }
    }
}

