/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.templates.Templates;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.TreeFilterPanel;
import officemate.components.actions.AbstractActions;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.SplitTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.components.tree.StockGroupTreeFilterPanel;
import officemate.screens.setup.stock.items.StockItemEditorPanel;
import officemate.screens.setup.stock.items.StockItemGuiHelper;
import officemate.screens.setup.stock.items.StockItemSearchState;
import officemate.screens.setup.stock.items.StockItemSearcher;
import officemate.screens.setup.stock.items.replace.StockItemReplacementManager;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class SetupStockItemsState
extends AbstractTableState<StockItem> {
    private final StockItemSearcher searcher = new StockItemSearcher();
    private PersistentObjectTable<StockItem> mainTable;
    private JCheckBox groupedCheck;
    private final ObjectTemplate stockItemTemplate = Templates.STOCK_ITEM;
    private TreeFilterPanel stockGroupTreePanel;

    public SetupStockItemsState() {
        super("Stock Items", AllPermissions.ACCESS_STOCK_ITEMS_SCREEN, "View, create and modify stock items");
        this.addAction(new AbstractActions.NewAction("/officemate/images/stockNew22.png"){

            public void actionPerformed(ActionEvent e) {
                SetupStockItemsState.this.addObject();
            }
        }.withPermission(AllPermissions.ADD_STOCK_ITEMS, LoginState.getInstance()));
        this.addSelectionDependentAction(new AbstractActions.EditAction("/officemate/images/stockEdit22.png"){

            public void actionPerformed(ActionEvent e) {
                SetupStockItemsState.this.editObject();
            }
        }.withPermission(AllPermissions.EDIT_STOCK_ITEMS, LoginState.getInstance()));
        this.addSelectionDependentAction(new AbstractActions.DeleteAction("/officemate/images/stockDelete22.png"){

            public void actionPerformed(ActionEvent e) {
                SetupStockItemsState.this.removeObject();
            }
        }.withPermission(AllPermissions.DELETE_STOCK_ITEMS, LoginState.getInstance()));
        this.addSelectionDependentAction(new ReplaceAction().withPermission(AllPermissions.ADD_STOCK_ITEMS, LoginState.getInstance()));
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        JCheckBox groupCheck = this.setupGroupCheck();
        this.getControlPanel().add((Component)groupCheck, "East");
        this.getScreenPanel().setName("Stock Items");
    }

    @Override
    protected void onStart() {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Loading stock item setup screen...");
        if (this.isFirstRun()) {
            this.init();
        }
        this.getSearchFactory().reaquireSearchOptions();
        this.refresh();
        frame.resetStatusBarText();
    }

    private void refreshTree() {
        Object obj = this.stockGroupTreePanel.getTreeGuiComponent().getSelectedObject();
        this.stockGroupTreePanel.refresh();
        this.stockGroupTreePanel.getTreeGuiComponent().setSelectedObject(obj);
    }

    @Override
    public void refresh() {
        this.refreshTree();
        super.refresh();
    }

    public void createStockItem() {
        this.addObject();
    }

    private JCheckBox setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", true);
        this.groupedCheck.setSelected(true);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetupStockItemsState.this.groupedCheck.isSelected()) {
                    SetupStockItemsState.this.mainTable.groupOn("Stock Group", null);
                } else {
                    SetupStockItemsState.this.mainTable.groupOn(null, null);
                }
                SetupStockItemsState.this.refresh();
            }
        });
        return this.groupedCheck;
    }

    private void addObject() {
        StockItem createdObj = null;
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Creating " + this.stockItemTemplate.getName() + "...");
        StockItem item = new StockItem();
        Collection selectedStockGroups = (Collection)this.searcher.getStockGroupFilter().getSearchValue();
        if (selectedStockGroups != null && selectedStockGroups.size() > 0) {
            item.setStockGroup((StockGroup)selectedStockGroups.iterator().next());
        }
        StockItemEditorPanel editorView = (StockItemEditorPanel)this.stockItemTemplate.getNewEditPanel(item);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), (ObjectEditorPanel)editorView, editorView.getDefaultSize()) == 0) {
            editorView.saveObject();
            createdObj = (StockItem)editorView.getEditedObject();
            Assert.isTrue((createdObj != null ? 1 : 0) != 0, (String)"Failed to create StockItem");
            StockControlEventLog.logCreateStockItem((User)this.getUser(), (StockItem)createdObj, (boolean)false);
            this.setUpdateRequired();
            this.refresh();
        } else {
            editorView.cancelObject();
        }
        frame.resetStatusBarText();
    }

    @Override
    protected void setUpdateRequired() {
        StockItemQueries.clearCache();
        super.setUpdateRequired();
    }

    @Override
    public void gotObjectDoubleClicked(StockItem item) {
        this.editObject();
    }

    void editObject() {
        if (!this.getUser().hasPermission(AllPermissions.EDIT_STOCK_ITEMS)) {
            Dialogs.showInfoDialog("You do not have permission", "You do not have the required permission to edit stock items");
            return;
        }
        StockItem editedObj = this.getCurrentStockItem();
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Editing " + this.stockItemTemplate.getName() + ":  " + this.stockItemTemplate.getObjectText(editedObj));
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(this.stockItemTemplate);
        changeRecorder.snapshot(editedObj);
        StockItemEditorPanel editorView = (StockItemEditorPanel)this.stockItemTemplate.getNewEditPanel(editedObj);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), (ObjectEditorPanel)editorView, editorView.getDefaultSize()) == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockItem((User)this.getUser(), (StockItem)editedObj, changeRecorder.getChanges(editedObj));
            this.setUpdateRequired();
            this.refresh();
        } else {
            editorView.cancelObject();
        }
        frame.resetStatusBarText();
    }

    void removeObject() {
        List<StockItem> selectedStockItems = this.getCurrentSelectedStockItems();
        if (selectedStockItems == null || selectedStockItems.isEmpty()) {
            return;
        }
        if (StockItemGuiHelper.allowDeleteItems(selectedStockItems) && StockItemGuiHelper.deleteAllSafeStockItems(selectedStockItems)) {
            this.setUpdateRequired();
            StockItemQueries.clearCache();
            this.refresh();
        }
    }

    private void replaceStockItem() {
        if (StockItemReplacementManager.doShowReplaceDialog(this.getCurrentStockItem())) {
            this.setUpdateRequired();
            this.refresh();
        }
    }

    public StockItem getCurrentStockItem() {
        if (this.mainTable == null) {
            return null;
        }
        return this.mainTable.getSelectedObject();
    }

    public List<StockItem> getCurrentSelectedStockItems() {
        if (this.mainTable == null) {
            return null;
        }
        return this.mainTable.getAllSelectedObjects();
    }

    @Override
    protected TableStateCentralArea<StockItem> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        ArrayList<ColumnFormat> columnFormatList = new ArrayList<ColumnFormat>(Arrays.asList(new PropertyColumnFormat("Stock Group", StockItem.Properties.STOCK_GROUP), new PropertyColumnFormat("Name", StockItem.Properties.LABEL), new PropertyColumnFormat("Purchase Cost", StockItem.Properties.CURRENT_COST), new PropertyColumnFormat(StockItem.Properties.PURCHASE_QTY), new PropertyColumnFormat(StockItem.Properties.INGREDIENT_MEASURE_UNIT), new PropertyAccessorColumnFormat(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER, MeasureUnitContainer.Properties.MEASURE_UNIT).setName("Measure Unit"), new PropertyAccessorColumnFormat(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER, MeasureUnitContainer.Properties.MEASURE_CONTAINER).setName("Measure Container").setFormatter(new Format(){

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                if (obj instanceof MeasureContainer) {
                    MeasureContainer cont = (MeasureContainer)obj;
                    toAppendTo.append("<none>".equals(cont.getLabel()) ? "" : cont.getLabel());
                    return toAppendTo;
                }
                toAppendTo.append(obj);
                return toAppendTo;
            }
        }), new PropertyColumnFormat(StockItem.Properties.EXT_ID)));
        ArrayList<ColumnFormat> cols = new ArrayList<ColumnFormat>();
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            cols.add((ColumnFormat)new PropertyColumnFormat("Stock ID", StockItem.Properties.ID));
        }
        cols.addAll(columnFormatList);
        format.addColumns(cols);
        this.mainTable = new PersistentObjectTable(this.getSearchFactory().getObjectList(), format);
        this.mainTable.groupOn("Stock Group", null);
        this.stockGroupTreePanel = new StockGroupTreeFilterPanel((Refreshable)this.getSearchFactory(), this.searcher.getStockGroupFilter());
        SplitTableState<StockItem> splitter = SplitTableState.createHorizontalSplit(this.stockGroupTreePanel, this.mainTable);
        return splitter;
    }

    @Override
    protected OfficeMateObjectSearch<StockItem> createSearchPanelFactory() {
        return new StockItemSearchState(this.searcher);
    }

    @Override
    protected Class<StockItem> getDisplayingType() {
        return StockItem.class;
    }

    private class ReplaceAction
    extends AbstractActions {
        public ReplaceAction() {
            super("Replace", IconLoader.get((String)"/officemate/images/stockReplace22.png"), "Replace");
        }

        public void actionPerformed(ActionEvent e) {
            SetupStockItemsState.this.replaceStockItem();
        }
    }
}

