/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.ServiceLocator;
import au.com.ordermate.units.UnitScales;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.DefaultObjectSelectorPanel;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.fieldpanels.ArrayFieldPanel;
import officemate.adminkit.fieldpanels.BoolFieldPanel;
import officemate.adminkit.fieldpanels.DoubleFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.fieldpanels.PairListFieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.fieldpanels.StringFieldPanel;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.templates.StockItemTemplate;
import officemate.adminkit.tree.DefaultObjectTree;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.adminkit.types.BusinessObjectType;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.screens.setup.stock.ingredients.IngredientEditor;
import officemate.screens.setup.stock.ingredients.IngredientsPanel;
import officemate.screens.setup.stock.items.IncExTaxPricePanel;
import officemate.screens.setup.stock.items.MeasureUnitContainerPanel;
import officemate.screens.setup.stock.items.StockItemParLevelEditor;
import officemate.screens.setup.stock.items.StockItemUsageChecker;
import officemate.screens.setup.stock.items.StockableAreasFieldPanel;
import officemate.screens.setup.stock.items.SuggestedOrderingFieldPanel;
import officemate.screens.setup.stock.items.UsageCostPanel;
import officemate.screens.setup.stock.items.YieldEditorPanel;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.database.users.AllPermissions;

public class StockItemEditorPanel
extends ObjectEditorPanel {
    public static final String DLG_TITLE_INVALID_BARCODE = "Invalid Barcode";
    public static final String DLG_TITLE_LARGE_PRICE_CHANGE = "Large price change";
    public static final String DLG_TITLE_NO_STOCK_GROUP = "No stock group selected";
    public static final String DLG_TITLE_SUPPLIER_MISSING = "Supplier missing";
    public static final String DLG_MSG_SUPPLIER_MISSING = "There must be at least one supplier set up.";
    public static final String NONE_STRING = "<none>";
    private ScaleFilter scaleFilter = new ScaleFilter();
    private ObjectTemplate template;
    private Object editedObject = null;
    private StockGroupTreePanel treePanel;
    private DefaultObjectEditorPanel basicEditorPanel;
    private DefaultObjectEditorPanel advancedEditorPanel;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private StockGroup defaultGroup;
    private StringFieldPanel itemNamePanel;
    private StringFieldPanel itemShortNamePanel;
    private MeasureUnitContainerPanel dispUnitsPanel;
    private ObjectRefFieldPanel ingrUnitsPanel;
    private ObjectSelectorPanel ingrUnitsSelector;
    private ArrayFieldPanel barcodesPanel;
    private QuantityFieldPanel qtyPanel;
    private YieldEditorPanel yieldPanel;
    private IncExTaxPricePanel pricePanel;
    private BoolFieldPanel includesTaxPanel;
    private BoolFieldPanel usePreProdValuesPanel;
    private SuggestedOrderingFieldPanel suggestedPanel;
    private PairListFieldPanel supplierCodePanel;
    private IngredientEditor<StockItem, StockItemIngredientLink> ingredientEditor;
    private IngredientsPanel ingredients;
    private JPanel parLevelsEditorPanel;
    private StockItemParLevelEditor stockItemParLevelEditor;
    private boolean iniFinished = false;

    @Override
    public void init(ObjectManager manager, ObjectTemplate objTemplate, Object editObject) {
        Assert.isEqual(StockItem.class, (Object)objTemplate.getObjectJavaClass(), (String)"Template must support StockItems");
        this.template = objTemplate;
        this.editedObject = editObject;
        this.treePanel = new StockGroupTreePanel(manager, false);
        this.treePanel.setFocusable(false);
        DefaultObjectTree tree = this.treePanel.getTree();
        tree.setFocusable(false);
        tree.expandRow(0);
        if (editObject != null) {
            StockItem item = (StockItem)editObject;
            tree.setSelectedObject(item.getStockGroup());
        } else if (this.defaultGroup != null) {
            tree.setSelectedObject(this.defaultGroup);
        } else if (tree.getRowCount() > 0) {
            tree.setSelectionRow(0);
        }
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.basicEditorPanel = new BasicStockItemEditorPanel();
        this.basicEditorPanel.init(manager, objTemplate, editObject);
        this.basicEditorPanel.okKeyPressed.connect((Object)this.okKeyPressed, "emit");
        this.basicEditorPanel.cancelKeyPressed.connect((Object)this.cancelKeyPressed, "emit");
        this.basicEditorPanel.fieldGotFocus.connect((Object)this, "gotBasicPanelGainedFocus");
        this.advancedEditorPanel = new AdvancedStockItemEditorPanel();
        this.advancedEditorPanel.init(manager, objTemplate, editObject);
        this.advancedEditorPanel.okKeyPressed.connect((Object)this.okKeyPressed, "emit");
        this.advancedEditorPanel.cancelKeyPressed.connect((Object)this.cancelKeyPressed, "emit");
        this.setupIngredientsPanel();
        this.ingredients.setObject((StockItem)editObject);
        this.parLevelsEditorPanel = new JPanel(new BorderLayout());
        this.stockItemParLevelEditor = new StockItemParLevelEditor();
        this.parLevelsEditorPanel.add((Component)this.stockItemParLevelEditor, "Center");
        this.stockItemParLevelEditor.setObject((StockItem)editObject);
        JPanel advContainerPanel = new JPanel();
        advContainerPanel.add(this.advancedEditorPanel);
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.addTab("Basic", this.basicEditorPanel);
        this.tabbedPane.addTab("Advanced", advContainerPanel);
        this.tabbedPane.addTab("Pre production ingredients", this.ingredients.getGuiComponent());
        this.tabbedPane.addTab("Par Levels", this.parLevelsEditorPanel);
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(this.treePanel);
        this.splitPane.setRightComponent(this.tabbedPane);
        this.splitPane.setDividerLocation(140);
        this.splitPane.setFocusable(false);
        this.add((Component)this.splitPane, "Center");
        this.itemNamePanel = (StringFieldPanel)this.basicEditorPanel.getFieldPanel("Name");
        this.itemNamePanel.setName("Name Panel");
        this.itemShortNamePanel = (StringFieldPanel)this.basicEditorPanel.getFieldPanel("Short Name");
        this.itemShortNamePanel.setName("Short Name Panel");
        this.supplierCodePanel = (PairListFieldPanel)this.basicEditorPanel.getFieldPanel("Suppliers/Codes");
        this.supplierCodePanel.getPrimaryComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('\t' == e.getKeyChar() && StockItemEditorPanel.this.supplierCodePanel.getPrimaryComponent().hasFocus()) {
                    ((JTable)StockItemEditorPanel.this.supplierCodePanel.getPrimaryComponent()).getSelectionModel().clearSelection();
                    if (e.getModifiers() == 1) {
                        StockItemEditorPanel.this.basicEditorPanel.getFieldPanel("Short Name").getPrimaryComponent().requestFocusInWindow();
                    } else {
                        StockItemEditorPanel.this.basicEditorPanel.getFieldPanel(StockItemTemplate.INCLUDES_GST).getPrimaryComponent().requestFocusInWindow();
                    }
                }
            }
        });
        this.barcodesPanel = (ArrayFieldPanel)this.advancedEditorPanel.getFieldPanel("Barcodes");
        this.barcodesPanel.setAcceptsTypedEntries(true);
        this.barcodesPanel.elementCreated.connect((Object)this, "gotBarcodeChanged");
        this.barcodesPanel.elementEdited.connect((Object)this, "gotBarcodeChanged");
        this.includesTaxPanel.valueChanged.connect((Object)this, "gotIncludeTaxValueChanged");
        this.usePreProdValuesPanel.valueChanged.connect((Object)this, "gotUsePreProdValueChanged");
        this.ingrUnitsPanel = (ObjectRefFieldPanel)this.basicEditorPanel.getFieldPanel("Ingredient measure");
        this.ingrUnitsSelector = this.ingrUnitsPanel.getObjectSelector();
        ((DefaultObjectSelectorPanel)this.ingrUnitsSelector).setObjectFilter(this.scaleFilter);
        this.ingrUnitsSelector.objectSelected.connect((Object)this, "gotIngredientUnitSelected");
        this.qtyPanel = (QuantityFieldPanel)this.basicEditorPanel.getFieldPanel("Purchase Quantity");
        this.yieldPanel = (YieldEditorPanel)this.basicEditorPanel.getFieldPanel("Yield");
        ((DoubleFieldPanel)this.basicEditorPanel.getFieldPanel("Outer Quantity")).getSpinner().setName("Outer Qty");
        JComboBox outerContainerBox = ((DefaultObjectSelectorPanel)((ObjectRefFieldPanel)this.basicEditorPanel.getFieldPanel("Outer Container")).getObjectSelector()).getComboBox();
        Object selectedOuter = outerContainerBox.getSelectedItem();
        DefaultComboBoxModel model = (DefaultComboBoxModel)outerContainerBox.getModel();
        this.setupOuterContainerCombo(outerContainerBox, model);
        outerContainerBox.setSelectedItem(selectedOuter);
        this.iniFinished = true;
        this.applyDisplayMeasureUnit();
        this.basicEditorPanel.requestFocus();
    }

    private void setupOuterContainerCombo(JComboBox outerContainerBox, DefaultComboBoxModel model) {
        model.removeAllElements();
        model.addElement(NONE_STRING);
        for (MeasureContainer cont : MeasureUnitHelper.getOrderedContainers()) {
            if (cont.equals((Object)MeasureUnitHelper.getContainerForName((String)NONE_STRING))) continue;
            model.addElement(cont);
        }
        outerContainerBox.setModel(model);
        outerContainerBox.setName("Outer Container");
        outerContainerBox.invalidate();
        outerContainerBox.repaint();
    }

    private void setupIngredientsPanel() {
        UsageCostPanel stockCostPanel = new UsageCostPanel();
        this.ingredientEditor = IngredientEditor.create(null, null, StockItemIngredientLink.class, false);
        this.ingredients = new IngredientsPanel<StockItem, StockItemIngredientLink>(null, stockCostPanel, this.ingredientEditor, 350);
        this.ingredients.getGuiComponent().setName("ingredients");
    }

    public void setDefaultGroup(StockGroup group) {
        this.defaultGroup = group;
    }

    @Override
    public void saveObject() {
        StockItem item = (StockItem)this.getEditedObject();
        if (item == null) {
            throw new IllegalStateException("Due to various inadiquicies in stock control this class doesnt work with null items.  If you want a new stock item, construct new stock item ");
        }
        StockGroup selectedStockGroup = (StockGroup)this.treePanel.getSelectedObject();
        item.setStockGroup(selectedStockGroup);
        PreProdManager manager = (PreProdManager)ServiceLocator.locate(PreProdManager.class);
        try {
            Stack stack = manager.getCycleChecker().checkCycles(item, this.ingredientEditor.getGuiList());
            if (stack == null || stack.isEmpty()) {
                this.ingredientEditor.saveObject();
            } else {
                this.ingredientEditor.revertObject();
                StringBuilder msg = new StringBuilder("Could not save item, ingredients create a loop:\n");
                int itemCount = 1;
                Iterator itemIt = stack.iterator();
                while (itemIt.hasNext()) {
                    msg.append(((StockItem)itemIt.next()).getLabel());
                    if (itemCount % 5 == 0) {
                        msg.append("\n");
                    }
                    if (itemIt.hasNext()) {
                        msg.append("->");
                    }
                    ++itemCount;
                }
                Dialogs.showErrorDialog("Could not save stock item", msg.toString());
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Could not save stock item", ex);
        }
        item.setPurchaseQty(this.qtyPanel.getValue());
        item.save();
        this.basicEditorPanel.saveObject();
        this.advancedEditorPanel.saveObject();
        this.stockItemParLevelEditor.saveObject();
        item.save();
    }

    @Override
    public void cancelObject() {
    }

    @Override
    public Object getEditedObject() {
        return this.editedObject;
    }

    public void setEditedObject(Object obj) {
        this.editedObject = obj;
    }

    @Override
    public boolean isNewObject() {
        return this.editedObject == null;
    }

    protected String[] getInvalidFields() {
        long id;
        String[] basicInvalidArray = this.basicEditorPanel.getInvalidFields();
        String[] advancedInvalidArray = this.advancedEditorPanel.getInvalidFields();
        ArrayList<String> invalidList = new ArrayList<String>(Arrays.asList(basicInvalidArray));
        invalidList.addAll(Arrays.asList(advancedInvalidArray));
        double qty = this.qtyPanel.getValue().doubleValue();
        if (qty <= 0.0) {
            invalidList.add("Purchase Quantity");
        }
        String proposedName = (String)this.itemNamePanel.getValue();
        StockItem itemForName = StockItem.getStockItemForName((String)proposedName);
        PersistentObject theEditedObject = (PersistentObject)this.getEditedObject();
        long l = id = theEditedObject != null ? theEditedObject.intID() : 0L;
        if (itemForName != null && itemForName.intID() != id) {
            invalidList.add("Name");
        }
        return invalidList.toArray(new String[0]);
    }

    @Override
    public boolean requestSaveAllowed() {
        StockItem theEditedObject = (StockItem)this.getEditedObject();
        if (this.basicEditorPanel.requestSaveAllowed() && this.advancedEditorPanel.requestSaveAllowed()) {
            long id;
            List pairs = (List)this.supplierCodePanel.getValue();
            if (pairs.size() == 0 || ((Pair)pairs.get(0)).getKey() == null) {
                JOptionPane.showMessageDialog(this, DLG_MSG_SUPPLIER_MISSING, DLG_TITLE_SUPPLIER_MISSING, 1);
                return false;
            }
            HashSet<Object> suppliers = new HashSet<Object>(pairs.size());
            for (Pair pair : pairs) {
                if (suppliers.add(pair.key)) continue;
                JOptionPane.showMessageDialog(this, "The supplier \"" + pair.key + "\" has been set twice.", "Dupplicate provider", 1);
                return false;
            }
            String proposedName = (String)this.itemNamePanel.getValue();
            StockItem itemForName = StockItem.getStockItemForName((String)proposedName);
            long l = id = theEditedObject != null ? theEditedObject.intID() : 0L;
            if (itemForName != null && itemForName.intID() != id) {
                JOptionPane.showMessageDialog(this, "The name \"" + proposedName + "\" has already been taken. \nPlease choose a different name.", "Invalid name", 1);
                return false;
            }
            Object selObject = this.treePanel.getTree().getSelectedObject();
            if (selObject == null || !(selObject instanceof StockGroup)) {
                JOptionPane.showMessageDialog(this, "A stock group must be selected to continue.", DLG_TITLE_NO_STOCK_GROUP, 1);
                return false;
            }
            if (theEditedObject != null) {
                double stockWarn = SystemProperty.getInstance().getStockPriceWarn();
                String PERCENT_LIMIT_STRING = (int)(stockWarn * 100.0) + "%";
                double proposedPrice = ((Price)this.pricePanel.getValue()).doubleValue();
                double oldPrice = theEditedObject.getCurrentReplacementCost().doubleValue();
                double diff = Math.abs(proposedPrice - oldPrice);
                if (oldPrice != 0.0 && diff / oldPrice > stockWarn) {
                    int result = JOptionPane.showConfirmDialog(this, "Price has been changed by more than " + PERCENT_LIMIT_STRING + ", are you sure you wish to save? ", DLG_TITLE_LARGE_PRICE_CHANGE, 2);
                    return result == 0;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean requestCancelAllowed() {
        return true;
    }

    @Override
    public ObjectTemplate getTemplate() {
        return this.template;
    }

    @Override
    public int getDialogMode() {
        return 0;
    }

    private void applyDisplayMeasureUnit() {
        MeasureUnitContainer unitContainer = (MeasureUnitContainer)this.dispUnitsPanel.getValue();
        if (this.suggestedPanel != null) {
            this.suggestedPanel.setMeasureUnitContainer(unitContainer);
        }
        UnitScales scale = unitContainer.getMeasureUnit().getUnitScale();
        this.scaleFilter.setScale(scale);
        this.ingrUnitsSelector.updateView();
        Quantity qty = this.qtyPanel.getValue();
        this.qtyPanel.setValue(new Quantity(unitContainer, qty.doubleValue(), false));
        Double percentage = this.yieldPanel.getYieldAsPercentage();
        if (!percentage.equals(null)) {
            this.yieldPanel.setMeasureUnitContainer(unitContainer);
            this.yieldPanel.setValueAsPercentage(percentage);
            this.yieldPanel.invalidate();
            this.repaint();
        }
    }

    private void applyIngredientMeasureUnit(MeasureUnit unit) {
    }

    public void gotDisplayUnitSelected(MeasureUnit unit) {
        if (this.iniFinished) {
            this.applyDisplayMeasureUnit();
            this.repaint();
        }
    }

    void gotIncludeTaxValueChanged(Boolean b) {
        this.pricePanel.setTaxEnabled(b);
    }

    void gotUsePreProdValueChanged() {
        this.updateUsePreProdSetting();
    }

    void gotBasicPanelGainedFocus() {
        this.updateUsePreProdSetting();
    }

    private void updateUsePreProdSetting() {
        StockItem stockItem = (StockItem)this.editedObject;
        boolean usePreProd = (Boolean)this.usePreProdValuesPanel.getValue();
        stockItem.setReplacementCostMatchPreProdCost(usePreProd);
        this.pricePanel.setEnabled(!usePreProd);
        this.includesTaxPanel.setEnabled(!usePreProd);
        if (usePreProd) {
            this.pricePanel.setValue(stockItem.getCurrentReplacementCost());
            this.includesTaxPanel.setValue(Boolean.FALSE);
        }
    }

    void gotIngredientUnitSelected(Object o) {
        MeasureUnit unit = (MeasureUnit)o;
        this.applyIngredientMeasureUnit(unit);
        this.repaint();
    }

    void gotBarcodeChanged(Object o, Integer index) {
        String barcode = (String)o;
        String cleanBarcode = BarcodeUtils.stripBarcodeDelimiter((String)barcode);
        List elements = this.barcodesPanel.getValue();
        if (cleanBarcode.length() > 0) {
            elements.set(index, BarcodeUtils.stripBarcodeDelimiter((String)barcode));
        } else {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "A barcode must be numeric.", DLG_TITLE_INVALID_BARCODE, 1);
            elements.remove(index);
        }
        this.barcodesPanel.setValue(new ArrayList(new HashSet(elements)));
    }

    public FieldPanel getFieldPanel(String fieldName) {
        FieldPanel panel = this.basicEditorPanel.getFieldPanel(fieldName);
        if (panel == null) {
            panel = this.advancedEditorPanel.getFieldPanel(fieldName);
        }
        return panel;
    }

    public Dimension getDefaultSize() {
        return new Dimension(600, 500);
    }

    class ScaleFilter
    implements ObjectFilter {
        private UnitScales scale = UnitScales.Units;

        ScaleFilter() {
        }

        @Override
        public boolean accept(Object o) {
            if (o instanceof MeasureUnit) {
                return this.scale.equals((Object)((MeasureUnit)o).getUnitScale());
            }
            return false;
        }

        public void setScale(UnitScales scale) {
            if (scale != null) {
                this.scale = scale;
            }
        }
    }

    private class AdvancedStockItemEditorPanel
    extends DefaultObjectEditorPanel {
        public AdvancedStockItemEditorPanel() {
            super(new String[]{"Barcodes", "Stockable areas"});
        }

        @Override
        protected FieldPanel createFieldPanel(String fieldName) {
            if (fieldName.equals("Stockable areas")) {
                StockableAreasFieldPanel panel = new StockableAreasFieldPanel(super.getTemplate().getManager());
                panel.setFieldType(super.getTemplate().getFieldType(fieldName));
                return panel;
            }
            if (fieldName.equals("Suggested Order Min/Max")) {
                StockItem stockItem = (StockItem)this.getEditedObject();
                StockItemEditorPanel.this.suggestedPanel = new SuggestedOrderingFieldPanel(super.getTemplate().getManager());
                if (stockItem != null) {
                    StockItemEditorPanel.this.suggestedPanel.setMeasureUnitContainer(stockItem.getDisplayMeasureUnitContainer());
                }
                StockItemEditorPanel.this.suggestedPanel.setFieldType(super.getTemplate().getFieldType(fieldName));
                return StockItemEditorPanel.this.suggestedPanel;
            }
            return super.createFieldPanel(fieldName);
        }
    }

    private class BasicStockItemEditorPanel
    extends DefaultObjectEditorPanel {
        private String[] uneditableWhenUsed;
        private String[] editableIfPermissioned;
        private JPanel stockUsedPanel;

        public BasicStockItemEditorPanel() {
            super(new String[]{"Name", "Short Name", "Suppliers/Codes", "Purchase Cost", "Purchase Quantity", StockItemTemplate.INCLUDES_GST, "Outer Quantity", "Outer Container", "Measure Unit", "Ingredient measure", "Yield", "Use Pre-Prod Cost"});
            this.uneditableWhenUsed = new String[]{"Purchase Quantity", "Outer Quantity", "Outer Container", "Measure Unit", "Ingredient measure"};
            this.editableIfPermissioned = new String[]{"Outer Quantity", "Outer Container"};
        }

        @Override
        protected FieldPanel createFieldPanel(String fieldName) {
            if (fieldName.equals("Purchase Cost")) {
                StockItemEditorPanel.this.pricePanel = new IncExTaxPricePanel(super.getTemplate().getManager());
                StockItemEditorPanel.this.pricePanel.setFieldType(new PriceFieldType(0.0, Double.MAX_VALUE, 0.0));
                return StockItemEditorPanel.this.pricePanel;
            }
            if (fieldName.equals("Yield")) {
                StockItemEditorPanel.this.yieldPanel = new YieldEditorPanel();
                StockItemEditorPanel.this.yieldPanel.setFieldType(new DoubleFieldType(0.0, 9999999.0, 100.0));
                return StockItemEditorPanel.this.yieldPanel;
            }
            if (fieldName.equals("Measure Unit")) {
                StockItemEditorPanel.this.dispUnitsPanel = new MeasureUnitContainerPanel();
                StockItemEditorPanel.this.dispUnitsPanel.setFieldType(new BusinessObjectType(MeasureUnitContainer.class, MeasureUnitContainer.class));
                ((StockItemEditorPanel)StockItemEditorPanel.this).dispUnitsPanel.measureUnitSelected.connect((Object)StockItemEditorPanel.this, "gotDisplayUnitSelected");
                return StockItemEditorPanel.this.dispUnitsPanel;
            }
            if (fieldName.equals("Use Pre-Prod Cost")) {
                StockItemEditorPanel.this.usePreProdValuesPanel = (BoolFieldPanel)super.createFieldPanel(fieldName);
                return StockItemEditorPanel.this.usePreProdValuesPanel;
            }
            if (fieldName.equals(StockItemTemplate.INCLUDES_GST)) {
                StockItemEditorPanel.this.includesTaxPanel = (BoolFieldPanel)super.createFieldPanel(fieldName);
                return StockItemEditorPanel.this.includesTaxPanel;
            }
            return super.createFieldPanel(fieldName);
        }

        @Override
        public void initComponents() {
            super.initComponents();
            this.buildStockItemUsedPanel();
        }

        private void buildStockItemUsedPanel() {
            this.stockUsedPanel = new JPanel();
            this.stockUsedPanel.setLayout(new BoxLayout(this.stockUsedPanel, 1));
            this.stockUsedPanel.setName("StockUsedPanel");
            JLabel stockUsedLabel = new JLabel("** Stock Items quantity and measures can not be edited as it has been used (as Ingredient, Stocktake etc).");
            JLabel stockUsedLabel2 = new JLabel("   Use the Stock Item Replace option to replace this Stock Item with another Stock Item if required.");
            stockUsedLabel.setFont(new Font(stockUsedLabel.getFont().getName(), 2, stockUsedLabel.getFont().getSize()));
            stockUsedLabel.setForeground(Color.RED);
            stockUsedLabel2.setFont(stockUsedLabel.getFont());
            stockUsedLabel2.setForeground(Color.RED);
            this.stockUsedPanel.add(stockUsedLabel);
            this.stockUsedPanel.add(stockUsedLabel2);
            this.add((Component)this.stockUsedPanel, "South");
        }

        @Override
        public void setEditedObject(Object o) {
            super.setEditedObject(o);
            StockItem stockItem = (StockItem)o;
            StockItemEditorPanel.this.pricePanel.setTaxEnabled(stockItem.isTaxIncluded());
            StockItemEditorPanel.this.yieldPanel.setMeasureUnitContainer(stockItem.getDisplayMeasureUnitContainer());
            StockItemEditorPanel.this.yieldPanel.setValueAsPercentage(stockItem.getYieldAsPercentage());
            this.setStockQuantityModificationsAllowed(!StockItemUsageChecker.isStockItemUsed(stockItem));
            StockItemEditorPanel.this.updateUsePreProdSetting();
        }

        private void setStockQuantityModificationsAllowed(boolean allow) {
            block0: for (int i = 0; i < this.uneditableWhenUsed.length; ++i) {
                FieldPanel panel = this.getFieldPanelForLabel(this.uneditableWhenUsed[i]);
                if (panel == null) continue;
                panel.setEnabled(allow);
                if (!GuiApp.getAppComplex().getApplicationSecurity().getUser().hasPermission(AllPermissions.EDIT_STOCK_ITEM_WITH_USAGE)) continue;
                for (String nextOne : this.editableIfPermissioned) {
                    if (!nextOne.equals(this.uneditableWhenUsed[i])) continue;
                    panel.setEnabled(true);
                    continue block0;
                }
            }
            this.stockUsedPanel.setVisible(!allow);
        }
    }
}

