/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.MathsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import officemate.adminkit.templates.Templates;
import ordermate.database.config.Quantity;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.users.User;

public class StockItemGuiHelper {
    public static boolean allowDeleteItems(List<StockItem> selectedStockItems) {
        StringBuilder message = new StringBuilder("Are you sure you wish to delete the selected stock item(s)? \n");
        if (selectedStockItems != null) {
            StockItemGuiHelper.appendUsedItems(selectedStockItems, message);
        }
        message.append("This operation cannot be undone.");
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), message.toString(), "Delete stock item(s)?", 0, 2);
        if (result == 0) {
            if (!StockTake.hasLiveStockTake()) {
                return true;
            }
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Stock items can't be deleted as there is currently a live stocktake.\n\n Please complete the current stocktake before deleting stock items.", "Cannot delete Stock Item(s)", 2);
        }
        return false;
    }

    private static void appendUsedItems(List<StockItem> items, StringBuilder sb) {
        ArrayList<StockItem> usedItems = new ArrayList<StockItem>();
        for (StockItem item : items) {
            if (!item.isUsedAsIngredient()) continue;
            usedItems.add(item);
        }
        if (usedItems.size() == 1) {
            sb.append("Warning: This stock item is in use. \n");
        } else if (usedItems.size() > 1) {
            sb.append("Warning: Items within this group are in use. \n");
        }
    }

    public static boolean deleteAllSafeStockItems(List<StockItem> selectedStockItems) {
        boolean itemWasDelete = false;
        HashMap<StockItem, Quantity> cantDeleteMap = new HashMap<StockItem, Quantity>();
        for (StockItem item : selectedStockItems) {
            Quantity soh = item.getTotalStockOnHand();
            if (MathsUtils.approxGreaterThan((double)soh.getRawValue(), (double)0.0)) {
                cantDeleteMap.put(item, soh);
                continue;
            }
            ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
            frame.setStatusBarText("Removing " + Templates.STOCK_ITEM.getName() + ":  " + item.getLabel());
            StockControlEventLog.logDeleteStockItem((User)GuiApp.getAppComplex().getApplicationSecurity().getUser(), (StockItem)item);
            frame.resetStatusBarText();
            item.delete();
            itemWasDelete = true;
        }
        if (!cantDeleteMap.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Cannot delete item(s) while stock on hand remains or used in pre-production. \n" + StockItemGuiHelper.getUndeletableItemsText(cantDeleteMap), "Cannot delete Stock Item(s)", 2);
        }
        return itemWasDelete;
    }

    private static String getUndeletableItemsText(Map<StockItem, Quantity> cantDeleteMap) {
        StringBuilder sb = new StringBuilder("\n");
        for (StockItem item : cantDeleteMap.keySet()) {
            sb.append("   ").append(item).append(" - ").append(cantDeleteMap.get(item)).append("\n");
        }
        return sb.toString();
    }
}

