/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.OrderMateLog;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.components.controls.toolbar.CrudToolBar;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.screens.setup.stock.items.StockParLevelEditor;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemParLevel;
import ordermate.database.stock.StockParLevel;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class StockItemParLevelEditor
extends TableListObjectEditor<StockItem, StockItemParLevel> {
    private StockParLevelEditor editor;
    private StockParLevel lastEditedLevel;

    public StockItemParLevelEditor() {
        super(new PersistentObjectTable(new BasicEventList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(StockItemParLevel.Properties.STOCK_AREA), new PropertyColumnFormat(StockItemParLevel.Properties.STOCK_PAR_LEVEL), new EditablePropertyColumnFormat(StockItemParLevel.Properties.SUGGESTED_MIN), new EditablePropertyColumnFormat(StockItemParLevel.Properties.SUGGESTED_MAX)})), new CrudToolBar());
        this.setUpCellRenderers();
        this.editor = new StockParLevelEditor();
        this.setElementEditor(this.editor);
        this.getPersistentObjectTable().getTable().setAutoCreateRowSorter(true);
        this.getPersistentObjectTable().getTable().getRowSorter().toggleSortOrder(0);
    }

    @Override
    public StockItemParLevel createNewObject() {
        try {
            StockItemParLevel newStockItemParLevel = new StockItemParLevel();
            if (this.editElement(newStockItemParLevel)) {
                this.addNewLevelsForSelectedLevel(newStockItemParLevel);
                return newStockItemParLevel;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addNewLevelsForSelectedLevel(StockItemParLevel newStockItemParLevel) {
        boolean first = true;
        for (StockArea area : StockArea.getStockAreas()) {
            StockItemParLevel additionalStockLevelLink = first ? newStockItemParLevel : new StockItemParLevel();
            additionalStockLevelLink.setStockItem((StockItem)this.getObject());
            additionalStockLevelLink.setStockArea(area);
            additionalStockLevelLink.setStockParLevel(newStockItemParLevel.getStockParLevel());
            additionalStockLevelLink.setSuggestedMax(0.0);
            additionalStockLevelLink.setSuggestedMin(0.0);
            if (!first) {
                this.getPersistentObjectTable().getEventList().add((Object)additionalStockLevelLink);
                continue;
            }
            first = false;
        }
    }

    @Override
    public Collection<StockItemParLevel> getParentList() {
        return ((StockItem)this.getObject()).getStockItemParLevels();
    }

    @Override
    public void removeSelectedElement() {
        StockItemParLevel toDelete = (StockItemParLevel)this.getPersistentObjectTable().getSelectedObject();
        HashSet<StockItemParLevel> allToDelete = new HashSet<StockItemParLevel>();
        allToDelete.add(toDelete);
        for (StockItemParLevel parLevel : this.getPersistentObjectTable().getEventList()) {
            if (!parLevel.getStockParLevel().equals((Object)toDelete.getStockParLevel())) continue;
            allToDelete.add(parLevel);
        }
        this.getPersistentObjectTable().getEventList().removeAll(allToDelete);
        this.gotObjectEdited(null);
    }

    @Override
    public void addObjectToParent(StockItemParLevel toAdd) {
        ((StockItem)this.getObject()).addStockItemParLevel(toAdd);
    }

    @Override
    public void removeObjectFromParent(StockItemParLevel toRemove) {
        ((StockItem)this.getObject()).removeStockItemParLevel(toRemove);
    }

    @Override
    public void newElement() {
        if (this.checkNotAllParLevelsAssigned()) {
            super.newElement();
        }
    }

    @Override
    public void editSelectedElement() {
        if (this.checkNotAllParLevelsAssigned()) {
            this.lastEditedLevel = ((StockItemParLevel)this.getPersistentObjectTable().getSelectedObject()).getStockParLevel();
            super.editSelectedElement();
        }
    }

    @Override
    public void gotObjectEdited(StockItemParLevel editedObject) {
        if (editedObject != null && this.lastEditedLevel != null) {
            for (StockItemParLevel parLevel : this.getPersistentObjectTable().getEventList()) {
                if (!parLevel.getStockParLevel().equals((Object)this.lastEditedLevel)) continue;
                parLevel.setStockParLevel(editedObject.getStockParLevel());
            }
            this.getPersistentObjectTable().invalidate();
            this.getPersistentObjectTable().repaint();
        }
        this.objectEdited.emit();
    }

    private boolean checkNotAllParLevelsAssigned() {
        HashSet<StockParLevel> avaliableLevels = new HashSet<StockParLevel>(StockParLevel.getAllParLevels());
        for (StockItemParLevel parLevel : this.getPersistentObjectTable().getEventList()) {
            if (!avaliableLevels.contains(parLevel.getStockParLevel())) continue;
            avaliableLevels.remove(parLevel.getStockParLevel());
        }
        if (avaliableLevels.isEmpty()) {
            Dialogs.showInfoDialog("Cannot Add/Edit Par Level", "All par levels are currently allocated.");
        }
        this.editor.setAvaliableParLevels(avaliableLevels);
        return !avaliableLevels.isEmpty();
    }

    private void setUpCellRenderers() {
        TableCellRenderer defaultRenderer = this.getPersistentObjectTable().getTable().getDefaultRenderer(Object.class);
        TableColumnExt minQuantity = this.getPersistentObjectTable().getTable().getColumnExt((Object)StockItemParLevel.Properties.SUGGESTED_MIN);
        minQuantity.setCellRenderer(new UnitQuantityRenderer(defaultRenderer));
        minQuantity.setCellEditor(new UnitQuantityEditor());
        TableColumnExt maxQuantity = this.getPersistentObjectTable().getTable().getColumnExt((Object)StockItemParLevel.Properties.SUGGESTED_MAX);
        maxQuantity.setCellRenderer(new UnitQuantityRenderer(defaultRenderer));
        maxQuantity.setCellEditor(new UnitQuantityEditor());
    }

    private class UnitQuantityEditor
    extends AbstractQuantityEditor {
        private UnitQuantityEditor() {
        }

        @Override
        protected Double convertToRaw(double value, StockItem item) {
            return value * item.getDisplayMeasureUnitContainer().getMultiplier();
        }

        @Override
        protected String convertToDisplay(double value, StockItem item) {
            return this.dc.format(value / item.getDisplayMeasureUnitContainer().getMultiplier());
        }

        @Override
        protected boolean canEdit(StockItem item) {
            return true;
        }
    }

    private class UnitQuantityRenderer
    extends AbstractQuantityRenderer
    implements TableCellRenderer {
        public UnitQuantityRenderer(TableCellRenderer renderer) {
            super(renderer);
        }

        @Override
        protected double convertValue(Number value, StockItem item) {
            return value.doubleValue() / item.getDisplayMeasureUnitContainer().getMultiplier();
        }

        @Override
        protected String getSuffix(StockItem item) {
            return item.getDisplayMeasureUnitContainer().getDisplayName();
        }

        @Override
        protected boolean canRender(StockItem item) {
            return true;
        }
    }

    private abstract class AbstractQuantityEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DecimalFormat dc = new DecimalFormat("0.###");
        private JTextField textField = new JTextField();
        private StockItem currentItem;

        @Override
        public Object getCellEditorValue() {
            String value = this.textField.getText();
            if (value == null) {
                return null;
            }
            String toParse = value.trim();
            if (toParse.length() == 0) {
                return null;
            }
            try {
                return this.convertToRaw(Double.parseDouble(toParse), this.currentItem);
            }
            catch (NumberFormatException ex) {
                OrderMateLog.LOG.warn("Invalid numerical quantity:", (Throwable)ex);
                this.cancelCellEditing();
                return null;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int index = row;
            index = table instanceof GroupedTable ? ((GroupedTableModel)table.getModel()).getOriginalRow(row) : ((JXTable)table).convertRowIndexToModel(index);
            if (index < 0 || index >= StockItemParLevelEditor.this.getObjectTable().getEventList().size()) {
                this.currentItem = null;
                this.textField.setText("");
                this.textField.setEditable(false);
                return this.textField;
            }
            this.currentItem = ((StockItemParLevel)StockItemParLevelEditor.this.getObjectTable().getEventList().get(index)).getStockItem();
            if (!this.canEdit(this.currentItem)) {
                this.textField.setText("");
                this.textField.setEditable(false);
            } else {
                if (value == null) {
                    value = table.getValueAt(row, column);
                }
                if (value != null) {
                    String original = String.valueOf(value).trim();
                    if (original.indexOf(" ") > 0) {
                        original = original.substring(0, original.indexOf(" "));
                    }
                    this.textField.setText(this.convertToDisplay(Double.parseDouble(original), this.currentItem));
                } else {
                    this.textField.setText("");
                }
                this.textField.setEditable(true);
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(this.textField.getText().length());
            }
            return this.textField;
        }

        protected abstract String convertToDisplay(double var1, StockItem var3);

        protected abstract Double convertToRaw(double var1, StockItem var3);

        protected abstract boolean canEdit(StockItem var1);
    }

    private abstract class AbstractQuantityRenderer
    extends JLabel
    implements TableCellRenderer {
        private DecimalFormat dc = new DecimalFormat("0.###");
        private TableCellRenderer wrappedRenderer;

        public AbstractQuantityRenderer(TableCellRenderer renderer) {
            this.wrappedRenderer = renderer;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(comp.getBackground());
            int index = row;
            index = table instanceof GroupedTable ? ((GroupedTableModel)table.getModel()).getOriginalRow(row) : ((JXTable)table).convertRowIndexToModel(index);
            EventList list = StockItemParLevelEditor.this.getObjectTable().getEventList();
            list.getReadWriteLock().readLock().lock();
            if (index >= 0 && index < list.size()) {
                StockItem item = ((StockItemParLevel)StockItemParLevelEditor.this.getObjectTable().getEventList().get(index)).getStockItem();
                if (this.canRender(item)) {
                    StringBuilder SB = new StringBuilder();
                    if (value == null) {
                        SB.append("____");
                    } else {
                        SB.append(this.dc.format(this.convertValue((Number)value, item)));
                    }
                    String suffix = this.getSuffix(item).trim();
                    if (!suffix.isEmpty()) {
                        SB.append(" ");
                        SB.append(this.getSuffix(item).trim());
                    }
                    this.setText(SB.toString());
                } else {
                    this.setText("");
                }
            } else {
                this.setText("");
            }
            list.getReadWriteLock().readLock().unlock();
            return this;
        }

        protected abstract double convertValue(Number var1, StockItem var2);

        protected abstract String getSuffix(StockItem var1);

        protected abstract boolean canRender(StockItem var1);
    }
}

