/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.search.searchfield.java.CheckBoxSearchField;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DaysAgoSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.SearchType;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import officemate.screens.setup.stock.items.StockItemSearcher;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;

public class StockItemSearchState
extends ObjectPropertySearch<StockItem> {
    private final EventList suppliers = new BasicEventList();
    private CheckBoxSearchField cbShowOnlyUnlinkedStockItems;
    private StockItemSearcher theSearcher;

    public StockItemSearchState(StockItemSearcher searcher) {
        super(StockItem.class, searcher, new BasicEventList());
        this.theSearcher = searcher;
        RefreshAction refreshAction = new RefreshAction((Refreshable)this);
        this.addSearchField((SearchGuiField)new DaysAgoSearchField("Show created since", (Action)refreshAction, searcher.getCreatedSinceFilter()));
        this.addSearchField((SearchGuiField)new StringSearchField("Item name", SearchType.EVENTLIST_FILTER, StockItem.Properties.LABEL, null));
        this.addSearchField((SearchGuiField)new ComboSearchField("Supplier", searcher.getSupplierSearch(), true, (Action)refreshAction, this.suppliers));
        this.cbShowOnlyUnlinkedStockItems = new CheckBoxSearchField("Show only unlinked stock items", (BooleanSearchFilter)searcher.getUnlinkedItemSearch(), (Action)refreshAction).filterWhenDeselected(false);
        this.addSearchField((SearchGuiField)this.cbShowOnlyUnlinkedStockItems);
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.suppliers, StockSupplier.getSuppliers());
    }

    @Override
    public void doRefresh() {
        if (((JCheckBox)this.cbShowOnlyUnlinkedStockItems.getGuiComponent()).isSelected()) {
            this.theSearcher.getUnlinkedItemSearch().setCheckBoxActive(true);
        } else {
            this.theSearcher.getUnlinkedItemSearch().setCheckBoxActive(false);
        }
        super.doRefresh();
    }
}

