/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.BooleanQueryFilter;
import au.com.ordermate.oquery.search.filter.implementation.ComparisonSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import java.util.Collection;
import java.util.Date;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.database.stock.usagelink.StockUsageModLink;

public class StockItemSearcher
extends PropertySearcher<StockItem> {
    private final ISingleValueSearchFilter<Collection<StockGroup>> stockGroupSearch;
    private final ComparisonSearchFilter<Date> createdSinceFilter;
    private final ObjectJoinSearchFilter supplierSearch;
    private final CheckboxQueryFilter unlinkedItemsSearch;
    private ObjectQuery baseQuery;

    public StockItemSearcher() {
        super(StockItem.class);
        this.stockGroupSearch = new MultiOptionSearchFilter(StockItem.Properties.STOCK_GROUP);
        this.createdSinceFilter = ComparisonSearchFilter.createGreaterThanEqualTo((PropertiedObject.Property)StockItem.Properties.CREATION_TIME).usingDateType(SQLDateType.TIMESTAMP);
        this.supplierSearch = new ObjectJoinSearchFilter((SingleValueQuerySearchFilter)new MultiOptionSearchFilter(StockItemSupplier.Properties.STOCK_SUPPLIER), new PropertiedObject.Property[]{StockItem.Properties.STOCK_ITEM_SUPPLIERS, StockItemSupplier.Properties.STOCK_SUPPLIER});
        this.unlinkedItemsSearch = new CheckboxQueryFilter(null);
        this.baseQuery = Mode.NORMAL.getBaseQuery();
        this.setMode(Mode.NORMAL);
        this.addSearchFilter((SearchFilterI)this.stockGroupSearch);
        this.addSearchFilter((SearchFilterI)this.supplierSearch);
        this.addSearchFilter((SearchFilterI)this.getCreatedSinceFilter());
        this.addSearchFilter((SearchFilterI)this.getUnlinkedItemSearch());
    }

    public void setMode(Mode mode) {
        this.baseQuery = mode.getBaseQuery().copy();
    }

    protected ObjectQuery getBaseQuery() {
        return this.baseQuery.copy();
    }

    public ISingleValueSearchFilter<Collection<StockGroup>> getStockGroupFilter() {
        return this.stockGroupSearch;
    }

    public ComparisonSearchFilter<Date> getCreatedSinceFilter() {
        return this.createdSinceFilter;
    }

    public ISingleValueSearchFilter<StockSupplier> getSupplierSearch() {
        return this.supplierSearch;
    }

    public CheckboxQueryFilter getUnlinkedItemSearch() {
        return this.unlinkedItemsSearch;
    }

    public class CheckboxQueryFilter
    extends BooleanQueryFilter {
        private boolean checkboxActive;

        public CheckboxQueryFilter(PropertiedObject.Property prop) {
            super(prop);
            this.checkboxActive = false;
        }

        public void setCheckBoxActive(boolean value) {
            this.checkboxActive = value;
        }

        public ObjectQuery addQueryRestriction(ObjectQuery query) {
            if (!this.checkboxActive) {
                return query;
            }
            query.joinLeft(StockUsageModLink.class, StockUsageModLink.Properties.STOCK_ITEM).isNull(StockUsageModLink.Properties.STOCK_ITEM).joinLeft(StockInventoryUsageLink.class, StockInventoryUsageLink.Properties.STOCK_ITEM).isNull(StockInventoryUsageLink.Properties.STOCK_ITEM).joinLeft(StockItemIngredientLink.class, StockItemIngredientLink.Properties.STOCK_ITEM).isNull(StockItemIngredientLink.Properties.STOCK_ITEM);
            return query;
        }
    }

    public static enum Mode {
        NORMAL{

            @Override
            protected ObjectQuery getBaseQuery() {
                return Query.select(StockItem.class).active(StockItem.class).linkUsing(StockItem.Properties.STOCK_GROUP).lastFrom("stock_item").orderBy(StockGroup.Properties.LABEL).orderBy(StockItem.Properties.LABEL);
            }
        }
        ,
        ONLY_WITH_INGREDIENTS{

            @Override
            protected ObjectQuery getBaseQuery() {
                return StockItemQueries.getStockItemsWithIngredientsQuery().linkUsing(StockItem.Properties.STOCK_GROUP, StockGroup.Properties.ID).lastFrom("stock_item").orderBy(StockGroup.Properties.LABEL).orderBy(StockItem.Properties.LABEL);
            }
        };


        protected abstract ObjectQuery getBaseQuery();
    }
}

