/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.util.Assert;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.ArrayFieldType;
import officemate.adminkit.types.FieldType;
import ordermate.database.stock.StockArea;

public class StockableAreasFieldPanel
extends FieldPanel {
    private StockArea[] allStockAreas;
    private JCheckBox[] areaChecks;
    private FieldType fieldType;

    public StockableAreasFieldPanel(ObjectManager manager) {
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = fType;
        Assert.isInstanceOf((Object)fType, ArrayFieldType.class, (String)"Field type must be an ArrayFieldType");
        List stockAreas = StockArea.getStockAreas();
        int numStockAreas = stockAreas.size();
        this.setLayout(new GridLayout(numStockAreas, 1));
        this.allStockAreas = stockAreas.toArray(new StockArea[0]);
        this.areaChecks = new JCheckBox[numStockAreas];
        for (int i = 0; i < numStockAreas; ++i) {
            this.areaChecks[i] = new JCheckBox(this.allStockAreas[i].getLabel(), true);
            if (i == 0) {
                this.areaChecks[i].addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
                this.areaChecks[i].addKeyListener(new FieldPanel.ControlKeyListener());
            } else {
                this.areaChecks[i].addActionListener(new FieldPanel.InnerSecondaryActionListener());
                this.areaChecks[i].setFocusable(false);
            }
            this.add(this.areaChecks[i]);
        }
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        ArrayList<StockArea> retval = new ArrayList<StockArea>();
        for (int i = 0; i < this.areaChecks.length; ++i) {
            if (!this.areaChecks[i].isSelected()) continue;
            retval.add(this.allStockAreas[i]);
        }
        return retval;
    }

    @Override
    public void setValue(Object o) {
        List stockAreas = (List)o;
        int numStoredStockAreas = this.allStockAreas.length;
        for (int a = 0; a < numStoredStockAreas; ++a) {
            boolean foundSelectedArea = stockAreas.contains(this.allStockAreas[a]);
            this.areaChecks[a].setSelected(foundSelectedArea);
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        for (int i = 0; i < this.areaChecks.length; ++i) {
            this.areaChecks[i].setToolTipText(text);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.areaChecks.length; ++i) {
            this.areaChecks[i].setEnabled(b);
        }
    }

    @Override
    public JComponent getPrimaryComponent() {
        if (this.areaChecks.length > 0) {
            return this.areaChecks[0];
        }
        return this;
    }
}

