/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.MinMax;
import au.com.ordermate.util.Pair;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.ArrayFieldType;
import officemate.adminkit.types.FieldType;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;

public class SuggestedOrderingFieldPanel
extends FieldPanel {
    private StockArea[] allStockAreas;
    private JSpinner[] minFields;
    private JSpinner[] maxFields;
    private JLabel minLabel = new JLabel("Min");
    private JLabel maxLabel = new JLabel("Max");
    private JLabel[] areaLabels;
    private JLabel[] unitLabels;
    private MeasureUnitContainer unitContainer = new MeasureUnitContainer(MeasureUnitHelper.getMeasureUnitForName((String)"unit"));
    private FieldType fieldType;
    private List minMaxList;

    public SuggestedOrderingFieldPanel(ObjectManager manager) {
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = fType;
        Assert.isInstanceOf((Object)fType, ArrayFieldType.class, (String)"Field type must be an ArrayFieldType");
        List stockAreas = StockArea.getStockAreas();
        int numStockAreas = stockAreas.size();
        this.setLayout(new GridLayout(0, 4));
        this.allStockAreas = new StockArea[numStockAreas];
        this.areaLabels = new JLabel[numStockAreas];
        this.unitLabels = new JLabel[numStockAreas];
        this.minFields = new JSpinner[numStockAreas];
        this.maxFields = new JSpinner[numStockAreas];
        JLabel fillerLabel1 = new JLabel(" ");
        JLabel fillerLabel2 = new JLabel(" ");
        this.add(fillerLabel1);
        this.add(this.minLabel);
        this.add(this.maxLabel);
        this.add(fillerLabel2);
        for (int i = 0; i < numStockAreas; ++i) {
            JTextField minText;
            StockArea area;
            this.allStockAreas[i] = area = (StockArea)stockAreas.get(i);
            this.areaLabels[i] = new JLabel(area.getLabel());
            this.areaLabels[i].setName("Area label " + area.getLabel());
            this.unitLabels[i] = new JLabel(this.unitContainer.getDisplayName());
            this.minFields[i] = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999999.0, 1.0));
            this.minFields[i].setName("Area min " + area.getLabel());
            this.maxFields[i] = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999999.0, 1.0));
            this.maxFields[i].setName("Area max " + area.getLabel());
            OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.minFields[i]);
            OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.maxFields[i]);
            FieldPanel.ControlKeyListener controlListener = new FieldPanel.ControlKeyListener();
            FieldPanel.InnerSecondaryActionListener secondaryListener = new FieldPanel.InnerSecondaryActionListener();
            if (i == 0) {
                minText = SuggestedOrderingFieldPanel.getTextForSpinner(this.minFields[i]);
                minText.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
                minText.addKeyListener(controlListener);
            } else {
                minText = SuggestedOrderingFieldPanel.getTextForSpinner(this.minFields[i]);
                minText.addActionListener(secondaryListener);
                minText.addKeyListener(controlListener);
                minText.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                minText.selectAll();
                            }
                        });
                    }
                });
            }
            final JTextField maxText = SuggestedOrderingFieldPanel.getTextForSpinner(this.maxFields[i]);
            maxText.addActionListener(secondaryListener);
            maxText.addKeyListener(controlListener);
            maxText.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            maxText.selectAll();
                        }
                    });
                }
            });
            this.add(this.areaLabels[i]);
            this.add(this.minFields[i]);
            this.add(this.maxFields[i]);
            this.add(this.unitLabels[i]);
        }
    }

    public MeasureUnitContainer getMeasureUnitContainer() {
        return this.unitContainer;
    }

    public void setMeasureUnitContainer(MeasureUnitContainer value) {
        this.unitContainer = value;
        if (this.minMaxList != null) {
            this.setValue(this.minMaxList);
        }
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        ArrayList<Pair> retval = new ArrayList<Pair>();
        for (int i = 0; i < this.allStockAreas.length; ++i) {
            StockArea area = this.allStockAreas[i];
            double min = (Double)this.minFields[i].getValue();
            double max = (Double)this.maxFields[i].getValue();
            double rawMin = new Quantity(this.unitContainer, min, false).getRawValue();
            double rawMax = new Quantity(this.unitContainer, max, false).getRawValue();
            Pair pair = new Pair((Object)area, (Object)new MinMax(rawMin, rawMax));
            retval.add(pair);
        }
        return retval;
    }

    @Override
    public void setValue(Object o) {
        this.minMaxList = (List)o;
        int numStockAreasToSet = this.minMaxList.size();
        block0: for (int i = 0; i < numStockAreasToSet; ++i) {
            Pair pair = (Pair)this.minMaxList.get(i);
            StockArea area = (StockArea)pair.key;
            MinMax minMax = (MinMax)pair.value;
            double convertedMin = new Quantity(this.unitContainer, minMax.min, true).doubleValue();
            double convertedMax = new Quantity(this.unitContainer, minMax.max, true).doubleValue();
            for (int j = 0; j < this.allStockAreas.length; ++j) {
                if (!this.allStockAreas[j].equals((Object)area)) continue;
                this.allStockAreas[j] = area;
                this.areaLabels[j].setText(area.getLabel());
                this.unitLabels[j].setText(this.unitContainer.getDisplayName());
                this.minFields[j].setValue(new Double(convertedMin));
                this.maxFields[j].setValue(new Double(convertedMax));
                continue block0;
            }
        }
    }

    @Override
    public void setToolTipText(String text) {
        int i;
        super.setToolTipText(text);
        for (i = 0; i < this.minFields.length; ++i) {
            this.minFields[i].setToolTipText(text);
        }
        for (i = 0; i < this.maxFields.length; ++i) {
            this.maxFields[i].setToolTipText(text);
        }
        this.minLabel.setToolTipText(text);
        this.maxLabel.setToolTipText(text);
        for (i = 0; i < this.areaLabels.length; ++i) {
            this.areaLabels[i].setToolTipText(text);
        }
        for (i = 0; i < this.unitLabels.length; ++i) {
            this.unitLabels[i].setToolTipText(text);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        int i;
        super.setEnabled(b);
        for (i = 0; i < this.minFields.length; ++i) {
            this.minFields[i].setEnabled(b);
        }
        for (i = 0; i < this.maxFields.length; ++i) {
            this.maxFields[i].setEnabled(b);
        }
        this.minLabel.setEnabled(b);
        this.maxLabel.setEnabled(b);
        for (i = 0; i < this.areaLabels.length; ++i) {
            this.areaLabels[i].setEnabled(b);
        }
        for (i = 0; i < this.unitLabels.length; ++i) {
            this.unitLabels[i].setEnabled(b);
        }
    }

    private static final JTextField getTextForSpinner(JSpinner spinner) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        return editor.getTextField();
    }

    @Override
    public JComponent getPrimaryComponent() {
        if (this.minFields.length > 0) {
            return SuggestedOrderingFieldPanel.getTextForSpinner(this.minFields[0]);
        }
        return this;
    }
}

